/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;

public class AttributesEditor {
    private final ProgramClass targetClass;
    private final ProgramMember targetMember;
    private final CodeAttribute targetAttribute;
    private final boolean replaceAttributes;

    public AttributesEditor(ProgramClass targetClass, boolean replaceAttributes) {
        this(targetClass, null, null, replaceAttributes);
    }

    public AttributesEditor(ProgramClass targetClass, ProgramMember targetMember, boolean replaceAttributes) {
        this(targetClass, targetMember, null, replaceAttributes);
    }

    public AttributesEditor(ProgramClass targetClass, ProgramMember targetMember, CodeAttribute targetAttribute, boolean replaceAttributes) {
        this.targetClass = targetClass;
        this.targetMember = targetMember;
        this.targetAttribute = targetAttribute;
        this.replaceAttributes = replaceAttributes;
    }

    public Attribute findAttribute(String attributeName) {
        return this.targetAttribute != null ? this.findAttribute(this.targetAttribute.u2attributesCount, this.targetAttribute.attributes, attributeName) : (this.targetMember != null ? this.findAttribute(this.targetMember.u2attributesCount, this.targetMember.attributes, attributeName) : this.findAttribute(this.targetClass.u2attributesCount, this.targetClass.attributes, attributeName));
    }

    public void addAttribute(Attribute attribute) {
        if (this.targetAttribute != null) {
            if (!this.replaceAttributes || !this.replaceAttribute(this.targetAttribute.u2attributesCount, this.targetAttribute.attributes, attribute)) {
                this.targetAttribute.attributes = this.addAttribute(this.targetAttribute.u2attributesCount, this.targetAttribute.attributes, attribute);
                ++this.targetAttribute.u2attributesCount;
            }
        } else if (this.targetMember != null) {
            if (!this.replaceAttributes || !this.replaceAttribute(this.targetMember.u2attributesCount, this.targetMember.attributes, attribute)) {
                this.targetMember.attributes = this.addAttribute(this.targetMember.u2attributesCount, this.targetMember.attributes, attribute);
                ++this.targetMember.u2attributesCount;
            }
        } else if (!this.replaceAttributes || !this.replaceAttribute(this.targetClass.u2attributesCount, this.targetClass.attributes, attribute)) {
            this.targetClass.attributes = this.addAttribute(this.targetClass.u2attributesCount, this.targetClass.attributes, attribute);
            ++this.targetClass.u2attributesCount;
        }
    }

    public void deleteAttribute(String attributeName) {
        if (this.targetAttribute != null) {
            this.targetAttribute.u2attributesCount = this.deleteAttribute(this.targetAttribute.u2attributesCount, this.targetAttribute.attributes, attributeName);
        } else if (this.targetMember != null) {
            this.targetMember.u2attributesCount = this.deleteAttribute(this.targetMember.u2attributesCount, this.targetMember.attributes, attributeName);
        } else {
            this.targetClass.u2attributesCount = this.deleteAttribute(this.targetClass.u2attributesCount, this.targetClass.attributes, attributeName);
        }
    }

    private boolean replaceAttribute(int attributesCount, Attribute[] attributes, Attribute attribute) {
        int index = this.findAttributeIndex(attributesCount, attributes, attribute.getAttributeName(this.targetClass));
        if (index < 0) {
            return false;
        }
        attributes[index] = attribute;
        return true;
    }

    private Attribute[] addAttribute(int attributesCount, Attribute[] attributes, Attribute attribute) {
        if (attributes.length <= attributesCount) {
            Attribute[] newAttributes = new Attribute[attributesCount + 1];
            System.arraycopy(attributes, 0, newAttributes, 0, attributesCount);
            attributes = newAttributes;
        }
        attributes[attributesCount] = attribute;
        return attributes;
    }

    private int deleteAttribute(int attributesCount, Attribute[] attributes, String attributeName) {
        int index = this.findAttributeIndex(attributesCount, attributes, attributeName);
        if (index < 0) {
            return attributesCount;
        }
        System.arraycopy(attributes, index + 1, attributes, index, attributesCount - index - 1);
        attributes[--attributesCount] = null;
        return attributesCount;
    }

    private int findAttributeIndex(int attributesCount, Attribute[] attributes, String attributeName) {
        for (int index = 0; index < attributesCount; ++index) {
            Attribute attribute = attributes[index];
            if (!attribute.getAttributeName(this.targetClass).equals(attributeName)) continue;
            return index;
        }
        return -1;
    }

    private Attribute findAttribute(int attributesCount, Attribute[] attributes, String attributeName) {
        for (int index = 0; index < attributesCount; ++index) {
            Attribute attribute = attributes[index];
            if (!attribute.getAttributeName(this.targetClass).equals(attributeName)) continue;
            return attribute;
        }
        return null;
    }
}

