/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.constant.Constant;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.InstructionSequenceReplacer;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.instruction.visitor.MultiInstructionVisitor;
import proguard.classfile.util.BranchTargetFinder;

public class InstructionSequencesReplacer
extends MultiInstructionVisitor
implements InstructionVisitor {
    private static final int PATTERN_INDEX = 0;
    private static final int REPLACEMENT_INDEX = 1;
    private static final Instruction[] EMPTY_INSTRUCTIONS = new Instruction[0];

    public InstructionSequencesReplacer(Constant[] constants, Instruction[][][] instructionSequences, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor) {
        this(constants, instructionSequences, branchTargetFinder, codeAttributeEditor, null);
    }

    public InstructionSequencesReplacer(Constant[] constants, Instruction[][][] instructionSequences, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor, InstructionVisitor extraInstructionVisitor) {
        super(InstructionSequencesReplacer.createInstructionSequenceReplacers(constants, instructionSequences, branchTargetFinder, codeAttributeEditor, extraInstructionVisitor));
    }

    private static InstructionVisitor[] createInstructionSequenceReplacers(Constant[] constants, Instruction[][][] instructionSequences, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor, InstructionVisitor extraInstructionVisitor) {
        InstructionVisitor[] instructionSequenceReplacers = new InstructionVisitor[instructionSequences.length];
        for (int index = 0; index < instructionSequenceReplacers.length; ++index) {
            Instruction[][] instructionSequencePair = instructionSequences[index];
            Instruction[] patternInstructions = instructionSequencePair[0];
            Instruction[] replacementInstructions = instructionSequencePair.length > 1 ? instructionSequencePair[1] : EMPTY_INSTRUCTIONS;
            instructionSequenceReplacers[index] = new InstructionSequenceReplacer(constants, patternInstructions, constants, replacementInstructions, branchTargetFinder, codeAttributeEditor, extraInstructionVisitor);
        }
        return instructionSequenceReplacers;
    }
}

