/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.editor.SubclassRemover;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;

public class InterfaceDeleter
implements ClassVisitor,
AttributeVisitor {
    private static boolean DEBUG = System.getProperty("id") != null;
    private final boolean[] delete;
    private final boolean removeSubclasses;

    public InterfaceDeleter(boolean[] delete, boolean removeSubclasses) {
        this.delete = delete;
        this.removeSubclasses = removeSubclasses;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        int[] interfaces = programClass.u2interfaces;
        int interfacesCount = programClass.u2interfacesCount;
        if (DEBUG) {
            System.out.println("InterfaceDeleter: " + programClass.getName() + " (" + interfacesCount + " interfaces)");
        }
        int newInterfacesCount = 0;
        for (int index = 0; index < interfacesCount; ++index) {
            if (DEBUG) {
                System.out.println("InterfaceDeleter:   " + (this.delete[index] ? "- " : "+ ") + programClass.getInterfaceName(index));
            }
            int interfaceIndex = interfaces[index];
            if (!this.delete[index]) {
                interfaces[newInterfacesCount++] = interfaceIndex;
                continue;
            }
            if (!this.removeSubclasses) continue;
            programClass.constantPoolEntryAccept(interfaceIndex, new ReferencedClassVisitor(new SubclassRemover(programClass)));
        }
        if (newInterfacesCount < interfacesCount) {
            programClass.u2interfacesCount = newInterfacesCount;
            programClass.attributesAccept(this);
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        Object[] referencedClasses = signatureAttribute.referencedClasses;
        if (referencedClasses != null) {
            int counter;
            int classCount;
            String type;
            InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(signatureAttribute.getSignature(clazz));
            StringBuffer newSignatureBuffer = new StringBuffer();
            int referencedClassIndex = 0;
            int newReferencedClassIndex = 0;
            if (internalTypeEnumeration.hasFormalTypeParameters()) {
                type = internalTypeEnumeration.formalTypeParameters();
                newSignatureBuffer.append(type);
                classCount = new DescriptorClassEnumeration(type).classCount();
                for (counter = 0; counter < classCount; ++counter) {
                    referencedClasses[newReferencedClassIndex++] = referencedClasses[referencedClassIndex++];
                }
                if (DEBUG) {
                    System.out.println("InterfaceDeleter:   type parameters = " + type);
                }
            }
            if (internalTypeEnumeration.hasMoreTypes()) {
                type = internalTypeEnumeration.nextType();
                newSignatureBuffer.append(type);
                classCount = new DescriptorClassEnumeration(type).classCount();
                for (counter = 0; counter < classCount; ++counter) {
                    referencedClasses[newReferencedClassIndex++] = referencedClasses[referencedClassIndex++];
                }
                if (DEBUG) {
                    System.out.println("InterfaceDeleter:   super class type = " + type);
                }
            }
            int index = 0;
            while (internalTypeEnumeration.hasMoreTypes()) {
                String type2 = internalTypeEnumeration.nextType();
                int classCount2 = new DescriptorClassEnumeration(type2).classCount();
                if (DEBUG) {
                    System.out.println("InterfaceDeleter:   interface type " + (this.delete[index] ? "- " : "+ ") + type2 + " (" + classCount2 + " referenced classes)");
                }
                if (!this.delete[index++]) {
                    newSignatureBuffer.append(type2);
                    for (int counter2 = 0; counter2 < classCount2; ++counter2) {
                        referencedClasses[newReferencedClassIndex++] = referencedClasses[referencedClassIndex++];
                    }
                    continue;
                }
                referencedClassIndex += classCount2;
            }
            ((Utf8Constant)((ProgramClass)clazz).constantPool[signatureAttribute.u2signatureIndex]).setString(newSignatureBuffer.toString());
            Arrays.fill(referencedClasses, newReferencedClassIndex, referencedClassIndex, null);
        }
    }
}

