/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class StringSharer
implements ClassVisitor,
ConstantVisitor,
AttributeVisitor {
    private String name;
    private String type;

    @Override
    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.constantPoolEntriesAccept(this);
        programClass.attributesAccept(this);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        Clazz superClass = libraryClass.superClass;
        if (superClass != null) {
            libraryClass.superClassName = superClass.getName();
        }
        if (libraryClass.interfaceNames != null) {
            String[] interfaceNames = libraryClass.interfaceNames;
            Clazz[] interfaceClasses = libraryClass.interfaceClasses;
            for (int index = 0; index < interfaceNames.length; ++index) {
                Clazz interfaceClass = interfaceClasses[index];
                if (interfaceClass == null) continue;
                interfaceNames[index] = interfaceClass.getName();
            }
        }
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        Member referencedMember = stringConstant.referencedMember;
        if (referencedMember != null) {
            Clazz referencedClass = stringConstant.referencedClass;
            this.name = referencedMember.getName(referencedClass);
            clazz.constantPoolEntryAccept(stringConstant.u2stringIndex, this);
        }
    }

    @Override
    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        Field referencedField = fieldrefConstant.referencedField;
        if (referencedField != null) {
            Clazz referencedClass = fieldrefConstant.referencedClass;
            this.name = referencedField.getName(referencedClass);
            this.type = referencedField.getDescriptor(referencedClass);
            clazz.constantPoolEntryAccept(fieldrefConstant.u2nameAndTypeIndex, this);
        }
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant) {
        Method referencedMethod = anyMethodrefConstant.referencedMethod;
        if (referencedMethod != null) {
            Clazz referencedClass = anyMethodrefConstant.referencedClass;
            this.name = referencedMethod.getName(referencedClass);
            this.type = referencedMethod.getDescriptor(referencedClass);
            clazz.constantPoolEntryAccept(anyMethodrefConstant.u2nameAndTypeIndex, this);
        }
    }

    @Override
    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        if (this.name != null) {
            clazz.constantPoolEntryAccept(nameAndTypeConstant.u2nameIndex, this);
            this.name = this.type;
            clazz.constantPoolEntryAccept(nameAndTypeConstant.u2descriptorIndex, this);
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        Clazz referencedClass = classConstant.referencedClass;
        if (referencedClass != null) {
            this.name = referencedClass.getName();
            clazz.constantPoolEntryAccept(classConstant.u2nameIndex, this);
        }
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        if (this.name != null) {
            if (this.name.equals(utf8Constant.getString())) {
                utf8Constant.setString(this.name);
            }
            this.name = null;
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        this.name = attribute.getAttributeName(clazz).intern();
        clazz.constantPoolEntryAccept(attribute.u2attributeNameIndex, this);
    }
}

