/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util.renderer;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import proguard.util.ProcessingFlags;

public abstract class ProcessableViewModel {
    private static final HashMap<Integer, String> PROCESSING_FLAG_MAP = new HashMap();
    private static final HashSet<Class<?>> KNOWN_FLAG_SET = new HashSet();
    protected List<String> processingFlags;
    protected Object processingInfo;

    public static List<String> renderProcessingFlags(int processingFlags) {
        ArrayList<String> renderedFlags = new ArrayList<String>();
        for (int key : PROCESSING_FLAG_MAP.keySet()) {
            if ((processingFlags & key) == 0) continue;
            renderedFlags.add(PROCESSING_FLAG_MAP.get(key));
        }
        return renderedFlags;
    }

    protected static <T extends ProcessingFlags> void addExtraProcessingFlags(Class<T> extraProcessingFlagsHolder) {
        if (KNOWN_FLAG_SET.contains(extraProcessingFlagsHolder)) {
            return;
        }
        KNOWN_FLAG_SET.add(extraProcessingFlagsHolder);
        Arrays.stream(extraProcessingFlagsHolder.getDeclaredFields()).forEach(field -> {
            try {
                if (Modifier.isStatic(field.getModifiers())) {
                    field.setAccessible(true);
                    PROCESSING_FLAG_MAP.put(field.getInt(null), field.getName());
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
    }

    static {
        ProcessableViewModel.addExtraProcessingFlags(ProcessingFlags.class);
    }
}

