/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import java.util.function.Predicate;
import proguard.classfile.Clazz;
import proguard.classfile.visitor.ClassVisitor;
import proguard.util.Processable;

public class ClassProcessingInfoFilter
implements ClassVisitor {
    private final Predicate<Object> predicate;
    private final ClassVisitor acceptedClassVisitor;
    private final ClassVisitor rejectedClassVisitor;

    public ClassProcessingInfoFilter(Predicate<Object> predicate, ClassVisitor acceptedClassVisitor) {
        this(predicate, acceptedClassVisitor, null);
    }

    public ClassProcessingInfoFilter(Predicate<Object> predicate, ClassVisitor acceptedClassVisitor, ClassVisitor rejectedClassVisitor) {
        this.predicate = predicate;
        this.acceptedClassVisitor = acceptedClassVisitor;
        this.rejectedClassVisitor = rejectedClassVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        ClassVisitor delegate = this.getDelegate(clazz);
        if (delegate != null) {
            clazz.accept(delegate);
        }
    }

    private ClassVisitor getDelegate(Processable processable) {
        return this.predicate.test(processable.getProcessingInfo()) ? this.acceptedClassVisitor : this.rejectedClassVisitor;
    }
}

