/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IdentifiedArrayReferenceValue;
import proguard.evaluation.value.IdentifiedDoubleValue;
import proguard.evaluation.value.IdentifiedFloatValue;
import proguard.evaluation.value.IdentifiedIntegerValue;
import proguard.evaluation.value.IdentifiedLongValue;
import proguard.evaluation.value.IdentifiedReferenceValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularValueFactory;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValueFactory;

public class IdentifiedValueFactory
extends ParticularValueFactory {
    protected int integerID;
    protected int longID;
    protected int floatID;
    protected int doubleID;
    protected int referenceID;

    @Override
    public IntegerValue createIntegerValue() {
        return new IdentifiedIntegerValue(this, this.integerID++);
    }

    @Override
    public LongValue createLongValue() {
        return new IdentifiedLongValue(this, this.longID++);
    }

    @Override
    public FloatValue createFloatValue() {
        return new IdentifiedFloatValue(this, this.floatID++);
    }

    @Override
    public DoubleValue createDoubleValue() {
        return new IdentifiedDoubleValue(this, this.doubleID++);
    }

    @Override
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull) {
        ReferenceValue referenceValue;
        if (type == null) {
            referenceValue = TypedReferenceValueFactory.REFERENCE_VALUE_NULL;
        } else {
            int n = this.referenceID++;
            referenceValue = new IdentifiedReferenceValue(type, referencedClass, mayBeExtension, mayBeNull, this, n);
        }
        return referenceValue;
    }

    @Override
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Object value) {
        return this.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull);
    }

    @Override
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Clazz creationClass, Method creationMethod, int creationOffset) {
        return this.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull);
    }

    @Override
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Clazz creationClass, Method creationMethod, int creationOffset, Object value) {
        return this.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull);
    }

    @Override
    public ReferenceValue createReferenceValueForId(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Object id) {
        return type == null ? TypedReferenceValueFactory.REFERENCE_VALUE_NULL : new IdentifiedReferenceValue(type, referencedClass, mayBeExtension, mayBeNull, this, id);
    }

    @Override
    public ReferenceValue createReferenceValueForId(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Object id, Object value) {
        return type == null ? TypedReferenceValueFactory.REFERENCE_VALUE_NULL : new IdentifiedReferenceValue(type, referencedClass, mayBeExtension, mayBeNull, this, id);
    }

    @Override
    public ReferenceValue createArrayReferenceValue(String type, Clazz referencedClass, IntegerValue arrayLength) {
        ReferenceValue referenceValue;
        if (type == null) {
            referenceValue = TypedReferenceValueFactory.REFERENCE_VALUE_NULL;
        } else {
            int n = this.referenceID++;
            referenceValue = new IdentifiedArrayReferenceValue('[' + type, referencedClass, false, arrayLength, this, n);
        }
        return referenceValue;
    }
}

