/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularDoubleValue;
import proguard.evaluation.value.ParticularFloatValue;
import proguard.evaluation.value.ParticularIntegerValue;
import proguard.evaluation.value.SpecificLongValue;

public final class ParticularLongValue
extends SpecificLongValue {
    private final long value;

    public ParticularLongValue(long value) {
        this.value = value;
    }

    @Override
    public long value() {
        return this.value;
    }

    @Override
    public LongValue negate() {
        return new ParticularLongValue(-this.value);
    }

    @Override
    public IntegerValue convertToInteger() {
        return new ParticularIntegerValue((int)this.value);
    }

    @Override
    public FloatValue convertToFloat() {
        return new ParticularFloatValue(this.value);
    }

    @Override
    public DoubleValue convertToDouble() {
        return new ParticularDoubleValue(this.value);
    }

    @Override
    public LongValue generalize(LongValue other) {
        return other.generalize(this);
    }

    @Override
    public LongValue add(LongValue other) {
        return other.add(this);
    }

    @Override
    public LongValue subtract(LongValue other) {
        return other.subtractFrom(this);
    }

    @Override
    public LongValue subtractFrom(LongValue other) {
        return other.subtract(this);
    }

    @Override
    public LongValue multiply(LongValue other) {
        return other.multiply(this);
    }

    @Override
    public LongValue divide(LongValue other) throws ArithmeticException {
        return other.divideOf(this);
    }

    @Override
    public LongValue divideOf(LongValue other) throws ArithmeticException {
        return other.divide(this);
    }

    @Override
    public LongValue remainder(LongValue other) throws ArithmeticException {
        return other.remainderOf(this);
    }

    @Override
    public LongValue remainderOf(LongValue other) throws ArithmeticException {
        return other.remainder(this);
    }

    @Override
    public LongValue shiftLeft(IntegerValue other) {
        return other.shiftLeftOf(this);
    }

    @Override
    public LongValue shiftRight(IntegerValue other) {
        return other.shiftRightOf(this);
    }

    @Override
    public LongValue unsignedShiftRight(IntegerValue other) {
        return other.unsignedShiftRightOf(this);
    }

    @Override
    public LongValue and(LongValue other) {
        return other.and(this);
    }

    @Override
    public LongValue or(LongValue other) {
        return other.or(this);
    }

    @Override
    public LongValue xor(LongValue other) {
        return other.xor(this);
    }

    @Override
    public IntegerValue compare(LongValue other) {
        return other.compareReverse(this);
    }

    @Override
    public LongValue generalize(ParticularLongValue other) {
        return this.generalize((SpecificLongValue)other);
    }

    @Override
    public LongValue add(ParticularLongValue other) {
        return new ParticularLongValue(this.value + other.value);
    }

    @Override
    public LongValue subtract(ParticularLongValue other) {
        return new ParticularLongValue(this.value - other.value);
    }

    @Override
    public LongValue subtractFrom(ParticularLongValue other) {
        return new ParticularLongValue(other.value - this.value);
    }

    @Override
    public LongValue multiply(ParticularLongValue other) {
        return new ParticularLongValue(this.value * other.value);
    }

    @Override
    public LongValue divide(ParticularLongValue other) throws ArithmeticException {
        return new ParticularLongValue(this.value / other.value);
    }

    @Override
    public LongValue divideOf(ParticularLongValue other) throws ArithmeticException {
        return new ParticularLongValue(other.value / this.value);
    }

    @Override
    public LongValue remainder(ParticularLongValue other) throws ArithmeticException {
        return new ParticularLongValue(this.value % other.value);
    }

    @Override
    public LongValue remainderOf(ParticularLongValue other) throws ArithmeticException {
        return new ParticularLongValue(other.value % this.value);
    }

    @Override
    public LongValue shiftLeft(ParticularIntegerValue other) {
        return new ParticularLongValue(this.value << other.value());
    }

    @Override
    public LongValue shiftRight(ParticularIntegerValue other) {
        return new ParticularLongValue(this.value >> other.value());
    }

    @Override
    public LongValue unsignedShiftRight(ParticularIntegerValue other) {
        return new ParticularLongValue(this.value >>> other.value());
    }

    @Override
    public LongValue and(ParticularLongValue other) {
        return new ParticularLongValue(this.value & other.value);
    }

    @Override
    public LongValue or(ParticularLongValue other) {
        return new ParticularLongValue(this.value | other.value);
    }

    @Override
    public LongValue xor(ParticularLongValue other) {
        return new ParticularLongValue(this.value ^ other.value);
    }

    @Override
    public boolean isParticular() {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.value == ((ParticularLongValue)object).value;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() ^ (int)this.value;
    }

    public String toString() {
        return this.value + "L";
    }
}

