/*
 * Decompiled with CFR 0.152.
 */
package proguard.resources.file.visitor;

import proguard.resources.file.FilePool;
import proguard.resources.file.ResourceFile;
import proguard.resources.file.ResourceFilePool;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.kotlinmodule.KotlinModule;

public class ResourceFilePresenceFilter
implements ResourceFileVisitor {
    private final FilePool filePool;
    private final ResourceFileVisitor presentResourceFileVisitor;
    private final ResourceFileVisitor missingResourceFileVisitor;

    public ResourceFilePresenceFilter(FilePool filePool, ResourceFileVisitor presentResourceFileVisitor, ResourceFileVisitor missingResourceFileVisitor) {
        this.filePool = filePool;
        this.presentResourceFileVisitor = presentResourceFileVisitor;
        this.missingResourceFileVisitor = missingResourceFileVisitor;
    }

    @Deprecated
    public ResourceFilePresenceFilter(ResourceFilePool resourceFilePool, ResourceFileVisitor presentResourceFileVisitor, ResourceFileVisitor missingResourceFileVisitor) {
        this.filePool = resourceFilePool;
        this.presentResourceFileVisitor = presentResourceFileVisitor;
        this.missingResourceFileVisitor = missingResourceFileVisitor;
    }

    @Override
    public void visitResourceFile(ResourceFile resourceFile) {
        ResourceFileVisitor resourceFileVisitor = this.resourceFileVisitor(resourceFile);
        if (resourceFileVisitor != null) {
            resourceFileVisitor.visitResourceFile(resourceFile);
        }
    }

    @Override
    public void visitKotlinModule(KotlinModule kotlinModule) {
        ResourceFileVisitor resourceFileVisitor = this.resourceFileVisitor(kotlinModule);
        if (resourceFileVisitor != null) {
            resourceFileVisitor.visitResourceFile(kotlinModule);
        }
    }

    protected ResourceFileVisitor resourceFileVisitor(ResourceFile resourceFile) {
        return this.filePool.getResourceFile(resourceFile.getFileName()) != null ? this.presentResourceFileVisitor : this.missingResourceFileVisitor;
    }
}

