/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.bam;

import org.jetbrains.annotations.NotNull;
import proguard.analysis.cpa.bam.BamCache;
import proguard.analysis.cpa.bam.BamTransferRelation;
import proguard.analysis.cpa.bam.CpaWithBamOperators;
import proguard.analysis.cpa.bam.ExpandOperator;
import proguard.analysis.cpa.bam.RebuildOperator;
import proguard.analysis.cpa.bam.ReduceOperator;
import proguard.analysis.cpa.interfaces.AbortOperator;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.ConfigurableProgramAnalysis;
import proguard.analysis.cpa.interfaces.MergeOperator;
import proguard.analysis.cpa.interfaces.PrecisionAdjustment;
import proguard.analysis.cpa.interfaces.StopOperator;
import proguard.analysis.cpa.interfaces.TransferRelation;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.classfile.MethodSignature;

public class BamCpa<ContentT extends AbstractState<ContentT>>
implements ConfigurableProgramAnalysis<JvmAbstractState<ContentT>> {
    private final CpaWithBamOperators<ContentT> wrappedCpa;
    private final BamTransferRelation<ContentT> bamTransferRelation;

    public BamCpa(CpaWithBamOperators<ContentT> wrappedCpa, JvmCfa cfa, MethodSignature mainFunction, BamCache<ContentT> cache) {
        this(wrappedCpa, cfa, mainFunction, cache, -1);
    }

    public BamCpa(CpaWithBamOperators<ContentT> wrappedCpa, JvmCfa cfa, MethodSignature mainFunction, BamCache<ContentT> cache, int maxCallStackDepth) {
        this.wrappedCpa = wrappedCpa;
        this.bamTransferRelation = new BamTransferRelation<ContentT>(this, cfa, mainFunction, cache, maxCallStackDepth);
    }

    @Override
    @NotNull
    public BamTransferRelation<ContentT> getTransferRelation() {
        return this.bamTransferRelation;
    }

    @Override
    @NotNull
    public MergeOperator<JvmAbstractState<ContentT>> getMergeOperator() {
        return this.wrappedCpa.getMergeOperator();
    }

    @Override
    @NotNull
    public StopOperator<JvmAbstractState<ContentT>> getStopOperator() {
        return this.wrappedCpa.getStopOperator();
    }

    @Override
    @NotNull
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.wrappedCpa.getPrecisionAdjustment();
    }

    @Override
    @NotNull
    public AbortOperator getAbortOperator() {
        return this.wrappedCpa.getAbortOperator();
    }

    public ReduceOperator<ContentT> getReduceOperator() {
        return this.wrappedCpa.getReduceOperator();
    }

    public ExpandOperator<ContentT> getExpandOperator() {
        return this.wrappedCpa.getExpandOperator();
    }

    public RebuildOperator getRebuildOperator() {
        return this.wrappedCpa.getRebuildOperator();
    }

    public BamCache<ContentT> getCache() {
        return this.bamTransferRelation.getCache();
    }

    public JvmCfa getCfa() {
        return this.bamTransferRelation.getCfa();
    }

    public TransferRelation<JvmAbstractState<ContentT>> getIntraproceduralTransferRelation() {
        return this.wrappedCpa.getTransferRelation();
    }
}

