/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.signature.ast.descriptor;

import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import proguard.classfile.attribute.signature.ast.ASTStructureException;
import proguard.classfile.attribute.signature.ast.descriptor.FieldTypeNode;
import proguard.classfile.attribute.signature.ast.descriptor.ReturnDescriptorNode;
import proguard.classfile.attribute.signature.ast.visitor.ASTNodeVisitor;

public class MethodDescriptorNode {
    @NotNull
    private List<FieldTypeNode> parameters;
    @NotNull
    private ReturnDescriptorNode returnDescriptor;

    public MethodDescriptorNode(@NotNull List<FieldTypeNode> parameters, @NotNull ReturnDescriptorNode returnDescriptor) {
        this.parameters = parameters;
        this.returnDescriptor = returnDescriptor;
    }

    @NotNull
    public List<FieldTypeNode> getParameters() {
        return this.parameters;
    }

    public void setParameters(@NotNull List<FieldTypeNode> parameters) {
        if (parameters == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.parameters = parameters;
    }

    @NotNull
    public ReturnDescriptorNode getReturnDescriptor() {
        return this.returnDescriptor;
    }

    public void setReturnDescriptor(@NotNull ReturnDescriptorNode returnDescriptor) {
        if (returnDescriptor == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.returnDescriptor = returnDescriptor;
    }

    public <R, P> R accept(ASTNodeVisitor<R, P> visitor, P arg) {
        return visitor.visit(this, arg);
    }

    public String toString() {
        return "(" + this.parameters.stream().map(Object::toString).collect(Collectors.joining()) + ")" + this.returnDescriptor.toString();
    }
}

