/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.signature.ast.descriptor;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.classfile.attribute.signature.ast.ASTStructureException;
import proguard.classfile.attribute.signature.ast.descriptor.FieldTypeNode;
import proguard.classfile.attribute.signature.ast.descriptor.VoidDescriptorNode;
import proguard.classfile.attribute.signature.ast.visitor.ASTNodeVisitor;

public class ReturnDescriptorNode {
    @Nullable
    private FieldTypeNode fieldType;
    @Nullable
    private VoidDescriptorNode voidDescriptor;

    public ReturnDescriptorNode(@NotNull FieldTypeNode fieldType) {
        if (fieldType == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.fieldType = fieldType;
        this.voidDescriptor = null;
    }

    public ReturnDescriptorNode(@NotNull VoidDescriptorNode voidDescriptor) {
        if (voidDescriptor == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.fieldType = null;
        this.voidDescriptor = voidDescriptor;
    }

    @Nullable
    public FieldTypeNode getFieldType() {
        return this.fieldType;
    }

    public void changeToFieldType(@NotNull FieldTypeNode fieldType) {
        if (fieldType == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.fieldType = fieldType;
        this.voidDescriptor = null;
    }

    public boolean isVoid() {
        return this.voidDescriptor != null;
    }

    public void changeToVoid() {
        this.voidDescriptor = VoidDescriptorNode.INSTANCE;
        this.fieldType = null;
    }

    public <R, P> R accept(ASTNodeVisitor<R, P> visitor, P arg) {
        return visitor.visit(this, arg);
    }

    public String toString() {
        if (this.fieldType != null) {
            return this.fieldType.toString();
        }
        if (this.voidDescriptor != null) {
            return this.voidDescriptor.toString();
        }
        throw new ASTStructureException("At least one of the fields must be non-null");
    }
}

