/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.signature.ast.signature;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.classfile.attribute.signature.ast.ASTStructureException;
import proguard.classfile.attribute.signature.ast.signature.ArrayTypeSignatureNode;
import proguard.classfile.attribute.signature.ast.signature.ClassTypeSignatureNode;
import proguard.classfile.attribute.signature.ast.signature.TypeVariableSignatureNode;
import proguard.classfile.attribute.signature.ast.visitor.ASTNodeVisitor;

public class ReferenceTypeSignatureNode {
    @Nullable
    private ClassTypeSignatureNode classType;
    @Nullable
    private TypeVariableSignatureNode typeVariable;
    @Nullable
    private ArrayTypeSignatureNode arrayType;

    public ReferenceTypeSignatureNode(@NotNull ClassTypeSignatureNode signature) {
        if (signature == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.classType = signature;
        this.arrayType = null;
        this.typeVariable = null;
    }

    public ReferenceTypeSignatureNode(@NotNull TypeVariableSignatureNode signature) {
        if (signature == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.classType = null;
        this.arrayType = null;
        this.typeVariable = signature;
    }

    public ReferenceTypeSignatureNode(@NotNull ArrayTypeSignatureNode signature) {
        if (signature == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.classType = null;
        this.arrayType = signature;
        this.typeVariable = null;
    }

    public boolean isClassType() {
        return this.classType != null;
    }

    @Nullable
    public ClassTypeSignatureNode getClassType() {
        return this.classType;
    }

    public void changeToClassType(@NotNull ClassTypeSignatureNode node) {
        if (node == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.classType = node;
        this.arrayType = null;
        this.typeVariable = null;
    }

    public boolean isTypeVariable() {
        return this.typeVariable != null;
    }

    @Nullable
    public TypeVariableSignatureNode getTypeVariable() {
        return this.typeVariable;
    }

    public void changeToTypeVariable(@NotNull TypeVariableSignatureNode node) {
        if (node == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.typeVariable = node;
        this.arrayType = null;
        this.classType = null;
    }

    public boolean isArrayType() {
        return this.arrayType != null;
    }

    @Nullable
    public ArrayTypeSignatureNode getArrayType() {
        return this.arrayType;
    }

    public void changeToArrayType(@NotNull ArrayTypeSignatureNode node) {
        if (node == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.arrayType = node;
        this.typeVariable = null;
        this.classType = null;
    }

    public <R, P> R accept(ASTNodeVisitor<R, P> visitor, P arg) {
        return visitor.visit(this, arg);
    }

    public String toString() {
        if (this.classType != null) {
            return this.classType.toString();
        }
        if (this.typeVariable != null) {
            return this.typeVariable.toString();
        }
        if (this.arrayType != null) {
            return this.arrayType.toString();
        }
        throw new ASTStructureException("At least one of the fields must be non-null");
    }
}

