/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.signature.grammars;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.classfile.attribute.signature.ast.signature.ClassBoundNode;
import proguard.classfile.attribute.signature.ast.signature.ClassSignatureNode;
import proguard.classfile.attribute.signature.ast.signature.InterfaceBoundNode;
import proguard.classfile.attribute.signature.ast.signature.ReferenceTypeSignatureNode;
import proguard.classfile.attribute.signature.ast.signature.SuperclassSignatureNode;
import proguard.classfile.attribute.signature.ast.signature.SuperinterfaceSignatureNode;
import proguard.classfile.attribute.signature.ast.signature.TypeParameterNode;
import proguard.classfile.attribute.signature.grammars.CommonTerminals;
import proguard.classfile.attribute.signature.grammars.TypeSignatureGrammar;
import proguard.classfile.attribute.signature.parsing.Combinators;
import proguard.classfile.attribute.signature.parsing.Parser;
import proguard.classfile.attribute.signature.parsing.Parsers;

public class ClassSignatureGrammar {
    static final Parser<ClassBoundNode> CLASS_BOUND = Combinators.chain(Parsers.fixedChar(':'), Combinators.optional(TypeSignatureGrammar.REFERENCE_TYPE_SIGNATURE), (nothing, ref) -> new ClassBoundNode(ref.orElse(null)));
    static final Parser<InterfaceBoundNode> INTERFACE_BOUND = Combinators.chain(Parsers.fixedChar(':'), TypeSignatureGrammar.REFERENCE_TYPE_SIGNATURE, (nothing, ref) -> new InterfaceBoundNode((ReferenceTypeSignatureNode)ref));
    static final Parser<TypeParameterNode> TYPE_PARAMETER = Combinators.chain(CommonTerminals.IDENTIFIER, CLASS_BOUND, Combinators.repeat(INTERFACE_BOUND), TypeParameterNode::new);
    static final Parser<List<TypeParameterNode>> TYPE_PARAMETERS = Combinators.chain(Parsers.fixedChar('<'), TYPE_PARAMETER, Combinators.repeat(TYPE_PARAMETER), Parsers.fixedChar('>'), (nothing, firstParam, params, nothing2) -> {
        params.add(0, firstParam);
        return params;
    });
    static final Parser<SuperinterfaceSignatureNode> SUPERINTERFACE_SIGNATURE = TypeSignatureGrammar.CLASS_TYPE_SIGNATURE.map(SuperinterfaceSignatureNode::new);
    static final Parser<SuperclassSignatureNode> SUPERCLASS_SIGNATURE = TypeSignatureGrammar.CLASS_TYPE_SIGNATURE.map(SuperclassSignatureNode::new);
    static final Parser<ClassSignatureNode> CLASS_SIGNATURE = Combinators.chain(Combinators.optional(TYPE_PARAMETERS), SUPERCLASS_SIGNATURE, Combinators.repeat(SUPERINTERFACE_SIGNATURE), (typeParams, superClass, superInterfaces) -> new ClassSignatureNode(typeParams.orElseGet(Collections::emptyList), (SuperclassSignatureNode)superClass, (List<SuperinterfaceSignatureNode>)superInterfaces));

    private ClassSignatureGrammar() {
    }

    @Nullable
    public static ClassSignatureNode parse(@NotNull String input) {
        return CLASS_SIGNATURE.parse(input);
    }
}

