/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.constant;

import proguard.classfile.Clazz;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.util.StringUtil;

public class Utf8Constant
extends Constant {
    private String string;

    public Utf8Constant() {
    }

    public Utf8Constant(String string) {
        this.string = string;
    }

    public void setBytes(byte[] bytes) {
        this.string = StringUtil.getString(bytes);
    }

    public byte[] getBytes() {
        return StringUtil.getModifiedUtf8Bytes(this.string);
    }

    public void setString(String utf8String) {
        this.string = utf8String;
    }

    public String getString() {
        return this.string;
    }

    @Override
    public int getTag() {
        return 1;
    }

    @Override
    public boolean isCategory2() {
        return false;
    }

    @Override
    public void accept(Clazz clazz, ConstantVisitor constantVisitor) {
        constantVisitor.visitUtf8Constant(clazz, this);
    }

    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Utf8Constant other = (Utf8Constant)object;
        return this.string.equals(other.string);
    }

    public int hashCode() {
        return 1 ^ this.string.hashCode();
    }

    public String toString() {
        return "Utf8(" + this.string + ")";
    }
}

