/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.Constant;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.evaluation.PartialEvaluator;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.Value;
import proguard.util.PartialEvaluatorUtils;

public class ArrayInitializationMatcher {
    private static final int X = 0x40000000;
    private final PartialEvaluator partialEvaluator;
    private int arrayInitializationStart;
    private int arrayInitializationEnd;
    private Object array;
    private final Constant[] CONSTANTS = new Constant[0];
    private final Instruction[] ARRAY_PRESTORE_INSTRUCTIONS = new Instruction[]{new VariableInstruction(58, 0x40000000), new VariableInstruction(25, 0x40000000)};
    private final InstructionSequenceMatcher arrayPreStoreMatcher = new InstructionSequenceMatcher(this.CONSTANTS, this.ARRAY_PRESTORE_INSTRUCTIONS);

    public ArrayInitializationMatcher() {
        this(new PartialEvaluator());
    }

    public ArrayInitializationMatcher(PartialEvaluator partialEvaluator) {
        this.partialEvaluator = partialEvaluator;
    }

    public boolean matchesArrayInitialization(Clazz clazz, Method method, CodeAttribute codeAttribute, int newArrayOffset, SimpleInstruction newArrayInstruction) {
        this.array = null;
        Value stackBeforeValue = PartialEvaluatorUtils.getStackBefore(this.partialEvaluator, newArrayOffset, 0);
        if (stackBeforeValue == null) {
            return false;
        }
        IntegerValue integerValue = stackBeforeValue.integerValue();
        if (!integerValue.isParticular()) {
            return false;
        }
        int arrayLength = integerValue.value();
        int newArrayType = newArrayInstruction.constant;
        byte arrayStoreOpcode = this.arrayStoreOpcode(newArrayType);
        byte[] code = codeAttribute.code;
        int offset = newArrayOffset;
        Instruction instruction = newArrayInstruction;
        int skipOffset = this.skipPreStoreInstructions(clazz, method, codeAttribute, offset + instruction.length(offset));
        if (skipOffset > 0) {
            newArrayOffset = offset = skipOffset;
            instruction = InstructionFactory.create(code, offset);
        }
        int tmpInitializationStart = offset + instruction.length(offset);
        for (int index = 0; index < arrayLength; ++index) {
            if ((instruction = InstructionFactory.create(code, offset += instruction.length(offset))).stackPushCount(clazz) < 1 || !this.partialEvaluator.getStackAfter(offset).getTopActualProducerValue(0).instructionOffsetValue().contains(newArrayOffset)) {
                return false;
            }
            if ((instruction = InstructionFactory.create(code, offset += instruction.length(offset))).stackPushCount(clazz) != 1) {
                return false;
            }
            Value indexValue = this.partialEvaluator.getStackAfter(offset).getTop(0);
            if (indexValue.computationalType() != 1 || !indexValue.integerValue().isParticular() || indexValue.integerValue().value() != index) {
                return false;
            }
            if ((instruction = InstructionFactory.create(code, offset += instruction.length(offset))).stackPushCount(clazz) < 1 || !this.partialEvaluator.getStackAfter(offset).getTop(0).isParticular()) {
                return false;
            }
            Value elementValue = this.partialEvaluator.getStackAfter(offset).getTop(0);
            offset += instruction.length(offset);
            instruction = InstructionFactory.create(code, offset);
            if (instruction.opcode != arrayStoreOpcode) {
                return false;
            }
            if (index == 0) {
                this.array = this.newArray(newArrayType, arrayLength);
            }
            this.arrayStore(newArrayType, this.array, index, elementValue);
        }
        this.arrayInitializationStart = tmpInitializationStart;
        this.arrayInitializationEnd = offset;
        return offset > newArrayOffset;
    }

    private int skipPreStoreInstructions(Clazz clazz, Method method, CodeAttribute codeAttribute, int startOffset) {
        Instruction instruction;
        int instructionCount = this.arrayPreStoreMatcher.instructionCount();
        this.arrayPreStoreMatcher.reset();
        int count = 0;
        for (int offset = startOffset; count < instructionCount && offset < codeAttribute.u4codeLength; offset += instruction.length(offset), ++count) {
            instruction = InstructionFactory.create(codeAttribute.code, offset);
            instruction.accept(clazz, method, codeAttribute, offset, this.arrayPreStoreMatcher);
        }
        if (this.arrayPreStoreMatcher.isMatching()) {
            return this.arrayPreStoreMatcher.matchedInstructionOffset(instructionCount - 1);
        }
        return -1;
    }

    public int arrayInitializationStart() {
        return this.arrayInitializationStart;
    }

    public int arrayInitializationEnd() {
        return this.arrayInitializationEnd;
    }

    public Object array() {
        return this.array;
    }

    private byte internalType(int newArrayType) {
        switch (newArrayType) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return 1;
            }
            case 11: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Unexpected new array type [" + newArrayType + "]");
    }

    private byte arrayStoreOpcode(int newArrayType) {
        switch (newArrayType) {
            case 4: 
            case 8: {
                return 84;
            }
            case 5: {
                return 85;
            }
            case 9: {
                return 86;
            }
            case 10: {
                return 79;
            }
            case 11: {
                return 80;
            }
            case 6: {
                return 81;
            }
            case 7: {
                return 82;
            }
        }
        throw new IllegalArgumentException("Unexpected new array type [" + newArrayType + "]");
    }

    private Object newArray(int newArrayType, int arrayLength) {
        switch (newArrayType) {
            case 4: {
                return new boolean[arrayLength];
            }
            case 8: {
                return new byte[arrayLength];
            }
            case 5: {
                return new char[arrayLength];
            }
            case 9: {
                return new short[arrayLength];
            }
            case 10: {
                return new int[arrayLength];
            }
            case 11: {
                return new long[arrayLength];
            }
            case 6: {
                return new float[arrayLength];
            }
            case 7: {
                return new double[arrayLength];
            }
        }
        throw new IllegalArgumentException("Unexpected new array type [" + newArrayType + "]");
    }

    private void arrayStore(int newArrayType, Object array, int index, Value value) {
        switch (newArrayType) {
            case 4: {
                ((boolean[])array)[index] = 0 != value.integerValue().value();
                break;
            }
            case 8: {
                ((byte[])array)[index] = (byte)value.integerValue().value();
                break;
            }
            case 5: {
                ((char[])array)[index] = (char)value.integerValue().value();
                break;
            }
            case 9: {
                ((short[])array)[index] = (short)value.integerValue().value();
                break;
            }
            case 10: {
                ((int[])array)[index] = value.integerValue().value();
                break;
            }
            case 11: {
                ((long[])array)[index] = value.longValue().value();
                break;
            }
            case 6: {
                ((float[])array)[index] = value.floatValue().value();
                break;
            }
            case 7: {
                ((double[])array)[index] = value.doubleValue().value();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected new array type [" + newArrayType + "]");
            }
        }
    }
}

