/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util.inject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.inject.argument.InjectedArgument;
import proguard.classfile.util.inject.location.InjectStrategy;

public class CodeInjector {
    private List<ClassMethodPair> targets;
    private ClassMethodPair content;
    private InjectStrategy injectStrategy;
    private List<InjectedArgument> arguments = new ArrayList<InjectedArgument>();

    public CodeInjector injectInvokeStatic(Clazz clazz, Method method) {
        assert (this.content == null) : "The injection content `" + CodeInjector.renderInjectionContent(this.content.clazz, this.content.method, this.arguments) + "` has already been specified.";
        assert ((method.getAccessFlags() & 8) != 0 && !method.getName(clazz).equals("<clinit>")) : "The method to be invoked must be a (non-class initializer) static method.";
        this.content = new ClassMethodPair(clazz, method);
        return this;
    }

    public CodeInjector injectInvokeStatic(Clazz clazz, Method method, InjectedArgument ... arguments) {
        this.injectInvokeStatic(clazz, method);
        InternalTypeEnumeration parametersIterator = new InternalTypeEnumeration(method.getDescriptor(clazz));
        Iterator argumentsIterator = Arrays.stream(arguments).iterator();
        while (parametersIterator.hasNext() || argumentsIterator.hasNext()) {
            String expectedType = parametersIterator.next();
            InjectedArgument provided = (InjectedArgument)argumentsIterator.next();
            assert (expectedType.equals(provided.getInternalType())) : String.format("Provided argument `%s` doesn't match the expected parameter type `%s` for method: %s", provided.getInternalType(), expectedType, CodeInjector.renderMethodSignature(this.content.clazz, this.content.method));
        }
        this.arguments = Arrays.asList(arguments);
        return this;
    }

    public CodeInjector into(ProgramClass programClass, ProgramMethod programMethod) {
        assert (this.targets == null) : "The injection target has already been specified.";
        this.targets = Collections.singletonList(new ClassMethodPair(programClass, programMethod));
        return this;
    }

    public CodeInjector at(InjectStrategy injectStrategy) {
        assert (this.injectStrategy == null) : "The injection strategy " + injectStrategy + " has already been specified.";
        this.injectStrategy = injectStrategy;
        return this;
    }

    public void commit() {
        assert (this.content != null) : "The injection content hasn't been provided; please use `.injectInvokeStatic(...)` to indicate the method invocation to be injected.";
        assert (this.targets != null) : "The injection target hasn't been provided; please use `.into(...)` to indicate the method targeted for injecting " + CodeInjector.renderInjectionContent(this.content.clazz, this.content.method, this.arguments) + ".";
        assert (this.injectStrategy != null) : "The injection location hasn't been provided. please use `.at(...)` to indicate the place to inject " + CodeInjector.renderInjectionContent(this.content.clazz, this.content.method, this.arguments) + " into the target method.";
        this.targets.forEach(target -> {
            CodeAttributeEditor editor = new CodeAttributeEditor();
            InstructionSequenceBuilder code = new InstructionSequenceBuilder((ProgramClass)target.clazz);
            this.arguments.forEach(argument -> code.pushPrimitiveOrString(argument.getValue(), argument.getInternalType()));
            code.invokestatic(this.content.clazz, this.content.method);
            target.method.accept(target.clazz, new AllAttributeVisitor(new AttributeNameFilter("Code", (AttributeVisitor)new InstructionInjector(editor, code, this.injectStrategy))));
        });
    }

    public boolean readyToCommit() {
        return this.content != null && this.targets != null && this.injectStrategy != null;
    }

    public List<ClassMethodPair> getTargets() {
        return this.targets;
    }

    public ClassMethodPair getContent() {
        return this.content;
    }

    public InjectStrategy getInjectStrategy() {
        return this.injectStrategy;
    }

    public List<InjectedArgument> getArguments() {
        return this.arguments;
    }

    private static String renderMethodSignature(Clazz clazz, Method method) {
        return ClassUtil.externalFullMethodDescription(clazz.getName(), method.getAccessFlags(), method.getName(clazz), method.getDescriptor(clazz));
    }

    private static String renderInjectionContent(Clazz clazz, Method method, List<InjectedArgument> arguments) {
        return clazz.getName() + method.getName(clazz) + "(" + arguments.stream().map(Object::toString).collect(Collectors.joining(",")) + "):" + ClassUtil.externalMethodReturnType(method.getDescriptor(clazz));
    }

    public static class ClassMethodPair {
        public Clazz clazz;
        public Method method;

        public ClassMethodPair(Clazz clazz, Method method) {
            this.clazz = clazz;
            this.method = method;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassMethodPair that = (ClassMethodPair)o;
            return Objects.equals(this.clazz, that.clazz) && Objects.equals(this.method, that.method);
        }

        public int hashCode() {
            return Objects.hash(this.clazz, this.method);
        }

        public String toString() {
            return this.clazz.getName() + "." + this.method.getName(this.clazz) + this.method.getDescriptor(this.clazz);
        }
    }

    private static class InstructionInjector
    implements AttributeVisitor {
        private final CodeAttributeEditor editor;
        private final InstructionSequenceBuilder code;
        private final InjectStrategy injectStrategy;

        private InstructionInjector(CodeAttributeEditor editor, InstructionSequenceBuilder code, InjectStrategy injectStrategy) {
            this.editor = editor;
            this.code = code;
            this.injectStrategy = injectStrategy;
        }

        @Override
        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            InjectStrategy.InjectLocation[] injectLocations;
            this.editor.reset(codeAttribute.u4codeLength);
            for (InjectStrategy.InjectLocation location : injectLocations = this.injectStrategy.getAllSuitableInjectionLocation((ProgramClass)clazz, (ProgramMethod)method)) {
                BiConsumer<Integer, Instruction[]> inserter = location.shouldInjectBefore() ? this.editor::insertBeforeOffset : this.editor::insertAfterInstruction;
                inserter.accept(location.getOffset(), this.code.instructions());
            }
            codeAttribute.accept(clazz, method, (AttributeVisitor)this.editor);
        }
    }
}

