/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;

public class MethodResult {
    private static final MethodResult INVALID_RESULT = new MethodResult();
    @Nullable
    private final Value returnValue;
    private final boolean isReturnValuePresent;
    @Nullable
    private final ReferenceValue updatedInstance;
    @Nullable
    private final List<Value> updatedParameters;

    private MethodResult() {
        this(null, false, null, null);
    }

    private MethodResult(@Nullable Value returnValue, boolean isReturnValuePresent, @Nullable ReferenceValue updatedInstance, @Nullable List<Value> updatedParameters) {
        this.returnValue = returnValue;
        this.isReturnValuePresent = isReturnValuePresent;
        this.updatedInstance = updatedInstance;
        this.updatedParameters = updatedParameters;
    }

    public static MethodResult invalidResult() {
        return INVALID_RESULT;
    }

    public boolean isResultValid() {
        return this != INVALID_RESULT;
    }

    public boolean isReturnValuePresent() {
        return this.isReturnValuePresent;
    }

    public boolean isInstanceUpdated() {
        return this.updatedInstance != null;
    }

    public boolean isAnyParameterUpdated() {
        return this.updatedParameters != null;
    }

    @Nullable
    public Value getReturnValue() {
        if (!this.isReturnValuePresent()) {
            throw new IllegalStateException("Should not try to retrieve an invalid return value, check 'isReturnValueValid()' first");
        }
        return this.returnValue;
    }

    @Nullable
    public ReferenceValue getUpdatedInstance() {
        if (!this.isInstanceUpdated()) {
            throw new IllegalStateException("Should not try to retrieve the updated instance value if the instance was not updated");
        }
        return this.updatedInstance;
    }

    @Nullable
    public List<Value> getUpdatedParameters() {
        if (!this.isAnyParameterUpdated()) {
            throw new IllegalStateException("Should not try to retrieve the updated parameters if no parameter was updated");
        }
        return this.updatedParameters;
    }

    public static class Builder {
        @Nullable
        private Value returnValue;
        private boolean isReturnValuePresent;
        @Nullable
        private ReferenceValue updatedInstance;
        @Nullable
        private List<Value> updatedParameters;

        public Builder setReturnValue(@Nullable Value returnValue) {
            if (this.isReturnValuePresent) {
                throw new IllegalStateException("The return value should just be set once");
            }
            this.isReturnValuePresent = true;
            this.returnValue = returnValue;
            return this;
        }

        public Builder setUpdatedInstance(@NotNull ReferenceValue updatedInstance) {
            if (this.updatedInstance != null) {
                throw new IllegalStateException("The updated instance value should just be set once");
            }
            Objects.requireNonNull(updatedInstance);
            this.updatedInstance = updatedInstance;
            return this;
        }

        public Builder setUpdatedParameters(List<Value> updatedParameters) {
            if (this.updatedParameters != null) {
                throw new IllegalStateException("The updated parameter values should just be set once");
            }
            Objects.requireNonNull(updatedParameters);
            this.updatedParameters = updatedParameters;
            return this;
        }

        public MethodResult build() {
            return new MethodResult(this.returnValue, this.isReturnValuePresent, this.updatedInstance, this.updatedParameters);
        }
    }
}

