/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import proguard.analysis.datastructure.CodeLocation;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.UnknownDoubleValue;
import proguard.evaluation.value.UnknownFloatValue;
import proguard.evaluation.value.UnknownIntegerValue;
import proguard.evaluation.value.UnknownLongValue;
import proguard.evaluation.value.UnknownReferenceValue;
import proguard.evaluation.value.UnknownValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.evaluation.value.object.AnalyzedObject;

public class BasicValueFactory
implements ValueFactory {
    public static final UnknownValue UNKNOWN_VALUE = new UnknownValue();
    public static final IntegerValue INTEGER_VALUE = new UnknownIntegerValue();
    public static final LongValue LONG_VALUE = new UnknownLongValue();
    public static final FloatValue FLOAT_VALUE = new UnknownFloatValue();
    public static final DoubleValue DOUBLE_VALUE = new UnknownDoubleValue();
    public static final ReferenceValue REFERENCE_VALUE = new UnknownReferenceValue();

    @Override
    public Value createValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull) {
        switch (type.charAt(0)) {
            case 'V': {
                return null;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.createIntegerValue();
            }
            case 'J': {
                return this.createLongValue();
            }
            case 'F': {
                return this.createFloatValue();
            }
            case 'D': {
                return this.createDoubleValue();
            }
        }
        return this.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull);
    }

    @Override
    public IntegerValue createIntegerValue() {
        return INTEGER_VALUE;
    }

    @Override
    public IntegerValue createIntegerValue(int value) {
        return this.createIntegerValue();
    }

    @Override
    public IntegerValue createIntegerValue(int min, int max) {
        return this.createIntegerValue();
    }

    @Override
    public LongValue createLongValue() {
        return LONG_VALUE;
    }

    @Override
    public LongValue createLongValue(long value) {
        return this.createLongValue();
    }

    @Override
    public FloatValue createFloatValue() {
        return FLOAT_VALUE;
    }

    @Override
    public FloatValue createFloatValue(float value) {
        return this.createFloatValue();
    }

    @Override
    public DoubleValue createDoubleValue() {
        return DOUBLE_VALUE;
    }

    @Override
    public DoubleValue createDoubleValue(double value) {
        return this.createDoubleValue();
    }

    @Override
    public ReferenceValue createReferenceValue() {
        return REFERENCE_VALUE;
    }

    @Override
    public ReferenceValue createReferenceValueNull() {
        return REFERENCE_VALUE;
    }

    @Override
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull) {
        return this.createReferenceValue();
    }

    @Override
    @Deprecated
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Object value) {
        return this.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull);
    }

    @Override
    public ReferenceValue createReferenceValue(Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, @NotNull AnalyzedObject value) {
        BasicValueFactory.checkReferenceValue(value);
        Object valueContent = value.isModeled() ? value.getModeledValue() : value.getPreciseValue();
        return this.createReferenceValue(value.getType(), referencedClass, mayBeExtension, mayBeNull, valueContent);
    }

    @Override
    @Deprecated
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Clazz creationClass, Method creationMethod, int creationOffset) {
        return this.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull);
    }

    @Override
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, CodeLocation creationLocation) {
        BasicValueFactory.checkCreationLocation(creationLocation);
        return this.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull, creationLocation.clazz, (Method)creationLocation.member, creationLocation.offset);
    }

    @Override
    @Deprecated
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Clazz creationClass, Method creationMethod, int creationOffset, Object value) {
        return this.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull);
    }

    @Override
    public ReferenceValue createReferenceValue(Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, CodeLocation creationLocation, @NotNull AnalyzedObject value) {
        BasicValueFactory.checkReferenceValue(value);
        BasicValueFactory.checkCreationLocation(creationLocation);
        Object valueContent = value.isModeled() ? value.getModeledValue() : value.getPreciseValue();
        return this.createReferenceValue(value.getType(), referencedClass, mayBeExtension, mayBeNull, creationLocation.clazz, (Method)creationLocation.member, creationLocation.offset, valueContent);
    }

    @Override
    public ReferenceValue createReferenceValueForId(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Object id) {
        return this.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull);
    }

    @Override
    @Deprecated
    public ReferenceValue createReferenceValueForId(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Object id, Object value) {
        return this.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull);
    }

    @Override
    public ReferenceValue createReferenceValueForId(Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Object id, @NotNull AnalyzedObject value) {
        BasicValueFactory.checkReferenceValue(value);
        Object valueContent = value.isModeled() ? value.getModeledValue() : value.getPreciseValue();
        return this.createReferenceValueForId(value.getType(), referencedClass, mayBeExtension, mayBeNull, id, valueContent);
    }

    @Override
    public ReferenceValue createArrayReferenceValue(String type, Clazz referencedClass, IntegerValue arrayLength) {
        return this.createReferenceValue(type, referencedClass, false, false);
    }

    @Override
    public ReferenceValue createArrayReferenceValue(String type, Clazz referencedClass, IntegerValue arrayLength, Object elementValues) {
        return this.createArrayReferenceValue(type, referencedClass, arrayLength);
    }

    protected static void checkReferenceValue(AnalyzedObject value) {
        Objects.requireNonNull(value, "The object value should not be null");
    }

    protected static void checkCreationLocation(CodeLocation creationLocation) {
        if (!(creationLocation.member instanceof Method)) {
            throw new IllegalStateException("The creation location needs to be in a method");
        }
    }
}

