/*
 * Decompiled with CFR 0.152.
 */
package proguard.resources.kotlinmodule.util;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMultiFilePartKindMetadata;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.resources.kotlinmodule.KotlinModule;
import proguard.resources.kotlinmodule.KotlinModulePackage;
import proguard.resources.kotlinmodule.visitor.KotlinModulePackageVisitor;

public class KotlinModuleReferenceInitializer
implements ResourceFileVisitor,
KotlinModulePackageVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final KotlinReferenceFinder finder = new KotlinReferenceFinder();

    public KotlinModuleReferenceInitializer(ClassPool programClassPool, ClassPool libraryClassPool) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
    }

    @Override
    public void visitKotlinModule(KotlinModule kotlinModule) {
        kotlinModule.modulePackagesAccept(this);
    }

    @Override
    public void visitKotlinModulePackage(KotlinModule kotlinModule, KotlinModulePackage modulePackage) {
        for (int i = 0; i < modulePackage.fileFacadeNames.size(); ++i) {
            Clazz clazz = this.programClassPool.getClass(modulePackage.fileFacadeNames.get(i));
            if (clazz == null) continue;
            clazz.kotlinMetadataAccept(this.finder.reset());
            KotlinFileFacadeKindMetadata fileFacadeKindMetadata = this.finder.fileFacadeKindMetadata;
            if (fileFacadeKindMetadata == null) continue;
            fileFacadeKindMetadata.referencedModule = kotlinModule;
            modulePackage.referencedFileFacades.set(i, fileFacadeKindMetadata);
        }
        modulePackage.multiFileClassParts.forEach((multiFilePartName, multiFileFacadeName) -> {
            Clazz multiFilePartClass = this.programClassPool.getClass((String)multiFilePartName);
            if (multiFilePartClass != null) {
                multiFilePartClass.kotlinMetadataAccept(this.finder.reset());
                KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata = this.finder.kotlinMultiFilePartKindMetadata;
                if (kotlinMultiFilePartKindMetadata != null) {
                    kotlinMultiFilePartKindMetadata.referencedModule = kotlinModule;
                    modulePackage.referencedMultiFileParts.put((String)multiFilePartName, kotlinMultiFilePartKindMetadata);
                }
            }
        });
    }

    private static class KotlinReferenceFinder
    implements KotlinMetadataVisitor {
        KotlinFileFacadeKindMetadata fileFacadeKindMetadata;
        KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata;

        private KotlinReferenceFinder() {
        }

        public KotlinReferenceFinder reset() {
            this.fileFacadeKindMetadata = null;
            this.kotlinMultiFilePartKindMetadata = null;
            return this;
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        @Override
        public void visitKotlinFileFacadeMetadata(Clazz clazz, KotlinFileFacadeKindMetadata kotlinFileFacadeKindMetadata) {
            this.fileFacadeKindMetadata = kotlinFileFacadeKindMetadata;
        }

        @Override
        public void visitKotlinMultiFilePartMetadata(Clazz clazz, KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata) {
            this.kotlinMultiFilePartKindMetadata = kotlinMultiFilePartKindMetadata;
        }
    }
}

