/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.util.HierarchyProvider;

public class BasicHierarchyProvider
implements HierarchyProvider {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;

    public BasicHierarchyProvider(ClassPool programClassPool, ClassPool libraryClassPool) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
    }

    @Override
    public Clazz getClazz(String className) {
        Clazz clazz = this.programClassPool.getClass(className);
        if (clazz == null) {
            clazz = this.libraryClassPool.getClass(className);
        }
        return clazz;
    }

    @Override
    public Set<String> getSubClasses(String className) {
        HashSet subClasses = new HashSet();
        ClassHierarchyTraveler subClassSignatureCollector = new ClassHierarchyTraveler(false, false, false, true, subClasses::add);
        this.programClassPool.classAccept(className, subClassSignatureCollector);
        this.libraryClassPool.classAccept(className, subClassSignatureCollector);
        return subClasses.stream().map(Clazz::getName).collect(Collectors.toSet());
    }
}

