/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueArray
extends Value {
    private final Value[] values;
    private int hash;

    private ValueArray(Value[] valueArray) {
        this.values = valueArray;
    }

    public static ValueArray get(Value[] valueArray) {
        return new ValueArray(valueArray);
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int n = 1;
        for (Value value : this.values) {
            n = n * 31 + value.hashCode();
        }
        this.hash = n;
        return n;
    }

    public Value[] getList() {
        return this.values;
    }

    public int getType() {
        return 17;
    }

    public long getPrecision() {
        long l = 0L;
        for (Value value : this.values) {
            l += value.getPrecision();
        }
        return l;
    }

    public String getString() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        for (Value value : this.values) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(value.getString());
        }
        return statementBuilder.append(')').toString();
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueArray valueArray = (ValueArray)value;
        if (this.values == valueArray.values) {
            return 0;
        }
        int n = this.values.length;
        int n2 = valueArray.values.length;
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            Value value2 = this.values[i];
            Value value3 = valueArray.values[i];
            int n4 = value2.compareTo(value3, compareMode);
            if (n4 == 0) continue;
            return n4;
        }
        return n > n2 ? 1 : (n == n2 ? 0 : -1);
    }

    public Object getObject() {
        int n = this.values.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.values[i].getObject();
        }
        return objectArray;
    }

    public void set(PreparedStatement preparedStatement, int n) {
        throw this.throwUnsupportedExceptionForType("PreparedStatement.set");
    }

    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        for (Value value : this.values) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(value.getSQL());
        }
        if (this.values.length == 1) {
            statementBuilder.append(',');
        }
        return statementBuilder.append(')').toString();
    }

    public String getTraceSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        for (Value value : this.values) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(value.getTraceSQL());
        }
        return statementBuilder.append(')').toString();
    }

    public int getDisplaySize() {
        long l = 0L;
        for (Value value : this.values) {
            l += (long)value.getDisplaySize();
        }
        return MathUtils.convertLongToInt(l);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ValueArray)) {
            return false;
        }
        ValueArray valueArray = (ValueArray)object;
        if (this.values == valueArray.values) {
            return true;
        }
        int n = this.values.length;
        if (n != valueArray.values.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.values[i].equals(valueArray.values[i])) continue;
            return false;
        }
        return true;
    }

    public int getMemory() {
        int n = 32;
        for (Value value : this.values) {
            n += value.getMemory() + 8;
        }
        return n;
    }

    public Value convertPrecision(long l, boolean bl) {
        if (!bl) {
            return this;
        }
        ArrayList<Value> arrayList = New.arrayList();
        for (Value value : this.values) {
            if ((l -= Math.max(1L, (value = value.convertPrecision(l, true)).getPrecision())) < 0L) break;
            arrayList.add(value);
        }
        Value[] valueArray = new Value[arrayList.size()];
        arrayList.toArray(valueArray);
        return ValueArray.get(valueArray);
    }
}

