/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.util.StringUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class QueryCacheConfigBuilderHelper
extends AbstractXmlConfigHelper {
    QueryCacheConfigBuilderHelper() {
    }

    void handleQueryCache(ClientConfig clientConfig, Node node) {
        for (Node queryCacheNode : new AbstractXmlConfigHelper.IterableNodeList(node.getChildNodes())) {
            if (!"query-cache".equals(this.cleanNodeName(queryCacheNode))) continue;
            NamedNodeMap attrs = queryCacheNode.getAttributes();
            String cacheName = this.getTextContent(attrs.getNamedItem("name"));
            String mapName = this.getTextContent(attrs.getNamedItem("mapName"));
            QueryCacheConfig queryCacheConfig = new QueryCacheConfig(cacheName);
            for (Node childNode : new AbstractXmlConfigHelper.IterableNodeList(queryCacheNode.getChildNodes())) {
                String textContent = this.getTextContent(childNode);
                String nodeName = this.cleanNodeName(childNode);
                this.populateQueryCacheConfig(queryCacheConfig, childNode, textContent, nodeName);
            }
            clientConfig.addQueryCacheConfig(mapName, queryCacheConfig);
        }
    }

    private void populateQueryCacheConfig(QueryCacheConfig queryCacheConfig, Node childNode, String textContent, String nodeName) {
        if ("entry-listeners".equals(nodeName)) {
            this.handleEntryListeners(queryCacheConfig, childNode);
        } else if ("include-value".equals(nodeName)) {
            boolean includeValue = this.checkTrue(textContent);
            queryCacheConfig.setIncludeValue(includeValue);
        } else if ("batch-size".equals(nodeName)) {
            int batchSize = this.getIntegerValue("batch-size", textContent.trim(), 1);
            queryCacheConfig.setBatchSize(batchSize);
        } else if ("buffer-size".equals(nodeName)) {
            int bufferSize = this.getIntegerValue("buffer-size", textContent.trim(), 16);
            queryCacheConfig.setBufferSize(bufferSize);
        } else if ("delay-seconds".equals(nodeName)) {
            int delaySeconds = this.getIntegerValue("delay-seconds", textContent.trim(), 0);
            queryCacheConfig.setDelaySeconds(delaySeconds);
        } else if ("in-memory-format".equals(nodeName)) {
            String value = textContent.trim();
            queryCacheConfig.setInMemoryFormat(InMemoryFormat.valueOf(StringUtil.upperCaseInternal(value)));
        } else if ("coalesce".equals(nodeName)) {
            boolean coalesce = this.checkTrue(textContent);
            queryCacheConfig.setCoalesce(coalesce);
        } else if ("populate".equals(nodeName)) {
            boolean populate = this.checkTrue(textContent);
            queryCacheConfig.setPopulate(populate);
        } else if ("indexes".equals(nodeName)) {
            this.queryCacheIndexesHandle(childNode, queryCacheConfig);
        } else if ("predicate".equals(nodeName)) {
            this.queryCachePredicateHandler(childNode, queryCacheConfig);
        } else if ("eviction".equals(nodeName)) {
            queryCacheConfig.setEvictionConfig(this.getEvictionConfig(childNode));
        }
    }

    private EvictionConfig getEvictionConfig(Node node) {
        EvictionConfig evictionConfig = new EvictionConfig();
        Node size = node.getAttributes().getNamedItem("size");
        Node maxSizePolicy = node.getAttributes().getNamedItem("max-size-policy");
        Node evictionPolicy = node.getAttributes().getNamedItem("eviction-policy");
        if (size != null) {
            evictionConfig.setSize(Integer.parseInt(this.getTextContent(size)));
        }
        if (maxSizePolicy != null) {
            evictionConfig.setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(maxSizePolicy))));
        }
        if (evictionPolicy != null) {
            evictionConfig.setEvictionPolicy(EvictionPolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(evictionPolicy))));
        }
        return evictionConfig;
    }

    private void handleEntryListeners(QueryCacheConfig queryCacheConfig, Node childNode) {
        for (Node listenerNode : new AbstractXmlConfigHelper.IterableNodeList(childNode.getChildNodes())) {
            if (!"entry-listener".equals(this.cleanNodeName(listenerNode))) continue;
            NamedNodeMap listenerNodeAttributes = listenerNode.getAttributes();
            boolean incValue = this.checkTrue(this.getTextContent(listenerNodeAttributes.getNamedItem("include-value")));
            boolean local = this.checkTrue(this.getTextContent(listenerNodeAttributes.getNamedItem("local")));
            String listenerClass = this.getTextContent(listenerNode);
            queryCacheConfig.addEntryListenerConfig(new EntryListenerConfig(listenerClass, local, incValue));
        }
    }

    private void queryCachePredicateHandler(Node childNode, QueryCacheConfig queryCacheConfig) {
        NamedNodeMap predicateAttributes = childNode.getAttributes();
        String predicateType = this.getTextContent(predicateAttributes.getNamedItem("type"));
        String textContent = this.getTextContent(childNode);
        PredicateConfig predicateConfig = new PredicateConfig();
        if ("class-name".equals(predicateType)) {
            predicateConfig.setClassName(textContent);
        } else if ("sql".equals(predicateType)) {
            predicateConfig.setSql(textContent);
        }
        queryCacheConfig.setPredicateConfig(predicateConfig);
    }

    private void queryCacheIndexesHandle(Node n, QueryCacheConfig queryCacheConfig) {
        for (Node indexNode : new AbstractXmlConfigHelper.IterableNodeList(n.getChildNodes())) {
            if (!"index".equals(this.cleanNodeName(indexNode))) continue;
            NamedNodeMap attrs = indexNode.getAttributes();
            boolean ordered = this.checkTrue(this.getTextContent(attrs.getNamedItem("ordered")));
            String attribute = this.getTextContent(indexNode);
            queryCacheConfig.addIndexConfig(new MapIndexConfig(attribute, ordered));
        }
    }
}

