/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ListMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Collection;
import java.util.HashSet;

@SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class ListContainsAllCodec {
    public static final ListMessageType REQUEST_TYPE = ListMessageType.LIST_CONTAINSALL;
    public static final int RESPONSE_TYPE = 101;
    public static final boolean RETRYABLE = true;

    public static ClientMessage encodeRequest(String name, Collection<Data> valueSet) {
        int requiredDataSize = RequestParameters.calculateDataSize(name, valueSet);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(true);
        clientMessage.set(name);
        clientMessage.set(valueSet.size());
        for (Data valueSet_item : valueSet) {
            clientMessage.set(valueSet_item);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        HashSet<Data> valueSet = null;
        int valueSet_size = clientMessage.getInt();
        valueSet = new HashSet<Data>(valueSet_size);
        for (int valueSet_index = 0; valueSet_index < valueSet_size; ++valueSet_index) {
            Data valueSet_item = clientMessage.getData();
            valueSet.add(valueSet_item);
        }
        parameters.valueSet = valueSet;
        return parameters;
    }

    public static ClientMessage encodeResponse(boolean response) {
        int requiredDataSize = ResponseParameters.calculateDataSize(response);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(101);
        clientMessage.set(response);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        boolean response;
        ResponseParameters parameters = new ResponseParameters();
        parameters.response = response = clientMessage.getBoolean();
        return parameters;
    }

    public static class ResponseParameters {
        public boolean response;

        public static int calculateDataSize(boolean response) {
            int dataSize = ClientMessage.HEADER_SIZE;
            return ++dataSize;
        }
    }

    public static class RequestParameters {
        public static final ListMessageType TYPE = REQUEST_TYPE;
        public String name;
        public Collection<Data> valueSet;

        public static int calculateDataSize(String name, Collection<Data> valueSet) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateStringDataSize(name);
            dataSize += 4;
            for (Data valueSet_item : valueSet) {
                dataSize += ParameterUtil.calculateDataSize(valueSet_item);
            }
            return dataSize;
        }
    }
}

