/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.Bits;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.HashUtil;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Arrays;

@SuppressWarnings(value={"EI_EXPOSE_REP"})
public final class DefaultData
implements Data {
    static final int TYPE_OFFSET = 0;
    static final int PARTITION_HASH_BIT_OFFSET = 4;
    static final int DATA_OFFSET = 5;
    private static final int ARRAY_HEADER_SIZE_IN_BYTES = 16;
    private byte[] data;

    public DefaultData() {
    }

    public DefaultData(byte[] data) {
        if (data != null && data.length > 0 && data.length < 5) {
            throw new IllegalArgumentException("Data should be either empty or should contain more than 5 bytes! -> " + Arrays.toString(data));
        }
        this.data = data;
    }

    @Override
    public int dataSize() {
        return Math.max(this.totalSize() - 5, 0);
    }

    @Override
    public int totalSize() {
        return this.data != null ? this.data.length : 0;
    }

    @Override
    public int getPartitionHash() {
        if (this.hasPartitionHash()) {
            return Bits.readIntB(this.data, this.data.length - 4);
        }
        return this.hashCode();
    }

    @Override
    public boolean hasPartitionHash() {
        return this.totalSize() != 0 && this.data[4] != 0;
    }

    @Override
    public byte[] toByteArray() {
        return this.data;
    }

    @Override
    public int getType() {
        if (this.totalSize() == 0) {
            return 0;
        }
        return Bits.readIntB(this.data, 0);
    }

    @Override
    public int getHeapCost() {
        int objectRef = 4;
        return objectRef + (this.data != null ? 16 + this.data.length : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Data)) {
            return false;
        }
        Data data = (Data)o;
        if (this.getType() != data.getType()) {
            return false;
        }
        int dataSize = this.dataSize();
        if (dataSize != data.dataSize()) {
            return false;
        }
        return dataSize == 0 || DefaultData.equals(this.data, data.toByteArray());
    }

    private static boolean equals(byte[] data1, byte[] data2) {
        if (data1 == data2) {
            return true;
        }
        if (data1 == null || data2 == null) {
            return false;
        }
        int length = data1.length;
        if (data2.length != length) {
            return false;
        }
        for (int i = length - 1; i >= 5; --i) {
            if (data1[i] == data2[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return HashUtil.MurmurHash3_x86_32(this.data, 5, this.dataSize());
    }

    @Override
    public long hash64() {
        return HashUtil.MurmurHash3_x64_64(this.data, 5, this.dataSize());
    }

    @Override
    public boolean isPortable() {
        return -1 == this.getType();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultData{");
        sb.append("type=").append(this.getType());
        sb.append(", hashCode=").append(this.hashCode());
        sb.append(", partitionHash=").append(this.getPartitionHash());
        sb.append(", totalSize=").append(this.totalSize());
        sb.append(", dataSize=").append(this.dataSize());
        sb.append(", heapCost=").append(this.getHeapCost());
        sb.append('}');
        return sb.toString();
    }
}

