/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ClientFlakeIdGeneratorConfig;
import com.hazelcast.client.config.ClientIcmpPingConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.util.RandomLB;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.config.ConfigXmlGenerator;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NearCachePreloaderConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.security.Credentials;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.StringUtil;
import java.io.Closeable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class ClientConfigXmlGenerator {
    private static final ILogger LOGGER = Logger.getLogger(ClientConfigXmlGenerator.class);

    private ClientConfigXmlGenerator() {
    }

    public static String generate(ClientConfig clientConfig) {
        return ClientConfigXmlGenerator.generate(clientConfig, -1);
    }

    public static String generate(ClientConfig clientConfig, int indent) {
        Preconditions.isNotNull((Object)clientConfig, (String)"ClientConfig");
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        ConfigXmlGenerator.XmlGenerator gen = new ConfigXmlGenerator.XmlGenerator(xml);
        gen.open("hazelcast-client", new Object[]{"xmlns", "http://www.hazelcast.com/schema/client-config", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.hazelcast.com/schema/client-config http://www.hazelcast.com/schema/client-config/hazelcast-client-config-3.11.xsd"});
        ClientConfigXmlGenerator.group(gen, clientConfig.getGroupConfig());
        gen.node("instance-name", (Object)clientConfig.getInstanceName(), new Object[0]);
        gen.appendProperties(clientConfig.getProperties());
        ClientConfigXmlGenerator.network(gen, clientConfig.getNetworkConfig());
        if (clientConfig.getExecutorPoolSize() > 0) {
            gen.node("executor-pool-size", (Object)clientConfig.getExecutorPoolSize(), new Object[0]);
        }
        ClientConfigXmlGenerator.security(gen, clientConfig.getSecurityConfig());
        ClientConfigXmlGenerator.listener(gen, clientConfig.getListenerConfigs());
        ClientConfigXmlGenerator.serialization(gen, clientConfig.getSerializationConfig());
        ClientConfigXmlGenerator.nativeMemory(gen, clientConfig.getNativeMemoryConfig());
        ClientConfigXmlGenerator.proxyFactory(gen, clientConfig.getProxyFactoryConfigs());
        ClientConfigXmlGenerator.loadBalancer(gen, clientConfig.getLoadBalancer());
        ClientConfigXmlGenerator.nearCaches(gen, clientConfig.getNearCacheConfigMap());
        ClientConfigXmlGenerator.queryCaches(gen, clientConfig.getQueryCacheConfigs());
        ClientConnectionStrategyConfig connectionStrategy = clientConfig.getConnectionStrategyConfig();
        gen.node("connection-strategy", null, new Object[]{"async-start", connectionStrategy.isAsyncStart(), "reconnect-mode", connectionStrategy.getReconnectMode()});
        ClientConfigXmlGenerator.userCodeDeployment(gen, clientConfig.getUserCodeDeploymentConfig());
        ClientConfigXmlGenerator.flakeIdGenerator(gen, clientConfig.getFlakeIdGeneratorConfigMap());
        gen.close();
        return ClientConfigXmlGenerator.format(xml.toString(), indent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String format(String input, int indent) {
        if (indent < 0) {
            return input;
        }
        if (indent == 0) {
            throw new IllegalArgumentException("Indent should be greater than 0");
        }
        StreamResult xmlOutput = null;
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(input));
            xmlOutput = new StreamResult(new StringWriter());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                transformerFactory.setAttribute("indent-number", indent);
            }
            catch (IllegalArgumentException e) {
                ClientConfigXmlGenerator.logFinest("Failed to set indent-number attribute; cause: " + e.getMessage());
            }
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            try {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent));
            }
            catch (IllegalArgumentException e) {
                ClientConfigXmlGenerator.logFinest("Failed to set indent-amount property; cause: " + e.getMessage());
            }
            transformer.transform(xmlInput, xmlOutput);
            String string = xmlOutput.getWriter().toString();
            return string;
        }
        catch (Exception e) {
            LOGGER.warning((Throwable)e);
            String string = input;
            return string;
        }
        finally {
            if (xmlOutput != null) {
                IOUtil.closeResource((Closeable)xmlOutput.getWriter());
            }
        }
    }

    private static void logFinest(String message) {
        if (LOGGER.isFinestEnabled()) {
            LOGGER.finest(message);
        }
    }

    private static void group(ConfigXmlGenerator.XmlGenerator gen, GroupConfig group) {
        gen.open("group", new Object[0]).node("name", (Object)group.getName(), new Object[0]).node("password", (Object)group.getPassword(), new Object[0]).close();
    }

    private static void network(ConfigXmlGenerator.XmlGenerator gen, ClientNetworkConfig network) {
        gen.open("network", new Object[0]).node("smart-routing", (Object)network.isSmartRouting(), new Object[0]).node("redo-operation", (Object)network.isRedoOperation(), new Object[0]).node("connection-timeout", (Object)network.getConnectionTimeout(), new Object[0]).node("connection-attempt-period", (Object)network.getConnectionAttemptPeriod(), new Object[0]);
        if (network.getConnectionAttemptLimit() >= 0) {
            gen.node("connection-attempt-limit", (Object)network.getConnectionAttemptLimit(), new Object[0]);
        }
        ClientConfigXmlGenerator.clusterMembers(gen, network.getAddresses());
        ClientConfigXmlGenerator.socketOptions(gen, network.getSocketOptions());
        ClientConfigXmlGenerator.socketInterceptor(gen, network.getSocketInterceptorConfig());
        ClientConfigXmlGenerator.ssl(gen, network.getSSLConfig());
        ClientConfigXmlGenerator.aws(gen, network.getAwsConfig());
        ClientConfigXmlGenerator.discovery(gen, network.getDiscoveryConfig());
        ClientConfigXmlGenerator.outboundPort(gen, network.getOutboundPortDefinitions());
        ClientConfigXmlGenerator.icmp(gen, network.getClientIcmpPingConfig());
        gen.close();
    }

    private static void security(ConfigXmlGenerator.XmlGenerator gen, ClientSecurityConfig security) {
        String credentialsClassname = security.getCredentialsClassname();
        Credentials credentials = security.getCredentials();
        if (credentialsClassname == null && credentials == null) {
            return;
        }
        gen.open("security", new Object[0]).node("credentials", (Object)ClientConfigXmlGenerator.classNameOrImplClass(credentialsClassname, credentials), new Object[0]).close();
    }

    private static void listener(ConfigXmlGenerator.XmlGenerator gen, List<ListenerConfig> listeners) {
        if (listeners.isEmpty()) {
            return;
        }
        gen.open("listeners", new Object[0]);
        for (ListenerConfig listener : listeners) {
            gen.node("listener", (Object)ClientConfigXmlGenerator.classNameOrImplClass(listener.getClassName(), listener.getImplementation()), new Object[0]);
        }
        gen.close();
    }

    private static void serialization(ConfigXmlGenerator.XmlGenerator gen, SerializationConfig serialization) {
        gen.open("serialization", new Object[0]).node("portable-version", (Object)serialization.getPortableVersion(), new Object[0]).node("use-native-byte-order", (Object)serialization.isUseNativeByteOrder(), new Object[0]).node("byte-order", (Object)serialization.getByteOrder(), new Object[0]).node("enable-compression", (Object)serialization.isEnableCompression(), new Object[0]).node("enable-shared-object", (Object)serialization.isEnableSharedObject(), new Object[0]).node("allow-unsafe", (Object)serialization.isAllowUnsafe(), new Object[0]).node("check-class-def-errors", (Object)serialization.isCheckClassDefErrors(), new Object[0]);
        Map dsfClasses = serialization.getDataSerializableFactoryClasses();
        Map dsfImpls = serialization.getDataSerializableFactories();
        if (!dsfClasses.isEmpty() || !dsfImpls.isEmpty()) {
            gen.open("data-serializable-factories", new Object[0]);
            for (Map.Entry entry : dsfClasses.entrySet()) {
                gen.node("data-serializable-factory", entry.getValue(), new Object[]{"factory-id", entry.getKey()});
            }
            for (Map.Entry entry : dsfImpls.entrySet()) {
                gen.node("data-serializable-factory", (Object)((DataSerializableFactory)entry.getValue()).getClass().getName(), new Object[]{"factory-id", entry.getKey()});
            }
            gen.close();
        }
        Map portableClasses = serialization.getPortableFactoryClasses();
        Map portableImpls = serialization.getPortableFactories();
        if (!portableClasses.isEmpty() || !portableImpls.isEmpty()) {
            gen.open("portable-factories", new Object[0]);
            for (Map.Entry entry : portableClasses.entrySet()) {
                gen.node("portable-factory", entry.getValue(), new Object[]{"factory-id", entry.getKey()});
            }
            for (Map.Entry entry : portableImpls.entrySet()) {
                gen.node("portable-factory", (Object)((PortableFactory)entry.getValue()).getClass().getName(), new Object[]{"factory-id", entry.getKey()});
            }
            gen.close();
        }
        ClientConfigXmlGenerator.serializers(gen, serialization);
        gen.close();
    }

    private static void serializers(ConfigXmlGenerator.XmlGenerator gen, SerializationConfig serialization) {
        GlobalSerializerConfig global = serialization.getGlobalSerializerConfig();
        Collection serializers = serialization.getSerializerConfigs();
        if (global != null || !serializers.isEmpty()) {
            gen.open("serializers", new Object[0]);
            if (global != null) {
                gen.node("global-serializer", (Object)ClientConfigXmlGenerator.classNameOrImplClass(global.getClassName(), global.getImplementation()), new Object[]{"override-java-serialization", global.isOverrideJavaSerialization()});
            }
            for (SerializerConfig serializer : serializers) {
                gen.node("serializer", null, new Object[]{"type-class", ClientConfigXmlGenerator.classNameOrImplClass(serializer.getTypeClassName(), serializer.getTypeClass()), "class-name", ClientConfigXmlGenerator.classNameOrImplClass(serializer.getClassName(), serializer.getImplementation())});
            }
            gen.close();
        }
    }

    private static void nativeMemory(ConfigXmlGenerator.XmlGenerator gen, NativeMemoryConfig nativeMemory) {
        gen.open("native-memory", new Object[]{"enabled", nativeMemory.isEnabled(), "allocator-type", nativeMemory.getAllocatorType()}).node("size", null, new Object[]{"value", nativeMemory.getSize().getValue(), "unit", nativeMemory.getSize().getUnit()}).node("min-block-size", (Object)nativeMemory.getMinBlockSize(), new Object[0]).node("page-size", (Object)nativeMemory.getPageSize(), new Object[0]).node("metadata-space-percentage", (Object)Float.valueOf(nativeMemory.getMetadataSpacePercentage()), new Object[0]).close();
    }

    private static void proxyFactory(ConfigXmlGenerator.XmlGenerator gen, List<ProxyFactoryConfig> proxyFactories) {
        if (proxyFactories.isEmpty()) {
            return;
        }
        gen.open("proxy-factories", new Object[0]);
        for (ProxyFactoryConfig proxyFactory : proxyFactories) {
            gen.node("proxy-factory", null, new Object[]{"class-name", ClientConfigXmlGenerator.classNameOrImplClass(proxyFactory.getClassName(), proxyFactory.getFactoryImpl()), "service", proxyFactory.getService()});
        }
        gen.close();
    }

    private static void loadBalancer(ConfigXmlGenerator.XmlGenerator gen, LoadBalancer loadBalancer) {
        String type;
        if (loadBalancer == null) {
            return;
        }
        if (loadBalancer instanceof RandomLB) {
            type = "random";
        } else if (loadBalancer instanceof RoundRobinLB) {
            type = "round-robin";
        } else {
            throw new IllegalArgumentException("Unknown load-balancer type: " + loadBalancer);
        }
        gen.node("load-balancer", null, new Object[]{"type", type});
    }

    private static void nearCaches(ConfigXmlGenerator.XmlGenerator gen, Map<String, NearCacheConfig> nearCacheMap) {
        if (nearCacheMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, NearCacheConfig> entry : nearCacheMap.entrySet()) {
            ClientConfigXmlGenerator.nearCache(gen, entry.getKey(), entry.getValue());
        }
    }

    private static void queryCaches(ConfigXmlGenerator.XmlGenerator gen, Map<String, Map<String, QueryCacheConfig>> queryCaches) {
        if (queryCaches.isEmpty()) {
            return;
        }
        gen.open("query-caches", new Object[0]);
        for (Map.Entry<String, Map<String, QueryCacheConfig>> entry : queryCaches.entrySet()) {
            String mapName = entry.getKey();
            Map<String, QueryCacheConfig> queryCachesPerMap = entry.getValue();
            for (QueryCacheConfig queryCache : queryCachesPerMap.values()) {
                gen.open("query-cache", new Object[]{"mapName", mapName, "name", queryCache.getName()}).node("include-value", (Object)queryCache.isIncludeValue(), new Object[0]).node("in-memory-format", (Object)queryCache.getInMemoryFormat(), new Object[0]).node("populate", (Object)queryCache.isPopulate(), new Object[0]).node("coalesce", (Object)queryCache.isCoalesce(), new Object[0]).node("delay-seconds", (Object)queryCache.getDelaySeconds(), new Object[0]).node("batch-size", (Object)queryCache.getBatchSize(), new Object[0]).node("buffer-size", (Object)queryCache.getBufferSize(), new Object[0]).node("eviction", null, new Object[]{"size", queryCache.getEvictionConfig().getSize(), "max-size-policy", queryCache.getEvictionConfig().getMaximumSizePolicy(), "eviction-policy", queryCache.getEvictionConfig().getEvictionPolicy()});
                ClientConfigXmlGenerator.queryCachePredicate(gen, queryCache.getPredicateConfig());
                ClientConfigXmlGenerator.entryListeners(gen, queryCache.getEntryListenerConfigs());
                ClientConfigXmlGenerator.indexes(gen, queryCache.getIndexConfigs());
                gen.close();
            }
        }
        gen.close();
    }

    private static void userCodeDeployment(ConfigXmlGenerator.XmlGenerator gen, ClientUserCodeDeploymentConfig userCodeDeployment) {
        List<String> jarPaths;
        gen.open("user-code-deployment", new Object[]{"enabled", userCodeDeployment.isEnabled()});
        List<String> classNames = userCodeDeployment.getClassNames();
        if (!classNames.isEmpty()) {
            gen.open("classNames", new Object[0]);
            for (String className : classNames) {
                gen.node("className", (Object)className, new Object[0]);
            }
            gen.close();
        }
        if (!(jarPaths = userCodeDeployment.getJarPaths()).isEmpty()) {
            gen.open("jarPaths", new Object[0]);
            for (String jarPath : jarPaths) {
                gen.node("jarPath", (Object)jarPath, new Object[0]);
            }
            gen.close();
        }
        gen.close();
    }

    private static void flakeIdGenerator(ConfigXmlGenerator.XmlGenerator gen, Map<String, ClientFlakeIdGeneratorConfig> flakeIdGenerators) {
        for (Map.Entry<String, ClientFlakeIdGeneratorConfig> entry : flakeIdGenerators.entrySet()) {
            ClientFlakeIdGeneratorConfig flakeIdGenerator = entry.getValue();
            gen.open("flake-id-generator", new Object[]{"name", entry.getKey()}).node("prefetch-count", (Object)flakeIdGenerator.getPrefetchCount(), new Object[0]).node("prefetch-validity-millis", (Object)flakeIdGenerator.getPrefetchValidityMillis(), new Object[0]).close();
        }
    }

    private static void indexes(ConfigXmlGenerator.XmlGenerator gen, List<MapIndexConfig> indexes) {
        if (indexes.isEmpty()) {
            return;
        }
        gen.open("indexes", new Object[0]);
        for (MapIndexConfig index : indexes) {
            gen.node("index", (Object)index.getAttribute(), new Object[]{"ordered", index.isOrdered()});
        }
        gen.close();
    }

    private static void entryListeners(ConfigXmlGenerator.XmlGenerator gen, List<EntryListenerConfig> entryListeners) {
        if (entryListeners.isEmpty()) {
            return;
        }
        gen.open("entry-listeners", new Object[0]);
        for (EntryListenerConfig listener : entryListeners) {
            gen.node("entry-listener", (Object)ClientConfigXmlGenerator.classNameOrImplClass(listener.getClassName(), listener.getImplementation()), new Object[]{"include-value", listener.isIncludeValue(), "local", listener.isLocal()});
        }
        gen.close();
    }

    private static void queryCachePredicate(ConfigXmlGenerator.XmlGenerator gen, PredicateConfig predicate) {
        String sql = predicate.getSql();
        String content = sql != null ? sql : ClientConfigXmlGenerator.classNameOrImplClass(predicate.getClassName(), predicate.getImplementation());
        String type = sql != null ? "sql" : "class-name";
        gen.node("predicate", (Object)content, new Object[]{"type", type});
    }

    private static void clusterMembers(ConfigXmlGenerator.XmlGenerator gen, List<String> addresses) {
        if (addresses == null || addresses.isEmpty()) {
            return;
        }
        gen.open("cluster-members", new Object[0]);
        for (String address : addresses) {
            gen.node("address", (Object)address, new Object[0]);
        }
        gen.close();
    }

    private static void socketOptions(ConfigXmlGenerator.XmlGenerator gen, SocketOptions socketOptions) {
        gen.open("socket-options", new Object[0]).node("tcp-no-delay", (Object)socketOptions.isTcpNoDelay(), new Object[0]).node("keep-alive", (Object)socketOptions.isKeepAlive(), new Object[0]).node("reuse-address", (Object)socketOptions.isReuseAddress(), new Object[0]).node("linger-seconds", (Object)socketOptions.getLingerSeconds(), new Object[0]).node("buffer-size", (Object)socketOptions.getBufferSize(), new Object[0]).close();
    }

    private static void socketInterceptor(ConfigXmlGenerator.XmlGenerator gen, SocketInterceptorConfig socketInterceptor) {
        if (socketInterceptor == null) {
            return;
        }
        gen.open("socket-interceptor", new Object[]{"enabled", socketInterceptor.isEnabled()}).node("class-name", (Object)ClientConfigXmlGenerator.classNameOrImplClass(socketInterceptor.getClassName(), socketInterceptor.getImplementation()), new Object[0]).appendProperties(socketInterceptor.getProperties()).close();
    }

    private static void ssl(ConfigXmlGenerator.XmlGenerator gen, SSLConfig ssl) {
        if (ssl == null) {
            return;
        }
        gen.open("ssl", new Object[]{"enabled", ssl.isEnabled()}).node("factory-class-name", (Object)ClientConfigXmlGenerator.classNameOrImplClass(ssl.getFactoryClassName(), ssl.getFactoryImplementation()), new Object[0]).appendProperties(ssl.getProperties()).close();
    }

    private static void aws(ConfigXmlGenerator.XmlGenerator gen, ClientAwsConfig aws) {
        if (aws == null) {
            return;
        }
        gen.open("aws", new Object[]{"enabled", aws.isEnabled(), "connection-timeout-seconds", aws.getConnectionTimeoutSeconds()}).node("inside-aws", (Object)aws.isInsideAws(), new Object[0]).node("access-key", (Object)aws.getAccessKey(), new Object[0]).node("secret-key", (Object)aws.getSecretKey(), new Object[0]).node("iam-role", (Object)aws.getIamRole(), new Object[0]).node("region", (Object)aws.getRegion(), new Object[0]).node("host-header", (Object)aws.getHostHeader(), new Object[0]).node("security-group-name", (Object)aws.getSecurityGroupName(), new Object[0]).node("tag-key", (Object)aws.getTagKey(), new Object[0]).node("tag-value", (Object)aws.getTagValue(), new Object[0]).close();
    }

    private static void discovery(ConfigXmlGenerator.XmlGenerator gen, DiscoveryConfig discovery) {
        if (discovery.getNodeFilter() == null && discovery.getNodeFilterClass() == null && discovery.getDiscoveryStrategyConfigs().isEmpty()) {
            return;
        }
        gen.open("discovery-strategies", new Object[0]).node("node-filter", null, new Object[]{"class", ClientConfigXmlGenerator.classNameOrImplClass(discovery.getNodeFilterClass(), discovery.getNodeFilter())});
        for (DiscoveryStrategyConfig strategy : discovery.getDiscoveryStrategyConfigs()) {
            gen.open("discovery-strategy", new Object[]{"class", strategy.getClassName(), "enabled", true}).appendProperties(strategy.getProperties()).close();
        }
        gen.close();
    }

    private static void outboundPort(ConfigXmlGenerator.XmlGenerator gen, Collection<String> outboundPortDefinitions) {
        if (outboundPortDefinitions != null && !outboundPortDefinitions.isEmpty()) {
            gen.open("outbound-ports", new Object[0]);
            for (String portDefinitions : outboundPortDefinitions) {
                gen.node("ports", (Object)portDefinitions, new Object[0]);
            }
            gen.close();
        }
    }

    private static void icmp(ConfigXmlGenerator.XmlGenerator gen, ClientIcmpPingConfig icmp) {
        gen.open("icmp-ping", new Object[]{"enabled", icmp.isEnabled()}).node("timeout-milliseconds", (Object)icmp.getTimeoutMilliseconds(), new Object[0]).node("interval-milliseconds", (Object)icmp.getIntervalMilliseconds(), new Object[0]).node("ttl", (Object)icmp.getTtl(), new Object[0]).node("max-attempts", (Object)icmp.getMaxAttempts(), new Object[0]).node("echo-fail-fast-on-startup", (Object)icmp.isEchoFailFastOnStartup(), new Object[0]).close();
    }

    private static void nearCache(ConfigXmlGenerator.XmlGenerator gen, String name, NearCacheConfig nearCache) {
        EvictionConfig eviction = nearCache.getEvictionConfig();
        NearCachePreloaderConfig preloader = nearCache.getPreloaderConfig();
        gen.open("near-cache", new Object[]{"name", name}).node("in-memory-format", (Object)nearCache.getInMemoryFormat(), new Object[0]).node("serialize-keys", (Object)nearCache.isSerializeKeys(), new Object[0]).node("invalidate-on-change", (Object)nearCache.isInvalidateOnChange(), new Object[0]).node("cache-local-entries", (Object)nearCache.isCacheLocalEntries(), new Object[0]).node("time-to-live-seconds", (Object)nearCache.getTimeToLiveSeconds(), new Object[0]).node("max-idle-seconds", (Object)nearCache.getMaxIdleSeconds(), new Object[0]).node("local-update-policy", (Object)nearCache.getLocalUpdatePolicy(), new Object[0]).node("eviction", null, new Object[]{"size", eviction.getSize(), "max-size-policy", eviction.getMaximumSizePolicy(), "eviction-policy", eviction.getEvictionPolicy()}).node("preloader", null, new Object[]{"enabled", preloader.isEnabled(), "directory", preloader.getDirectory(), "store-initial-delay-seconds", preloader.getStoreInitialDelaySeconds(), "store-interval-seconds", preloader.getStoreIntervalSeconds()});
        gen.close();
    }

    private static String classNameOrImplClass(String className, Object impl) {
        return !StringUtil.isNullOrEmpty((String)className) ? className : (impl != null ? impl.getClass().getName() : null);
    }
}

