/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.datetime;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.datetime.PDTConfig;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.time.zone.ZoneRules;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class XMLOffsetTime
implements Temporal,
TemporalAdjuster,
Comparable<XMLOffsetTime> {
    public static final XMLOffsetTime MIN = XMLOffsetTime.of(LocalTime.MIN, ZoneOffset.MAX);
    public static final XMLOffsetTime MAX = XMLOffsetTime.of(LocalTime.MAX, ZoneOffset.MIN);
    private final LocalTime m_aTime;
    private final ZoneOffset m_aOffset;

    @Nonnull
    public static XMLOffsetTime now() {
        return XMLOffsetTime.now(Clock.systemDefaultZone());
    }

    @Nonnull
    public static XMLOffsetTime now(ZoneId zoneId) {
        return XMLOffsetTime.now(Clock.system(zoneId));
    }

    @Nonnull
    public static XMLOffsetTime now(@Nonnull Clock clock) {
        Objects.requireNonNull(clock, "clock");
        Instant instant = clock.instant();
        return XMLOffsetTime.ofInstant(instant, clock.getZone().getRules().getOffset(instant));
    }

    @Nonnull
    public static XMLOffsetTime of(@Nonnull LocalTime localTime, @Nullable ZoneOffset zoneOffset) {
        return new XMLOffsetTime(localTime, zoneOffset);
    }

    @Nonnull
    public static XMLOffsetTime of(@Nonnull OffsetTime offsetTime) {
        return new XMLOffsetTime(offsetTime.toLocalTime(), offsetTime.getOffset());
    }

    @Nonnull
    public static XMLOffsetTime of(int n, int n2, int n3, int n4, @Nullable ZoneOffset zoneOffset) {
        return new XMLOffsetTime(LocalTime.of(n, n2, n3, n4), zoneOffset);
    }

    @Nonnull
    public static XMLOffsetTime ofInstant(@Nonnull Instant instant, @Nonnull ZoneId zoneId) {
        Objects.requireNonNull(instant, "instant");
        Objects.requireNonNull(zoneId, "zone");
        ZoneRules zoneRules = zoneId.getRules();
        ZoneOffset zoneOffset = zoneRules.getOffset(instant);
        long l = instant.getEpochSecond() + (long)zoneOffset.getTotalSeconds();
        int n = (int)Math.floorMod(l, 86400L);
        LocalTime localTime = LocalTime.ofNanoOfDay((long)n * 1000000000L + (long)instant.getNano());
        return new XMLOffsetTime(localTime, zoneOffset);
    }

    @Nonnull
    public static XMLOffsetTime from(@Nonnull TemporalAccessor temporalAccessor) {
        if (temporalAccessor instanceof XMLOffsetTime) {
            return (XMLOffsetTime)temporalAccessor;
        }
        try {
            LocalTime localTime = LocalTime.from(temporalAccessor);
            ZoneOffset zoneOffset = ZoneOffset.from(temporalAccessor);
            return new XMLOffsetTime(localTime, zoneOffset);
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain XMLOffsetTime from TemporalAccessor: " + temporalAccessor + " of type " + temporalAccessor.getClass().getName(), dateTimeException);
        }
    }

    @Nonnull
    public static XMLOffsetTime parse(@Nonnull CharSequence charSequence) {
        return XMLOffsetTime.parse(charSequence, DateTimeFormatter.ISO_TIME);
    }

    @Nonnull
    public static XMLOffsetTime parse(@Nonnull CharSequence charSequence, @Nonnull DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.parse(charSequence, XMLOffsetTime::from);
    }

    protected XMLOffsetTime(@Nonnull LocalTime localTime, @Nullable ZoneOffset zoneOffset) {
        this.m_aTime = Objects.requireNonNull(localTime, "time");
        this.m_aOffset = zoneOffset;
    }

    @Nonnull
    protected XMLOffsetTime with(@Nonnull LocalTime localTime, @Nullable ZoneOffset zoneOffset) {
        if (this.m_aTime == localTime && EqualsHelper.equals(this.m_aOffset, zoneOffset)) {
            return this;
        }
        return new XMLOffsetTime(localTime, zoneOffset);
    }

    @Override
    public boolean isSupported(@Nullable TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            return temporalField.isTimeBased() || temporalField == ChronoField.OFFSET_SECONDS;
        }
        return temporalField != null && temporalField.isSupportedBy(this);
    }

    @Override
    public boolean isSupported(@Nullable TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return temporalUnit.isTimeBased();
        }
        return temporalUnit != null && temporalUnit.isSupportedBy(this);
    }

    @Override
    @Nonnull
    public ValueRange range(@Nonnull TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                return temporalField.range();
            }
            return this.m_aTime.range(temporalField);
        }
        return temporalField.rangeRefinedBy(this);
    }

    @Override
    public int get(@Nonnull TemporalField temporalField) {
        return Temporal.super.get(temporalField);
    }

    @Override
    public long getLong(@Nonnull TemporalField temporalField) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                return this.m_aOffset != null ? (long)this.m_aOffset.getTotalSeconds() : 0L;
            }
            return this.m_aTime.getLong(temporalField);
        }
        return temporalField.getFrom(this);
    }

    @Nullable
    public ZoneOffset getOffset() {
        return this.m_aOffset;
    }

    public boolean hasOffset() {
        return this.m_aOffset != null;
    }

    @Nonnull
    public XMLOffsetTime withOffsetSameLocal(@Nullable ZoneOffset zoneOffset) {
        return EqualsHelper.equals(zoneOffset, this.m_aOffset) ? this : new XMLOffsetTime(this.m_aTime, zoneOffset);
    }

    @Nonnull
    public XMLOffsetTime withOffsetSameInstant(@Nullable ZoneOffset zoneOffset) {
        if (EqualsHelper.equals(zoneOffset, this.m_aOffset)) {
            return this;
        }
        int n = (zoneOffset != null ? zoneOffset.getTotalSeconds() : 0) - (this.m_aOffset != null ? this.m_aOffset.getTotalSeconds() : 0);
        LocalTime localTime = this.m_aTime.plusSeconds(n);
        return new XMLOffsetTime(localTime, zoneOffset);
    }

    @Nonnull
    public LocalTime toLocalTime() {
        return this.m_aTime;
    }

    public int getHour() {
        return this.m_aTime.getHour();
    }

    public int getMinute() {
        return this.m_aTime.getMinute();
    }

    public int getSecond() {
        return this.m_aTime.getSecond();
    }

    public int getNano() {
        return this.m_aTime.getNano();
    }

    @Override
    @Nonnull
    public XMLOffsetTime with(@Nonnull TemporalAdjuster temporalAdjuster) {
        if (temporalAdjuster instanceof LocalTime) {
            return this.with((LocalTime)temporalAdjuster, this.m_aOffset);
        }
        if (temporalAdjuster instanceof ZoneOffset) {
            return this.with(this.m_aTime, (ZoneOffset)temporalAdjuster);
        }
        if (temporalAdjuster instanceof XMLOffsetTime) {
            return (XMLOffsetTime)temporalAdjuster;
        }
        return (XMLOffsetTime)temporalAdjuster.adjustInto(this);
    }

    @Override
    @Nonnull
    public XMLOffsetTime with(@Nonnull TemporalField temporalField, long l) {
        if (temporalField instanceof ChronoField) {
            if (temporalField == ChronoField.OFFSET_SECONDS) {
                ChronoField chronoField = (ChronoField)temporalField;
                return this.with(this.m_aTime, ZoneOffset.ofTotalSeconds(chronoField.checkValidIntValue(l)));
            }
            return this.with(this.m_aTime.with(temporalField, l), this.m_aOffset);
        }
        return temporalField.adjustInto(this, l);
    }

    @Nonnull
    public XMLOffsetTime withHour(int n) {
        return this.with(this.m_aTime.withHour(n), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetTime withMinute(int n) {
        return this.with(this.m_aTime.withMinute(n), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetTime withSecond(int n) {
        return this.with(this.m_aTime.withSecond(n), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetTime withNano(int n) {
        return this.with(this.m_aTime.withNano(n), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetTime truncatedTo(@Nonnull TemporalUnit temporalUnit) {
        return this.with(this.m_aTime.truncatedTo(temporalUnit), this.m_aOffset);
    }

    @Override
    @Nonnull
    public XMLOffsetTime plus(@Nonnull TemporalAmount temporalAmount) {
        return (XMLOffsetTime)temporalAmount.addTo(this);
    }

    @Override
    @Nonnull
    public XMLOffsetTime plus(long l, @Nonnull TemporalUnit temporalUnit) {
        if (temporalUnit instanceof ChronoUnit) {
            return this.with(this.m_aTime.plus(l, temporalUnit), this.m_aOffset);
        }
        return temporalUnit.addTo(this, l);
    }

    @Nonnull
    public XMLOffsetTime plusHours(long l) {
        return this.with(this.m_aTime.plusHours(l), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetTime plusMinutes(long l) {
        return this.with(this.m_aTime.plusMinutes(l), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetTime plusSeconds(long l) {
        return this.with(this.m_aTime.plusSeconds(l), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetTime plusNanos(long l) {
        return this.with(this.m_aTime.plusNanos(l), this.m_aOffset);
    }

    @Override
    @Nonnull
    public XMLOffsetTime minus(@Nonnull TemporalAmount temporalAmount) {
        return (XMLOffsetTime)temporalAmount.subtractFrom(this);
    }

    @Override
    @Nonnull
    public XMLOffsetTime minus(long l, @Nonnull TemporalUnit temporalUnit) {
        return l == Long.MIN_VALUE ? this.plus(Long.MAX_VALUE, temporalUnit).plus(1L, temporalUnit) : this.plus(-l, temporalUnit);
    }

    @Nonnull
    public XMLOffsetTime minusHours(long l) {
        return this.with(this.m_aTime.minusHours(l), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetTime minusMinutes(long l) {
        return this.with(this.m_aTime.minusMinutes(l), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetTime minusSeconds(long l) {
        return this.with(this.m_aTime.minusSeconds(l), this.m_aOffset);
    }

    @Nonnull
    public XMLOffsetTime minusNanos(long l) {
        return this.with(this.m_aTime.minusNanos(l), this.m_aOffset);
    }

    @Nonnull
    protected ZoneOffset getOffsetOrDefault() {
        ZoneOffset zoneOffset = this.m_aOffset;
        if (zoneOffset == null) {
            zoneOffset = ZoneOffset.UTC;
        }
        return zoneOffset;
    }

    @Nonnull
    protected ZoneOffset getOffsetOrDefault(@Nonnull LocalDateTime localDateTime) {
        ZoneOffset zoneOffset = this.m_aOffset;
        if (zoneOffset == null) {
            zoneOffset = PDTConfig.getDefaultZoneId().getRules().getOffset(localDateTime);
        }
        return zoneOffset;
    }

    @Override
    @Nonnull
    public <R> R query(@Nonnull TemporalQuery<R> temporalQuery) {
        if (temporalQuery == TemporalQueries.offset() || temporalQuery == TemporalQueries.zone()) {
            return (R)this.getOffsetOrDefault();
        }
        if (temporalQuery == TemporalQueries.zoneId() | temporalQuery == TemporalQueries.chronology() || temporalQuery == TemporalQueries.localDate()) {
            return null;
        }
        if (temporalQuery == TemporalQueries.localTime()) {
            return (R)this.m_aTime;
        }
        if (temporalQuery == TemporalQueries.precision()) {
            return (R)ChronoUnit.NANOS;
        }
        return temporalQuery.queryFrom(this);
    }

    @Override
    @Nonnull
    public Temporal adjustInto(@Nonnull Temporal temporal) {
        return temporal.with(ChronoField.NANO_OF_DAY, this.m_aTime.toNanoOfDay()).with(ChronoField.OFFSET_SECONDS, this.m_aOffset != null ? (long)this.m_aOffset.getTotalSeconds() : 0L);
    }

    @Override
    public long until(@Nonnull Temporal temporal, @Nonnull TemporalUnit temporalUnit) {
        XMLOffsetTime xMLOffsetTime = XMLOffsetTime.from(temporal);
        if (temporalUnit instanceof ChronoUnit) {
            long l = xMLOffsetTime.toEpochNano() - this.toEpochNano();
            switch ((ChronoUnit)temporalUnit) {
                case NANOS: {
                    return l;
                }
                case MICROS: {
                    return l / 1000L;
                }
                case MILLIS: {
                    return l / 1000000L;
                }
                case SECONDS: {
                    return l / 1000000000L;
                }
                case MINUTES: {
                    return l / 60000000000L;
                }
                case HOURS: {
                    return l / 3600000000000L;
                }
                case HALF_DAYS: {
                    return l / 43200000000000L;
                }
            }
            throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
        }
        return temporalUnit.between(this, xMLOffsetTime);
    }

    @Nonnull
    public String format(@Nonnull DateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        return dateTimeFormatter.format(this);
    }

    @Nonnull
    public OffsetDateTime atDate(@Nonnull LocalDate localDate) {
        LocalDateTime localDateTime = localDate.atTime(this.m_aTime);
        return OffsetDateTime.of(localDateTime, this.getOffsetOrDefault(localDateTime));
    }

    @Nonnull
    public XMLOffsetDateTime atXMLDate(@Nonnull LocalDate localDate) {
        return XMLOffsetDateTime.of(localDate, this.m_aTime, this.m_aOffset);
    }

    protected long toEpochNano() {
        long l = this.m_aTime.toNanoOfDay();
        long l2 = this.m_aOffset != null ? (long)this.m_aOffset.getTotalSeconds() * 1000000000L : 0L;
        return l - l2;
    }

    @Override
    public int compareTo(@Nonnull XMLOffsetTime xMLOffsetTime) {
        if (EqualsHelper.equals(this.m_aOffset, xMLOffsetTime.m_aOffset)) {
            return this.m_aTime.compareTo(xMLOffsetTime.m_aTime);
        }
        int n = Long.compare(this.toEpochNano(), xMLOffsetTime.toEpochNano());
        if (n == 0) {
            n = this.m_aTime.compareTo(xMLOffsetTime.m_aTime);
        }
        return n;
    }

    public boolean isAfter(@Nonnull XMLOffsetTime xMLOffsetTime) {
        return this.toEpochNano() > xMLOffsetTime.toEpochNano();
    }

    public boolean isBefore(@Nonnull XMLOffsetTime xMLOffsetTime) {
        return this.toEpochNano() < xMLOffsetTime.toEpochNano();
    }

    public boolean isEqual(@Nonnull XMLOffsetTime xMLOffsetTime) {
        return this.toEpochNano() == xMLOffsetTime.toEpochNano();
    }

    @Nullable
    public OffsetTime toOffsetTime() {
        return OffsetTime.of(this.m_aTime, this.getOffsetOrDefault());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        XMLOffsetTime xMLOffsetTime = (XMLOffsetTime)object;
        return this.m_aTime.equals(xMLOffsetTime.m_aTime) && EqualsHelper.equals(this.m_aOffset, xMLOffsetTime.m_aOffset);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aTime).append(this.m_aOffset).getHashCode();
    }

    @Nonnull
    @Nonempty
    public String getAsString() {
        return this.m_aTime.toString() + (this.m_aOffset != null ? this.m_aOffset.toString() : "");
    }

    @Deprecated
    public String toString() {
        return new ToStringGenerator(this).append("Time", this.m_aTime).append("Offset", this.m_aOffset).getToString();
    }
}

