/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.debug;

import com.helger.commons.system.SystemProperties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class GlobalDebug {
    public static final boolean DEFAULT_DEBUG_MODE = true;
    public static final boolean DEFAULT_PRODUCTION_MODE = false;
    public static final boolean DEFAULT_SILENT_MODE = true;
    public static final String SYSTEM_PROPERTY_MAIL_DEBUG = "mail.debug";
    public static final String SYSTEM_PROPERTY_JAVA_SECURITY_DEBUG = "java.security.debug";
    public static final String SYSTEM_PROPERTY_JAVAX_ACTIVATION_DEBUG = "javax.activation.debug";
    public static final String SYSTEM_PROPERTY_JAVAX_NET_DEBUG = "javax.net.debug";
    public static final String SYSTEM_PROPERTY_JAXP_DEBUG = "jaxp.debug";
    public static final String SYSTEM_PROPERTY_SERIALIZATION_DEBUG = "sun.io.serialization.extendedDebugInfo";
    private static final AtomicBoolean DEBUG_MODE = new AtomicBoolean(true);
    private static final AtomicBoolean PRODUCTION_MODE = new AtomicBoolean(false);

    public void setDebugMode(boolean bl) {
        GlobalDebug.setDebugModeDirect(bl);
    }

    public void setProductionMode(boolean bl) {
        GlobalDebug.setProductionModeDirect(bl);
    }

    public static void setJavaCommonComponentsDebugMode(boolean bl) {
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_JAXP_DEBUG, bl);
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_JAVAX_ACTIVATION_DEBUG, bl);
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_MAIL_DEBUG, bl);
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_SERIALIZATION_DEBUG, bl);
    }

    public static void setJavaNetDebugMode(@Nullable String string) {
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_JAVAX_NET_DEBUG, string);
    }

    public static void setJavaSecurityDebugMode(@Nullable String string) {
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_JAVA_SECURITY_DEBUG, string);
    }

    public static void setDebugModeDirect(boolean bl) {
        DEBUG_MODE.set(bl);
        GlobalDebug.setJavaCommonComponentsDebugMode(bl);
    }

    public static void setProductionModeDirect(boolean bl) {
        PRODUCTION_MODE.set(bl);
        if (bl) {
            GlobalDebug.setDebugModeDirect(false);
        }
    }

    public static boolean isDebugMode() {
        return DEBUG_MODE.get();
    }

    public static boolean isProductionMode() {
        return PRODUCTION_MODE.get();
    }
}

