/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.string;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.builder.IBuilder;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.CommonsTreeSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.functional.ICharConsumer;
import com.helger.commons.functional.ICharPredicate;
import com.helger.commons.functional.Predicates;
import com.helger.commons.math.MathHelper;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import javax.annotation.CheckForSigned;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StringHelper {
    public static final int STRING_NOT_FOUND = -1;
    private static final int[] SIZE_TABLE_INT = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final long[] SIZE_TABLE_LONG = new long[]{9L, 99L, 999L, 9999L, 99999L, 999999L, 9999999L, 99999999L, 999999999L, 9999999999L, 99999999999L, 999999999999L, 9999999999999L, 99999999999999L, 999999999999999L, 9999999999999999L, 99999999999999999L, 999999999999999999L, Long.MAX_VALUE};
    private static final StringHelper INSTANCE = new StringHelper();

    private StringHelper() {
    }

    public static boolean hasNoText(@Nullable CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static boolean hasNoText(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static boolean hasNoTextAfterTrim(@Nullable String string) {
        return string == null || string.trim().isEmpty();
    }

    public static boolean hasText(@Nullable CharSequence charSequence) {
        return charSequence != null && charSequence.length() > 0;
    }

    public static boolean hasText(@Nullable String string) {
        return string != null && !string.isEmpty();
    }

    public static boolean hasTextAfterTrim(@Nullable String string) {
        return string != null && !string.trim().isEmpty();
    }

    public static boolean containsAny(@Nullable CharSequence charSequence, @Nullable ICharPredicate iCharPredicate) {
        int n = StringHelper.getLength(charSequence);
        if (iCharPredicate == null) {
            return n > 0;
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (!iCharPredicate.test(charSequence.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(@Nullable String string, @Nullable ICharPredicate iCharPredicate) {
        int n = StringHelper.getLength(string);
        if (iCharPredicate == null) {
            return n > 0;
        }
        if (n > 0) {
            for (char c : string.toCharArray()) {
                if (!iCharPredicate.test(c)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsNone(@Nullable CharSequence charSequence, @Nullable ICharPredicate iCharPredicate) {
        int n = StringHelper.getLength(charSequence);
        if (iCharPredicate == null) {
            return n == 0;
        }
        for (int i = 0; i < n; ++i) {
            if (!iCharPredicate.test(charSequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsNone(@Nullable String string, @Nullable ICharPredicate iCharPredicate) {
        int n = StringHelper.getLength(string);
        if (iCharPredicate == null) {
            return n == 0;
        }
        if (n > 0) {
            for (char c : string.toCharArray()) {
                if (!iCharPredicate.test(c)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containsOnly(@Nullable CharSequence charSequence, @Nullable ICharPredicate iCharPredicate) {
        int n = StringHelper.getLength(charSequence);
        if (n == 0) {
            return false;
        }
        if (iCharPredicate == null) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (iCharPredicate.test(charSequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsOnly(@Nullable String string, @Nullable ICharPredicate iCharPredicate) {
        int n = StringHelper.getLength(string);
        if (n == 0) {
            return false;
        }
        if (iCharPredicate == null) {
            return true;
        }
        for (char c : string.toCharArray()) {
            if (iCharPredicate.test(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllWhitespace(@Nullable CharSequence charSequence) {
        return StringHelper.containsOnly(charSequence, Character::isWhitespace);
    }

    @Nullable
    public static String getLeadingZero(@Nullable Byte by, int n) {
        return by == null ? null : StringHelper.getLeadingZero((int)by.byteValue(), n);
    }

    @Nullable
    public static String getLeadingZero(@Nullable Integer n, int n2) {
        return n == null ? null : StringHelper.getLeadingZero(n.longValue(), n2);
    }

    @Nullable
    public static String getLeadingZero(@Nullable Long l, int n) {
        return l == null ? null : StringHelper.getLeadingZero((long)l, n);
    }

    @Nullable
    public static String getLeadingZero(@Nullable Short s, int n) {
        return s == null ? null : StringHelper.getLeadingZero((int)s.shortValue(), n);
    }

    @Nonnull
    public static String getLeadingZero(int n, int n2) {
        boolean bl = n < 0;
        String string = Integer.toString(MathHelper.abs(n));
        if (string.length() >= n2) {
            return bl ? '-' + string : string;
        }
        StringBuilder stringBuilder = new StringBuilder((bl ? 1 : 0) + n2);
        if (bl) {
            stringBuilder.append('-');
        }
        for (int i = 0; i < n2 - string.length(); ++i) {
            stringBuilder.append('0');
        }
        return stringBuilder.append(string).toString();
    }

    @Nonnull
    public static String getLeadingZero(long l, int n) {
        boolean bl = l < 0L;
        String string = Long.toString(MathHelper.abs(l));
        if (string.length() >= n) {
            return bl ? '-' + string : string;
        }
        StringBuilder stringBuilder = new StringBuilder((bl ? 1 : 0) + n);
        if (bl) {
            stringBuilder.append('-');
        }
        for (int i = 0; i < n - string.length(); ++i) {
            stringBuilder.append('0');
        }
        return stringBuilder.append(string).toString();
    }

    @Nonnull
    public static String getLeadingZero(@Nonnull String string, int n) {
        return StringHelper.getWithLeading(string, n, '0');
    }

    @Nonnull
    private static String _getWithLeadingOrTrailing(@Nullable String string, @Nonnegative int n, char c, boolean bl) {
        if (n <= 0) {
            return StringHelper.getNotNull(string, "");
        }
        int n2 = StringHelper.getLength(string);
        if (n2 == 0) {
            return StringHelper.getRepeated(c, n);
        }
        int n3 = n - n2;
        if (n3 <= 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        if (!bl) {
            stringBuilder.append(string);
        }
        for (int i = 0; i < n3; ++i) {
            stringBuilder.append(c);
        }
        if (bl) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getWithLeading(@Nullable String string, @Nonnegative int n, char c) {
        return StringHelper._getWithLeadingOrTrailing(string, n, c, true);
    }

    @Nonnull
    public static String getWithLeading(int n, @Nonnegative int n2, char c) {
        return StringHelper._getWithLeadingOrTrailing(Integer.toString(n), n2, c, true);
    }

    @Nonnull
    public static String getWithLeading(long l, @Nonnegative int n, char c) {
        return StringHelper._getWithLeadingOrTrailing(Long.toString(l), n, c, true);
    }

    @Nonnull
    public static String getWithTrailing(@Nullable String string, @Nonnegative int n, char c) {
        return StringHelper._getWithLeadingOrTrailing(string, n, c, false);
    }

    public static char getHexChar(int n) {
        return Character.forDigit(n, 16);
    }

    public static char getHexCharUpperCase(int n) {
        return Character.toUpperCase(StringHelper.getHexChar(n));
    }

    @Nonnull
    public static String getHexEncoded(@Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull(string, "Input");
        ValueEnforcer.notNull(charset, "Charset");
        return StringHelper.getHexEncoded(string.getBytes(charset));
    }

    @Nonnull
    public static String getHexEncoded(@Nonnull byte[] byArray) {
        ValueEnforcer.notNull(byArray, "Input");
        return StringHelper.getHexEncoded(byArray, 0, byArray.length);
    }

    @Nonnull
    public static String getHexEncoded(@Nonnull byte[] byArray, int n, int n2) {
        ValueEnforcer.isArrayOfsLen(byArray, n, n2);
        StringBuilder stringBuilder = new StringBuilder(n2 * 2);
        for (int i = n; i < n + n2; ++i) {
            byte by = byArray[i];
            char c = StringHelper.getHexChar((by & 0xF0) >> 4);
            char c2 = StringHelper.getHexChar(by & 0xF);
            stringBuilder.append(c).append(c2);
        }
        return stringBuilder.toString();
    }

    @CheckForSigned
    public static int getHexValue(@Nonnegative char c) {
        return Character.digit(c, 16);
    }

    public static int getHexByte(@Nonnegative char c, @Nonnegative char c2) {
        int n = StringHelper.getHexValue(c);
        int n2 = StringHelper.getHexValue(c2);
        return n < 0 || n2 < 0 ? -1 : n << 4 | n2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getHexDecoded(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Input");
        return StringHelper.getHexDecoded(string.toCharArray(), 0, string.length());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getHexDecoded(@Nonnull char[] cArray) {
        ValueEnforcer.notNull(cArray, "Input");
        return StringHelper.getHexDecoded(cArray, 0, cArray.length);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] getHexDecoded(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isArrayOfsLen(cArray, n, n2);
        ValueEnforcer.isTrue(n2 % 2 == 0, () -> "Passed chars have no even length: " + n2);
        byte[] byArray = new byte[n2 / 2];
        int n3 = 0;
        for (int i = 0; i < n2; i += 2) {
            char c = cArray[n + i];
            char c2 = cArray[n + i + 1];
            int n4 = StringHelper.getHexByte(c, c2);
            if (n4 == -1) {
                throw new IllegalArgumentException("Failed to convert '" + c + "' and '" + c2 + "' to a hex value!");
            }
            byArray[n3++] = (byte)n4;
        }
        return byArray;
    }

    @Nonnull
    public static String getHexString(byte by) {
        return Integer.toString(by & 0xFF, 16);
    }

    @Nonnull
    public static String getHexStringLeadingZero(byte by, int n) {
        return StringHelper.getLeadingZero(StringHelper.getHexString(by), n);
    }

    @Nonnull
    public static String getHexStringLeadingZero2(byte by) {
        String string = StringHelper.getHexString(by);
        return string.length() >= 2 ? string : '0' + string;
    }

    @Nonnull
    public static String getHexString(int n) {
        return Integer.toString(n, 16);
    }

    @Nonnull
    public static String getHexStringLeadingZero(int n, int n2) {
        if (n < 0) {
            return "-" + StringHelper.getLeadingZero(StringHelper.getHexString(-n), n2 - 1);
        }
        return StringHelper.getLeadingZero(StringHelper.getHexString(n), n2);
    }

    @Nonnull
    public static String getHexString(long l) {
        return Long.toString(l, 16);
    }

    @Nonnull
    public static String getHexStringLeadingZero(long l, int n) {
        if (l < 0L) {
            return "-" + StringHelper.getLeadingZero(StringHelper.getHexString(-l), n - 1);
        }
        return StringHelper.getLeadingZero(StringHelper.getHexString(l), n);
    }

    @Nonnull
    public static String getHexString(short s) {
        return Integer.toString(s & 0xFFFF, 16);
    }

    @Nonnull
    public static String getHexStringLeadingZero(short s, int n) {
        return StringHelper.getLeadingZero(StringHelper.getHexString(s), n);
    }

    @Nonnegative
    public static int getLeadingWhitespaceCount(@Nullable String string) {
        int n;
        if (string != null) {
            int n2 = string.length();
            for (n = 0; n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
            }
        }
        return n;
    }

    @Nonnegative
    public static int getTrailingWhitespaceCount(@Nullable String string) {
        int n = 0;
        if (string != null) {
            for (int i = string.length() - 1; i >= 0 && Character.isWhitespace(string.charAt(i)); --i) {
                ++n;
            }
        }
        return n;
    }

    @Nonnegative
    public static int getLeadingCharCount(@Nullable String string, char c) {
        int n;
        if (string != null) {
            int n2 = string.length();
            for (n = 0; n < n2 && string.charAt(n) == c; ++n) {
            }
        }
        return n;
    }

    @Nonnegative
    public static int getTrailingCharCount(@Nullable String string, char c) {
        int n = 0;
        if (string != null) {
            for (int i = string.length() - 1; i >= 0 && string.charAt(i) == c; --i) {
                ++n;
            }
        }
        return n;
    }

    @Nonnull
    public static ImploderBuilder imploder() {
        return new ImploderBuilder();
    }

    @Nonnull
    public static String getImploded(@Nullable Iterable<?> iterable) {
        return StringHelper.imploder().source(iterable).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMapped(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringHelper.imploder().source(iterable, function).build();
    }

    @Nonnull
    public static String getImploded(@Nonnull String string, @Nullable Iterable<?> iterable) {
        return StringHelper.imploder().source(iterable).separator(string).build();
    }

    @Nonnull
    public static String getImploded(char c, @Nullable Iterable<?> iterable) {
        return StringHelper.imploder().source(iterable).separator(c).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMapped(@Nonnull String string, @Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringHelper.imploder().source(iterable, function).separator(string).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMapped(char c, @Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringHelper.imploder().source(iterable, function).separator(c).build();
    }

    @Nonnull
    @SafeVarargs
    public static <ELEMENTTYPE> String getImploded(ELEMENTTYPE ... ELEMENTTYPEArray) {
        return StringHelper.imploder().source(ELEMENTTYPEArray).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImploded(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2) {
        return StringHelper.imploder().source(ELEMENTTYPEArray).offset(n).length(n2).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMapped(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringHelper.imploder().source(ELEMENTTYPEArray, function).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMapped(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringHelper.imploder().source(ELEMENTTYPEArray, function).offset(n).length(n2).build();
    }

    @Nonnull
    @SafeVarargs
    public static <ELEMENTTYPE> String getImploded(@Nonnull String string, ELEMENTTYPE ... ELEMENTTYPEArray) {
        return StringHelper.imploder().source(ELEMENTTYPEArray).separator(string).build();
    }

    @Nonnull
    @SafeVarargs
    public static <ELEMENTTYPE> String getImploded(char c, ELEMENTTYPE ... ELEMENTTYPEArray) {
        return StringHelper.imploder().source(ELEMENTTYPEArray).separator(c).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImploded(@Nonnull String string, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2) {
        return StringHelper.imploder().source(ELEMENTTYPEArray).offset(n).length(n2).separator(string).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMapped(@Nonnull String string, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringHelper.imploder().source(ELEMENTTYPEArray, function).separator(string).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMapped(char c, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringHelper.imploder().source(ELEMENTTYPEArray, function).separator(c).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMapped(char c, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringHelper.imploder().source(ELEMENTTYPEArray, function).offset(n).length(n2).separator(c).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMapped(@Nonnull String string, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringHelper.imploder().source(ELEMENTTYPEArray, function).offset(n).length(n2).separator(string).build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImploded(char c, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2) {
        return StringHelper.imploder().source(ELEMENTTYPEArray).offset(n).length(n2).separator(c).build();
    }

    @Nonnull
    public static String getImplodedNonEmpty(@Nullable Iterable<String> iterable) {
        return StringHelper.imploder().source(iterable).filterNonEmpty().build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMappedNonEmpty(@Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringHelper.imploder().source(iterable, function).filterNonEmpty().build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMappedNonEmpty(@Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringHelper.imploder().source(ELEMENTTYPEArray, function).filterNonEmpty().build();
    }

    @Nonnull
    public static String getImplodedNonEmpty(@Nonnull String string, @Nullable Iterable<String> iterable) {
        return StringHelper.imploder().source(iterable).separator(string).filterNonEmpty().build();
    }

    @Nonnull
    public static String getImplodedNonEmpty(char c, @Nullable Iterable<String> iterable) {
        return StringHelper.imploder().source(iterable).separator(c).filterNonEmpty().build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMappedNonEmpty(@Nonnull String string, @Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringHelper.imploder().source(iterable, function).separator(string).filterNonEmpty().build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMappedNonEmpty(char c, @Nullable Iterable<? extends ELEMENTTYPE> iterable, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringHelper.imploder().source(iterable, function).separator(c).filterNonEmpty().build();
    }

    @Nonnull
    public static String getImplodedNonEmpty(@Nonnull String string, String ... stringArray) {
        return StringHelper.imploder().source(stringArray).separator(string).filterNonEmpty().build();
    }

    @Nonnull
    public static String getImplodedNonEmpty(char c, String ... stringArray) {
        return StringHelper.imploder().source(stringArray).separator(c).filterNonEmpty().build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMappedNonEmpty(@Nonnull String string, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringHelper.imploder().source(ELEMENTTYPEArray, function).separator(string).filterNonEmpty().build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMappedNonEmpty(char c, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringHelper.imploder().source(ELEMENTTYPEArray, function).separator(c).filterNonEmpty().build();
    }

    @Nonnull
    public static String getImplodedNonEmpty(@Nonnull String string, @Nullable String[] stringArray, @Nonnegative int n, @Nonnegative int n2) {
        return StringHelper.imploder().source(stringArray).separator(string).offset(n).length(n2).filterNonEmpty().build();
    }

    @Nonnull
    public static String getImplodedNonEmpty(char c, @Nullable String[] stringArray, @Nonnegative int n, @Nonnegative int n2) {
        return StringHelper.imploder().source(stringArray).separator(c).offset(n).length(n2).filterNonEmpty().build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMappedNonEmpty(@Nonnull String string, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringHelper.imploder().source(ELEMENTTYPEArray, function).separator(string).offset(n).length(n2).filterNonEmpty().build();
    }

    @Nonnull
    public static <ELEMENTTYPE> String getImplodedMappedNonEmpty(char c, @Nullable ELEMENTTYPE[] ELEMENTTYPEArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Function<? super ELEMENTTYPE, String> function) {
        return StringHelper.imploder().source(ELEMENTTYPEArray, function).separator(c).offset(n).length(n2).filterNonEmpty().build();
    }

    @Nonnull
    public static ImploderBuilderMap imploderMap() {
        return new ImploderBuilderMap();
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> String getImploded(@Nonnull String string, @Nonnull String string2, @Nullable Map<KEYTYPE, VALUETYPE> map) {
        return StringHelper.imploderMap().source(map).separatorOuter(string).separatorInner(string2).build();
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> String getImploded(char c, char c2, @Nullable Map<KEYTYPE, VALUETYPE> map) {
        return StringHelper.imploderMap().source(map).separatorOuter(c).separatorInner(c2).build();
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> String getImplodedMapped(@Nonnull String string, @Nonnull String string2, @Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map, @Nonnull Function<? super KEYTYPE, String> function, @Nonnull Function<? super VALUETYPE, String> function2) {
        return StringHelper.imploderMap().source(map, function, function2).separatorOuter(string).separatorInner(string2).build();
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> String getImplodedMapped(char c, char c2, @Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map, @Nonnull Function<? super KEYTYPE, String> function, @Nonnull Function<? super VALUETYPE, String> function2) {
        return StringHelper.imploderMap().source(map, function, function2).separatorOuter(c).separatorInner(c2).build();
    }

    @Nonnull
    public static String[] getExplodedArray(char c, @Nullable String string, @CheckForSigned int n) {
        int n2;
        if (n == 1) {
            return new String[]{string};
        }
        if (StringHelper.hasNoText(string)) {
            return ArrayHelper.EMPTY_STRING_ARRAY;
        }
        int n3 = 1 + StringHelper.getCharCount(string, c);
        if (n3 == 1) {
            return new String[]{string};
        }
        String[] stringArray = new String[n < 1 ? n3 : Math.min(n3, n)];
        int n4 = 0;
        int n5 = 0;
        while ((n2 = string.indexOf(c, n4)) >= 0) {
            stringArray[n5++] = string.substring(n4, n2);
            n4 = n2 + 1;
            if (n <= 0 || n5 != n - 1) continue;
            break;
        }
        stringArray[n5++] = string.substring(n4);
        if (n5 != stringArray.length) {
            throw new IllegalStateException("Added " + n5 + " but expected " + stringArray.length);
        }
        return stringArray;
    }

    @Nonnull
    public static String[] getExplodedArray(char c, @Nullable String string) {
        return StringHelper.getExplodedArray(c, string, -1);
    }

    @Nonnull
    @ReturnsMutableObject(value="The passed parameter")
    @CodingStyleguideUnaware
    public static <COLLTYPE extends Collection<String>> COLLTYPE getExploded(char c, @Nullable String string, int n, @Nonnull COLLTYPE COLLTYPE) {
        StringHelper.explode(c, string, n, COLLTYPE::add);
        return COLLTYPE;
    }

    public static void explode(char c, @Nullable String string, @Nonnull Consumer<? super String> consumer) {
        StringHelper.explode(c, string, -1, consumer);
    }

    public static void explode(char c, @Nullable String string, int n, @Nonnull Consumer<? super String> consumer) {
        ValueEnforcer.notNull(consumer, "Consumer");
        if (n == 1) {
            consumer.accept(string);
        } else if (StringHelper.hasText(string)) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            while ((n2 = string.indexOf(c, n3)) >= 0) {
                consumer.accept(string.substring(n3, n2));
                n3 = n2 + 1;
                if (n <= 0 || ++n4 != n - 1) continue;
            }
            consumer.accept(string.substring(n3));
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<String> getExploded(char c, @Nullable String string) {
        return StringHelper.getExploded(c, string, -1);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<String> getExploded(char c, @Nullable String string, int n) {
        return StringHelper.getExploded(c, string, n, n >= 1 ? new CommonsArrayList<int>(n) : new CommonsArrayList());
    }

    @Nonnull
    @CodingStyleguideUnaware
    public static <COLLTYPE extends Collection<String>> COLLTYPE getExploded(@Nonnull String string, @Nullable String string2, int n, @Nonnull COLLTYPE COLLTYPE) {
        StringHelper.explode(string, string2, n, COLLTYPE::add);
        return COLLTYPE;
    }

    public static void explode(@Nonnull String string, @Nullable String string2, @Nonnull Consumer<? super String> consumer) {
        StringHelper.explode(string, string2, -1, consumer);
    }

    public static void explode(@Nonnull String string, @Nullable String string2, int n, @Nonnull Consumer<? super String> consumer) {
        ValueEnforcer.notNull(string, "Separator");
        ValueEnforcer.notNull(consumer, "Collection");
        if (string.length() == 1) {
            StringHelper.explode(string.charAt(0), string2, n, consumer);
        } else if (n == 1) {
            consumer.accept(string2);
        } else if (StringHelper.hasText(string2)) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            while ((n2 = string2.indexOf(string, n3)) >= 0) {
                consumer.accept(string2.substring(n3, n2));
                n3 = n2 + string.length();
                if (n <= 0 || ++n4 != n - 1) continue;
                break;
            }
            consumer.accept(string2.substring(n3));
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<String> getExploded(@Nonnull String string, @Nullable String string2) {
        return StringHelper.getExploded(string, string2, -1);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<String> getExploded(@Nonnull String string, @Nullable String string2, int n) {
        return StringHelper.getExploded(string, string2, n, n >= 1 ? new CommonsArrayList<int>(n) : new CommonsArrayList());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsHashSet<String> getExplodedToSet(@Nonnull String string, @Nullable String string2) {
        return StringHelper.getExploded(string, string2, -1, new CommonsHashSet());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsLinkedHashSet<String> getExplodedToOrderedSet(@Nonnull String string, @Nullable String string2) {
        return StringHelper.getExploded(string, string2, -1, new CommonsLinkedHashSet());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static CommonsTreeSet<String> getExplodedToSortedSet(@Nonnull String string, @Nullable String string2) {
        return StringHelper.getExploded(string, string2, -1, new CommonsTreeSet());
    }

    @Nonnull
    public static String getRepeated(char c, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "Repeats");
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return Character.toString(c);
        }
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return new String(cArray);
    }

    @Nonnull
    public static String getRepeated(@Nonnull String string, @Nonnegative int n) {
        ValueEnforcer.notNull(string, "Element");
        ValueEnforcer.isGE0(n, "Repeats");
        int n2 = string.length();
        if ((long)n2 * (long)n > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Resulting string exceeds the maximum integer length");
        }
        if (n2 == 0 || n == 0) {
            return "";
        }
        if (n == 1) {
            return string;
        }
        if (n2 == 1) {
            return StringHelper.getRepeated(string.charAt(0), n);
        }
        StringBuilder stringBuilder = new StringBuilder(n2 * n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getConcatenatedOnDemand(@Nullable String string, @Nullable String string2) {
        if (string == null) {
            return string2 == null ? "" : string2;
        }
        if (string2 == null) {
            return string;
        }
        return string + string2;
    }

    @Nonnull
    public static String getConcatenatedOnDemand(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringHelper.hasText(string)) {
            stringBuilder.append(string);
            if (StringHelper.hasText(string2) && StringHelper.hasText(string3)) {
                stringBuilder.append(string2);
            }
        }
        if (StringHelper.hasText(string3)) {
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getConcatenatedOnDemand(@Nullable String string, char c, @Nullable String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringHelper.hasText(string)) {
            stringBuilder.append(string);
            if (StringHelper.hasText(string2)) {
                stringBuilder.append(c);
            }
        }
        if (StringHelper.hasText(string2)) {
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getQuoted(@Nullable String string) {
        return string == null ? "null" : "'" + string + "'";
    }

    public static void appendQuoted(@Nonnull StringBuilder stringBuilder, @Nullable String string) {
        if (string == null) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append('\'').append(string).append('\'');
        }
    }

    public static void appendQuoted(@Nonnull Appendable appendable, @Nullable String string) throws IOException {
        if (string == null) {
            appendable.append("null");
        } else {
            appendable.append('\'').append(string).append('\'');
        }
    }

    public static boolean startsWith(@Nullable CharSequence charSequence, char c) {
        return StringHelper.hasText(charSequence) && charSequence.charAt(0) == c;
    }

    public static boolean startsWithAny(@Nullable CharSequence charSequence, @Nullable char[] cArray) {
        return StringHelper.hasText(charSequence) && cArray != null && ArrayHelper.contains(cArray, charSequence.charAt(0));
    }

    public static boolean startsWithIgnoreCase(@Nullable CharSequence charSequence, char c) {
        return StringHelper.hasText(charSequence) && Character.toLowerCase(charSequence.charAt(0)) == Character.toLowerCase(c);
    }

    public static boolean startsWith(@Nullable CharSequence charSequence, @Nullable CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        int n = charSequence2.length();
        if (n == 0) {
            return true;
        }
        int n2 = charSequence.length();
        if (n2 < n) {
            return false;
        }
        return charSequence.subSequence(0, n).equals(charSequence2);
    }

    public static boolean startsWith(@Nullable String string, @Nullable String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = string2.length();
        if (n == 0) {
            return true;
        }
        int n2 = string.length();
        if (n2 < n) {
            return false;
        }
        if (n == 1) {
            return string.charAt(0) == string2.charAt(0);
        }
        return string.subSequence(0, n).equals(string2);
    }

    public static boolean startsWithIgnoreCase(@Nullable String string, @Nullable String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = string2.length();
        if (n == 0) {
            return true;
        }
        int n2 = string.length();
        if (n2 < n) {
            return false;
        }
        return string.substring(0, n).equalsIgnoreCase(string2);
    }

    public static boolean endsWith(@Nullable CharSequence charSequence, char c) {
        return StringHelper.hasText(charSequence) && StringHelper.getLastChar(charSequence) == c;
    }

    public static boolean endsWithAny(@Nullable CharSequence charSequence, @Nullable char[] cArray) {
        return StringHelper.hasText(charSequence) && cArray != null && ArrayHelper.contains(cArray, StringHelper.getLastChar(charSequence));
    }

    public static boolean endsWith(@Nullable CharSequence charSequence, @Nullable CharSequence charSequence2) {
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        int n = charSequence2.length();
        if (n == 0) {
            return true;
        }
        int n2 = charSequence.length();
        if (n2 < n) {
            return false;
        }
        if (n == 1) {
            return charSequence.charAt(n2 - 1) == charSequence2.charAt(0);
        }
        return charSequence.subSequence(n2 - n, n2).equals(charSequence2);
    }

    public static boolean endsWith(@Nullable String string, @Nullable String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = string2.length();
        if (n == 0) {
            return true;
        }
        int n2 = string.length();
        if (n2 < n) {
            return false;
        }
        if (n == 1) {
            return string.charAt(n2 - 1) == string2.charAt(0);
        }
        return string.startsWith(string2, n2 - n);
    }

    public static boolean endsWithIgnoreCase(@Nullable CharSequence charSequence, char c) {
        return StringHelper.hasText(charSequence) && Character.toLowerCase(StringHelper.getLastChar(charSequence)) == Character.toLowerCase(c);
    }

    public static boolean endsWithIgnoreCase(@Nullable String string, @Nullable String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = string2.length();
        if (n == 0) {
            return true;
        }
        int n2 = string.length();
        if (n2 < n) {
            return false;
        }
        return string.substring(n2 - n, n2).equalsIgnoreCase(string2);
    }

    public static int getIndexOf(@Nullable String string, @Nullable String string2) {
        return string != null && string2 != null && string.length() >= string2.length() ? string.indexOf(string2) : -1;
    }

    public static int getIndexOf(@Nullable String string, @Nonnegative int n, @Nullable String string2) {
        return string != null && string2 != null && string.length() - n >= string2.length() ? string.indexOf(string2, n) : -1;
    }

    public static int getLastIndexOf(@Nullable String string, @Nullable String string2) {
        return string != null && string2 != null && string.length() >= string2.length() ? string.lastIndexOf(string2) : -1;
    }

    public static int getLastIndexOf(@Nullable String string, @Nonnegative int n, @Nullable String string2) {
        return string != null && string2 != null && string.length() - n >= string2.length() ? string.lastIndexOf(string2, n) : -1;
    }

    public static int getIndexOf(@Nullable String string, char c) {
        return string != null && string.length() >= 1 ? string.indexOf(c) : -1;
    }

    public static int getIndexOf(@Nullable String string, @Nonnegative int n, char c) {
        return string != null && string.length() - n >= 1 ? string.indexOf(c, n) : -1;
    }

    public static int getLastIndexOf(@Nullable String string, char c) {
        return string != null && string.length() >= 1 ? string.lastIndexOf(c) : -1;
    }

    public static int getLastIndexOf(@Nullable String string, @Nonnegative int n, char c) {
        return string != null && string.length() - n >= 1 ? string.lastIndexOf(c, n) : -1;
    }

    public static int getIndexOfIgnoreCase(@Nullable String string, @Nullable String string2, @Nonnull Locale locale) {
        return string != null && string2 != null && string.length() >= string2.length() ? string.toLowerCase(locale).indexOf(string2.toLowerCase(locale)) : -1;
    }

    public static int getIndexOfIgnoreCase(@Nullable String string, @Nonnegative int n, @Nullable String string2, @Nonnull Locale locale) {
        return string != null && string2 != null && string.length() - n >= string2.length() ? string.toLowerCase(locale).indexOf(string2.toLowerCase(locale), n) : -1;
    }

    public static int getLastIndexOfIgnoreCase(@Nullable String string, @Nullable String string2, @Nonnull Locale locale) {
        return string != null && string2 != null && string.length() >= string2.length() ? string.toLowerCase(locale).lastIndexOf(string2.toLowerCase(locale)) : -1;
    }

    public static int getLastIndexOfIgnoreCase(@Nullable String string, @Nonnegative int n, @Nullable String string2, @Nonnull Locale locale) {
        return string != null && string2 != null && string.length() - n >= string2.length() ? string.toLowerCase(locale).lastIndexOf(string2.toLowerCase(locale), n) : -1;
    }

    public static int getIndexOfIgnoreCase(@Nullable String string, char c, @Nonnull Locale locale) {
        return string != null && string.length() >= 1 ? string.toLowerCase(locale).indexOf(Character.toLowerCase(c)) : -1;
    }

    public static int getIndexOfIgnoreCase(@Nullable String string, @Nonnegative int n, char c, @Nonnull Locale locale) {
        return string != null && string.length() - n >= 1 ? string.toLowerCase(locale).indexOf(Character.toLowerCase(c), n) : -1;
    }

    public static int getLastIndexOfIgnoreCase(@Nullable String string, char c, @Nonnull Locale locale) {
        return string != null && string.length() >= 1 ? string.toLowerCase(locale).lastIndexOf(Character.toLowerCase(c)) : -1;
    }

    public static int getLastIndexOfIgnoreCase(@Nullable String string, @Nonnegative int n, char c, @Nonnull Locale locale) {
        return string != null && string.length() - n >= 1 ? string.toLowerCase(locale).lastIndexOf(Character.toLowerCase(c), n) : -1;
    }

    public static boolean contains(@Nullable String string, @Nullable String string2) {
        return StringHelper.getIndexOf(string, string2) != -1;
    }

    public static boolean contains(@Nullable String string, char c) {
        return StringHelper.getIndexOf(string, c) != -1;
    }

    public static boolean containsIgnoreCase(@Nullable String string, @Nullable String string2, @Nonnull Locale locale) {
        return StringHelper.getIndexOfIgnoreCase(string, string2, locale) != -1;
    }

    public static boolean containsIgnoreCase(@Nullable String string, char c, @Nonnull Locale locale) {
        return StringHelper.getIndexOfIgnoreCase(string, c, locale) != -1;
    }

    public static boolean containsAny(@Nullable char[] cArray, @Nonnull char[] cArray2) {
        ValueEnforcer.notNull(cArray2, "SearchChars");
        if (cArray != null) {
            for (char c : cArray) {
                if (!ArrayHelper.contains(cArray2, c)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(@Nullable String string, @Nonnull char[] cArray) {
        return string != null && StringHelper.containsAny(string.toCharArray(), cArray);
    }

    @Nonnegative
    public static int getOccurrenceCount(@Nullable String string, @Nullable String string2) {
        int n = 0;
        int n2 = StringHelper.getLength(string);
        int n3 = StringHelper.getLength(string2);
        if (n3 > 0 && n2 >= n3) {
            int n4;
            int n5 = 0;
            do {
                if ((n4 = StringHelper.getIndexOf(string, n5, string2)) == -1) continue;
                ++n;
                n5 = n4 + n3;
            } while (n4 != -1);
        }
        return n;
    }

    @Nonnegative
    public static int getOccurrenceCountIgnoreCase(@Nullable String string, @Nullable String string2, @Nonnull Locale locale) {
        return string != null && string2 != null ? StringHelper.getOccurrenceCount(string.toLowerCase(locale), string2.toLowerCase(locale)) : 0;
    }

    @Nonnegative
    public static int getOccurrenceCount(@Nullable String string, char c) {
        int n = 0;
        int n2 = StringHelper.getLength(string);
        if (n2 >= 1) {
            int n3;
            int n4 = 0;
            do {
                if ((n3 = StringHelper.getIndexOf(string, n4, c)) == -1) continue;
                ++n;
                n4 = n3 + 1;
            } while (n3 != -1);
        }
        return n;
    }

    @Nonnegative
    public static int getOccurrenceCountIgnoreCase(@Nullable String string, char c, @Nonnull Locale locale) {
        return string != null ? StringHelper.getOccurrenceCount(string.toLowerCase(locale), Character.toLowerCase(c)) : 0;
    }

    @Nullable
    @CheckReturnValue
    public static String trimLeadingWhitespaces(@Nullable String string) {
        int n = StringHelper.getLeadingWhitespaceCount(string);
        return n == 0 ? string : string.substring(n, string.length());
    }

    @Nullable
    @CheckReturnValue
    public static String trimTrailingWhitespaces(@Nullable String string) {
        int n = StringHelper.getTrailingWhitespaceCount(string);
        return n == 0 ? string : string.substring(0, string.length() - n);
    }

    @Nullable
    @CheckReturnValue
    public static String trimStart(@Nullable String string, @Nullable String string2) {
        return StringHelper.startsWith(string, string2) ? string.substring(string2.length(), string.length()) : string;
    }

    @Nullable
    @CheckReturnValue
    public static String trimStartRepeatedly(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        int n = StringHelper.getLength(string2);
        if (n == 0) {
            return string;
        }
        String string3 = string;
        while (StringHelper.startsWith(string3, string2)) {
            string3 = string3.substring(n, string3.length());
        }
        return string3;
    }

    @Nullable
    @CheckReturnValue
    public static String trimStart(@Nullable String string, char c) {
        return StringHelper.startsWith((CharSequence)string, c) ? string.substring(1, string.length()) : string;
    }

    @Nullable
    @CheckReturnValue
    public static String trimStartRepeatedly(@Nullable String string, char c) {
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        String string2 = string;
        while (StringHelper.startsWith((CharSequence)string2, c)) {
            string2 = string2.substring(1, string2.length());
        }
        return string2;
    }

    @Nullable
    @CheckReturnValue
    public static String trimStart(@Nullable String string, @Nonnegative int n) {
        if (n <= 0) {
            return string;
        }
        return StringHelper.getLength(string) <= n ? "" : string.substring(n, string.length());
    }

    @Nullable
    @CheckReturnValue
    public static String trimEnd(@Nullable String string, @Nullable String string2) {
        return StringHelper.endsWith(string, string2) ? string.substring(0, string.length() - string2.length()) : string;
    }

    @Nullable
    @CheckReturnValue
    public static String trimEndRepeatedly(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        int n = StringHelper.getLength(string2);
        if (n == 0) {
            return string;
        }
        String string3 = string;
        while (StringHelper.endsWith(string3, string2)) {
            string3 = string3.substring(0, string3.length() - n);
        }
        return string3;
    }

    @Nullable
    @CheckReturnValue
    public static String trimEnd(@Nullable String string, char c) {
        return StringHelper.endsWith((CharSequence)string, c) ? string.substring(0, string.length() - 1) : string;
    }

    @Nullable
    @CheckReturnValue
    public static String trimEndRepeatedly(@Nullable String string, char c) {
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        String string2 = string;
        while (StringHelper.endsWith((CharSequence)string2, c)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    @Nullable
    @CheckReturnValue
    public static String trimEnd(@Nullable String string, @Nonnegative int n) {
        if (n <= 0) {
            return string;
        }
        return StringHelper.getLength(string) <= n ? "" : string.substring(0, string.length() - n);
    }

    @Nullable
    @CheckReturnValue
    public static String trimStartAndEnd(@Nullable String string, @Nullable String string2) {
        return StringHelper.trimStartAndEnd(string, string2, string2);
    }

    @Nullable
    @CheckReturnValue
    public static String trimStartAndEnd(@Nullable String string, @Nullable String string2, @Nullable String string3) {
        String string4 = StringHelper.trimStart(string, string2);
        return StringHelper.trimEnd(string4, string3);
    }

    @Nullable
    @CheckReturnValue
    public static String trimStartAndEnd(@Nullable String string, char c) {
        return StringHelper.trimStartAndEnd(string, c, c);
    }

    @Nullable
    @CheckReturnValue
    public static String trimStartAndEnd(@Nullable String string, char c, char c2) {
        String string2 = StringHelper.trimStart(string, c);
        return StringHelper.trimEnd(string2, c2);
    }

    @Nullable
    @CheckReturnValue
    public static String trim(@Nullable String string) {
        return StringHelper.hasNoText(string) ? string : string.trim();
    }

    public static char getFirstChar(@Nullable CharSequence charSequence) {
        return StringHelper.hasText(charSequence) ? charSequence.charAt(0) : (char)'\u0000';
    }

    public static char getFirstChar(@Nullable char[] cArray) {
        return ArrayHelper.getFirst(cArray, '\u0000');
    }

    public static char getLastChar(@Nullable CharSequence charSequence) {
        int n = StringHelper.getLength(charSequence);
        return n > 0 ? charSequence.charAt(n - 1) : (char)'\u0000';
    }

    public static char getLastChar(@Nullable char[] cArray) {
        return ArrayHelper.getLast(cArray, '\u0000');
    }

    @Nonnegative
    public static int getCharCount(@Nullable String string, char c) {
        return string == null ? 0 : StringHelper.getCharCount(string.toCharArray(), c);
    }

    @Nonnegative
    public static int getCharCount(@Nullable char[] cArray, char c) {
        int n = 0;
        if (cArray != null) {
            for (char c2 : cArray) {
                if (c2 != c) continue;
                ++n;
            }
        }
        return n;
    }

    @Nonnegative
    public static int getLineCount(@Nullable String string) {
        return StringHelper.getLineCount(string, '\n');
    }

    @Nonnegative
    public static int getLineCount(@Nullable String string, char c) {
        return 1 + StringHelper.getCharCount(string, c);
    }

    @Nonnegative
    public static int getCharacterCount(int n) {
        int n2 = n < 0 ? 2 : 1;
        int n3 = MathHelper.abs(n);
        int n4 = 0;
        while (n3 > SIZE_TABLE_INT[n4]) {
            ++n4;
        }
        return n2 + n4;
    }

    @Nonnegative
    public static int getCharacterCount(long l) {
        int n = l < 0L ? 2 : 1;
        long l2 = MathHelper.abs(l);
        int n2 = 0;
        while (l2 > SIZE_TABLE_LONG[n2]) {
            ++n2;
        }
        return n + n2;
    }

    @Nonnull
    public static String getCutAfterLength(@Nonnull String string, @Nonnegative int n) {
        return StringHelper.getCutAfterLength(string, n, null);
    }

    @Nonnull
    public static String getCutAfterLength(@Nonnull String string, @Nonnegative int n, @Nullable String string2) {
        ValueEnforcer.notNull(string, "Value");
        ValueEnforcer.isGE0(n, "MaxLength");
        if (string.length() <= n) {
            return string;
        }
        if (StringHelper.hasNoText(string2)) {
            return string.substring(0, n);
        }
        return string.substring(0, n) + string2;
    }

    public static String replaceAllSafe(@Nullable String string, @Nonnull String string2, @Nullable CharSequence charSequence) {
        return StringHelper.replaceAll(string, string2, StringHelper.getNotNull(charSequence, (CharSequence)""));
    }

    @Nullable
    public static String replaceAll(@Nullable String string, @Nonnull String string2, @Nonnull CharSequence charSequence) {
        int n;
        int n2;
        ValueEnforcer.notEmpty(string2, "SearchText");
        ValueEnforcer.notNull(charSequence, "ReplacementText");
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        int n3 = string2.length();
        if (n3 == (n2 = charSequence.length())) {
            if (string2.equals(charSequence)) {
                return string;
            }
            if (n3 == 1) {
                return StringHelper.replaceAll(string, string2.charAt(0), charSequence.charAt(0));
            }
        }
        if ((n = string.indexOf(string2, 0)) == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n3 >= n2 ? string.length() : string.length() * 2);
        int n4 = 0;
        do {
            stringBuilder.append(string, n4, n).append(charSequence);
            n4 = n += n3;
        } while ((n = string.indexOf(string2, n)) != -1);
        stringBuilder.append(string, n4, string.length());
        return stringBuilder.toString();
    }

    @Nullable
    public static String replaceAll(@Nullable String string, char c, char c2) {
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        if (c == c2) {
            return string;
        }
        int n = string.indexOf(c, 0);
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = 0;
        do {
            stringBuilder.append(string, n2, n).append(c2);
            n2 = ++n;
        } while ((n = string.indexOf(c, n)) != -1);
        stringBuilder.append(string, n2, string.length());
        return stringBuilder.toString();
    }

    @Nullable
    public static String replaceAllRepeatedly(@Nullable String string, @Nonnull String string2, @Nonnull String string3) {
        String string4;
        ValueEnforcer.notEmpty(string2, "SearchText");
        ValueEnforcer.notNull(string3, "ReplacementText");
        ValueEnforcer.isFalse(string3.contains(string2), "Loop detection: replacementText must not contain searchText");
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        String string5 = string;
        while (!(string4 = string5).equals(string5 = StringHelper.replaceAll(string5, string2, string3))) {
        }
        return string5;
    }

    public static int getReplaceMultipleResultLength(@Nonnull char[] cArray, @Nonnull @Nonempty char[] cArray2, @Nonnull @Nonempty char[][] cArray3) {
        int n = 0;
        boolean bl = false;
        for (char c : cArray) {
            int n2 = 1;
            for (int i = 0; i < cArray2.length; ++i) {
                if (c != cArray2[i]) continue;
                n2 = cArray3[i].length;
                bl = true;
                break;
            }
            n += n2;
        }
        return bl ? n : -1;
    }

    @Nonnull
    public static char[] replaceMultiple(@Nullable String string, @Nonnull char[] cArray, @Nonnull char[][] cArray2) {
        if (StringHelper.hasNoText(string)) {
            return ArrayHelper.EMPTY_CHAR_ARRAY;
        }
        return StringHelper.replaceMultiple(string.toCharArray(), cArray, cArray2);
    }

    @Nonnull
    public static char[] replaceMultiple(@Nullable char[] cArray, @Nonnull char[] cArray2, @Nonnull char[][] cArray3) {
        ValueEnforcer.notNull(cArray2, "SearchChars");
        ValueEnforcer.notNull(cArray3, "ReplacementStrings");
        ValueEnforcer.isEqual(cArray2.length, cArray3.length, "array length mismatch");
        if (cArray == null || cArray.length == 0) {
            return ArrayHelper.EMPTY_CHAR_ARRAY;
        }
        if (cArray2.length == 0) {
            return cArray;
        }
        int n = StringHelper.getReplaceMultipleResultLength(cArray, cArray2, cArray3);
        if (n == -1) {
            return cArray;
        }
        char[] cArray4 = new char[n];
        int n2 = 0;
        for (char c : cArray) {
            boolean bl = false;
            for (int i = 0; i < cArray2.length; ++i) {
                if (c != cArray2[i]) continue;
                char[] cArray5 = cArray3[i];
                int n3 = cArray5.length;
                System.arraycopy(cArray5, 0, cArray4, n2, n3);
                n2 += n3;
                bl = true;
                break;
            }
            if (bl) continue;
            cArray4[n2++] = c;
        }
        return cArray4;
    }

    @Nonnegative
    public static int replaceMultipleTo(@Nullable String string, @Nonnull char[] cArray, @Nonnull char[][] cArray2, @Nonnull Writer writer) throws IOException {
        if (StringHelper.hasNoText(string)) {
            return 0;
        }
        return StringHelper.replaceMultipleTo(string.toCharArray(), cArray, cArray2, writer);
    }

    @Nonnegative
    public static int replaceMultipleTo(@Nullable char[] cArray, @Nonnull char[] cArray2, @Nonnull char[][] cArray3, @Nonnull Writer writer) throws IOException {
        return cArray == null ? 0 : StringHelper.replaceMultipleTo(cArray, 0, cArray.length, cArray2, cArray3, writer);
    }

    @Nonnegative
    public static int replaceMultipleTo(@Nullable char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull char[] cArray2, @Nonnull char[][] cArray3, @Nonnull Writer writer) throws IOException {
        if (cArray != null) {
            ValueEnforcer.isArrayOfsLen(cArray, n, n2);
        }
        ValueEnforcer.notNull(cArray2, "SearchChars");
        ValueEnforcer.notNull(cArray3, "ReplacementStrings");
        ValueEnforcer.isEqual(cArray2.length, cArray3.length, "array length mismatch");
        ValueEnforcer.notNull(writer, "Target");
        if (cArray == null || cArray.length == 0 || n2 == 0) {
            return 0;
        }
        if (cArray2.length == 0) {
            writer.write(cArray, n, n2);
            return 0;
        }
        int n3 = n;
        int n4 = n;
        int n5 = 0;
        int n6 = cArray2.length;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[n + i];
            for (int j = 0; j < n6; ++j) {
                if (c != cArray2[j]) continue;
                if (n3 < n4) {
                    writer.write(cArray, n3, n4 - n3);
                }
                n3 = n4 + 1;
                writer.write(cArray3[j]);
                ++n5;
                break;
            }
            ++n4;
        }
        if (n3 < n4) {
            writer.write(cArray, n3, n4 - n3);
        }
        return n5;
    }

    @Nonnull
    public static char[] replaceMultiple(@Nullable String string, @Nonnull char[] cArray, char c) {
        ValueEnforcer.notNull(cArray, "SearchChars");
        if (StringHelper.hasNoText(string)) {
            return ArrayHelper.EMPTY_CHAR_ARRAY;
        }
        char[] cArray2 = string.toCharArray();
        if (cArray.length == 0) {
            return cArray2;
        }
        char[] cArray3 = new char[cArray2.length];
        int n = 0;
        for (char c2 : cArray2) {
            cArray3[n] = ArrayHelper.contains(cArray, c2) ? c : c2;
            ++n;
        }
        return cArray3;
    }

    public static void replaceMultipleTo(@Nullable String string, @Nonnull char[] cArray, char c, @Nonnull StringBuilder stringBuilder) {
        ValueEnforcer.notNull(cArray, "SearchChars");
        ValueEnforcer.notNull(stringBuilder, "Target");
        if (StringHelper.hasText(string)) {
            if (cArray.length == 0) {
                stringBuilder.append(string);
            } else {
                for (char c2 : string.toCharArray()) {
                    if (ArrayHelper.contains(cArray, c2)) {
                        stringBuilder.append(c);
                        continue;
                    }
                    stringBuilder.append(c2);
                }
            }
        }
    }

    public static void replaceMultipleTo(@Nullable String string, @Nonnull char[] cArray, char c, @Nonnull Writer writer) throws IOException {
        ValueEnforcer.notNull(cArray, "SearchChars");
        ValueEnforcer.notNull(writer, "Target");
        if (StringHelper.hasText(string)) {
            if (cArray.length == 0) {
                writer.write(string);
            } else {
                for (char c2 : string.toCharArray()) {
                    if (ArrayHelper.contains(cArray, c2)) {
                        writer.write(c);
                        continue;
                    }
                    writer.write(c2);
                }
            }
        }
    }

    @Nonnull
    public static String replaceMultipleAsString(@Nullable String string, @Nonnull char[] cArray, char c) {
        ValueEnforcer.notNull(cArray, "SearchChars");
        if (StringHelper.hasNoText(string)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        StringHelper.replaceMultipleTo(string, cArray, c, stringBuilder);
        return stringBuilder.toString();
    }

    @Nullable
    public static String replaceMultiple(@Nullable String string, @Nullable Map<String, String> map) {
        if (StringHelper.hasNoText(string) || map == null || map.isEmpty()) {
            return string;
        }
        String string2 = string;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            string2 = StringHelper.replaceAll(string2, entry.getKey(), entry.getValue());
        }
        return string2;
    }

    @Nullable
    public static String replaceMultiple(@Nullable String string, @Nullable String[] stringArray, @Nullable String[] stringArray2) {
        int n;
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        int n2 = stringArray == null ? 0 : stringArray.length;
        int n3 = n = stringArray2 == null ? 0 : stringArray2.length;
        if (n2 != n) {
            throw new IllegalArgumentException("Array length mismatch!");
        }
        if (n2 == 0) {
            return string;
        }
        String string2 = string;
        for (int i = 0; i < n2; ++i) {
            string2 = StringHelper.replaceAll(string2, stringArray[i], stringArray2[i]);
        }
        return string2;
    }

    @Nullable
    public static String removeAll(@Nullable String string, char c) {
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        int n = string.indexOf(c, 0);
        if (n == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append(cArray, 0, n);
        for (int i = n; i < n2; ++i) {
            char c2 = cArray[i];
            if (c2 == c) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    @Nullable
    public static String removeAll(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        int n = StringHelper.getLength(string2);
        if (n == 0) {
            return string;
        }
        if (n == 1) {
            return StringHelper.removeAll(string, string2.charAt(0));
        }
        int n2 = string.indexOf(string2, 0);
        if (n2 == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n3 = 0;
        do {
            stringBuilder.append(string, n3, n2);
        } while ((n2 = string.indexOf(string2, n3 = n2 + n)) != -1);
        stringBuilder.append(string, n3, string.length());
        return stringBuilder.toString();
    }

    @Nonnegative
    public static int getLength(@Nullable CharSequence charSequence) {
        return charSequence == null ? 0 : charSequence.length();
    }

    @Nonnull
    public static String getNotNull(@Nullable String string) {
        return StringHelper.getNotNull(string, "");
    }

    @Nullable
    public static String getNotNull(@Nullable String string, String string2) {
        return string == null ? string2 : string;
    }

    @Nonnull
    public static CharSequence getNotNull(@Nullable CharSequence charSequence) {
        return StringHelper.getNotNull(charSequence, (CharSequence)"");
    }

    @Nullable
    public static CharSequence getNotNull(@Nullable CharSequence charSequence, CharSequence charSequence2) {
        return charSequence == null ? charSequence2 : charSequence;
    }

    @Nullable
    public static String getNotEmpty(@Nullable String string, @Nullable String string2) {
        return StringHelper.hasNoText(string) ? string2 : string;
    }

    @Nullable
    public static CharSequence getNotEmpty(@Nullable CharSequence charSequence, @Nullable CharSequence charSequence2) {
        return StringHelper.hasNoText(charSequence) ? charSequence2 : charSequence;
    }

    @Nonnull
    public static String getToString(@Nullable Object object) {
        return StringHelper.getToString(object, "");
    }

    @Nullable
    public static String getToString(@Nullable Object object, @Nullable String string) {
        return object == null ? string : object.toString();
    }

    @Nonnull
    public static String getWithoutLeadingChar(@Nullable String string) {
        return StringHelper.getWithoutLeadingChars(string, 1);
    }

    @Nonnull
    public static String getWithoutLeadingChars(@Nullable String string, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "Count");
        if (n == 0) {
            return string;
        }
        return StringHelper.getLength(string) <= n ? "" : string.substring(n);
    }

    @Nonnull
    public static String getWithoutTrailingChar(@Nullable String string) {
        return StringHelper.getWithoutTrailingChars(string, 1);
    }

    @Nonnull
    public static String getWithoutTrailingChars(@Nullable String string, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "Count");
        if (n == 0) {
            return string;
        }
        int n2 = StringHelper.getLength(string);
        return n2 <= n ? "" : string.substring(0, n2 - n);
    }

    @Nonnull
    public static String getWithoutAnySpaces(@Nullable String string) {
        if (string == null) {
            return "";
        }
        char[] cArray = string.trim().toCharArray();
        StringBuilder stringBuilder = new StringBuilder(cArray.length);
        for (char c : cArray) {
            if (Character.isWhitespace(c) || Character.isSpaceChar(c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    @Nullable
    private static String _getUntilFirst(@Nullable String string, char c, boolean bl) {
        int n = StringHelper.getIndexOf(string, c);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n + (bl ? 1 : 0));
    }

    @Nullable
    public static String getUntilFirstIncl(@Nullable String string, char c) {
        return StringHelper._getUntilFirst(string, c, true);
    }

    @Nullable
    public static String getUntilFirstExcl(@Nullable String string, char c) {
        return StringHelper._getUntilFirst(string, c, false);
    }

    @Nullable
    private static String _getUntilFirst(@Nullable String string, @Nullable String string2, boolean bl) {
        if (StringHelper.hasNoText(string2)) {
            return "";
        }
        int n = StringHelper.getIndexOf(string, string2);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n + (bl ? string2.length() : 0));
    }

    @Nullable
    public static String getUntilFirstIncl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getUntilFirst(string, string2, true);
    }

    @Nullable
    public static String getUntilFirstExcl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getUntilFirst(string, string2, false);
    }

    @Nullable
    private static String _getUntilLast(@Nullable String string, char c, boolean bl) {
        int n = StringHelper.getLastIndexOf(string, c);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n + (bl ? 1 : 0));
    }

    @Nullable
    public static String getUntilLastIncl(@Nullable String string, char c) {
        return StringHelper._getUntilLast(string, c, true);
    }

    @Nullable
    public static String getUntilLastExcl(@Nullable String string, char c) {
        return StringHelper._getUntilLast(string, c, false);
    }

    @Nullable
    private static String _getUntilLast(@Nullable String string, @Nullable String string2, boolean bl) {
        if (StringHelper.hasNoText(string2)) {
            return "";
        }
        int n = StringHelper.getLastIndexOf(string, string2);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n + (bl ? string2.length() : 0));
    }

    @Nullable
    public static String getUntilLastIncl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getUntilLast(string, string2, true);
    }

    @Nullable
    public static String getUntilLastExcl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getUntilLast(string, string2, false);
    }

    @Nullable
    private static String _getFromFirst(@Nullable String string, char c, boolean bl) {
        int n = StringHelper.getIndexOf(string, c);
        if (n == -1) {
            return null;
        }
        return string.substring(n + (bl ? 0 : 1));
    }

    @Nullable
    public static String getFromFirstIncl(@Nullable String string, char c) {
        return StringHelper._getFromFirst(string, c, true);
    }

    @Nullable
    public static String getFromFirstExcl(@Nullable String string, char c) {
        return StringHelper._getFromFirst(string, c, false);
    }

    @Nullable
    private static String _getFromFirst(@Nullable String string, @Nullable String string2, boolean bl) {
        if (StringHelper.hasNoText(string2)) {
            return string;
        }
        int n = StringHelper.getIndexOf(string, string2);
        if (n == -1) {
            return null;
        }
        return string.substring(n + (bl ? 0 : string2.length()));
    }

    @Nullable
    public static String getFromFirstIncl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getFromFirst(string, string2, true);
    }

    @Nullable
    public static String getFromFirstExcl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getFromFirst(string, string2, false);
    }

    @Nullable
    private static String _getFromLast(@Nullable String string, char c, boolean bl) {
        int n = StringHelper.getLastIndexOf(string, c);
        if (n == -1) {
            return null;
        }
        return string.substring(n + (bl ? 0 : 1));
    }

    @Nullable
    public static String getFromLastIncl(@Nullable String string, char c) {
        return StringHelper._getFromLast(string, c, true);
    }

    @Nullable
    public static String getFromLastExcl(@Nullable String string, char c) {
        return StringHelper._getFromLast(string, c, false);
    }

    @Nullable
    private static String _getFromLast(@Nullable String string, @Nullable String string2, boolean bl) {
        if (StringHelper.hasNoText(string2)) {
            return string;
        }
        int n = StringHelper.getLastIndexOf(string, string2);
        if (n == -1) {
            return null;
        }
        return string.substring(n + (bl ? 0 : string2.length()));
    }

    @Nullable
    public static String getFromLastIncl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getFromLast(string, string2, true);
    }

    @Nullable
    public static String getFromLastExcl(@Nullable String string, @Nullable String string2) {
        return StringHelper._getFromLast(string, string2, false);
    }

    @Nullable
    public static String getFirstToken(@Nullable String string, char c) {
        int n = StringHelper.getIndexOf(string, c);
        return n == -1 ? string : string.substring(0, n);
    }

    @Nullable
    public static String getFirstToken(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string2)) {
            return string;
        }
        int n = StringHelper.getIndexOf(string, string2);
        return n == -1 ? string : string.substring(0, n);
    }

    @Nullable
    public static String getLastToken(@Nullable String string, char c) {
        int n = StringHelper.getLastIndexOf(string, c);
        return n == -1 ? string : string.substring(n + 1);
    }

    @Nullable
    public static String getLastToken(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string2)) {
            return string;
        }
        int n = StringHelper.getLastIndexOf(string, string2);
        return n == -1 ? string : string.substring(n + StringHelper.getLength(string2));
    }

    @Nullable
    public static String getReverse(@Nullable String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        if (cArray.length <= 1) {
            return string;
        }
        char[] cArray2 = new char[cArray.length];
        int n = cArray.length - 1;
        int n2 = 0;
        while (n >= 0) {
            cArray2[n2] = cArray[n];
            --n;
            ++n2;
        }
        return new String(cArray2);
    }

    @Nonnull
    public static String removeMultiple(@Nullable String string, @Nonnull char[] cArray) {
        ValueEnforcer.notNull(cArray, "RemoveChars");
        if (StringHelper.hasNoText(string)) {
            return "";
        }
        if (cArray.length == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        StringHelper.iterateChars(string, c -> {
            if (!ArrayHelper.contains(cArray, c)) {
                stringBuilder.append(c);
            }
        });
        return stringBuilder.toString();
    }

    public static void iterateChars(@Nullable String string, @Nonnull ICharConsumer iCharConsumer) {
        ValueEnforcer.notNull(iCharConsumer, "Consumer");
        if (string != null) {
            char[] cArray;
            for (char c : cArray = string.toCharArray()) {
                iCharConsumer.accept(c);
            }
        }
    }

    public static void iterateCodePoints(@Nullable String string, @Nonnull IntConsumer intConsumer) {
        ValueEnforcer.notNull(intConsumer, "Consumer");
        if (string != null) {
            int n;
            int n2 = string.length();
            for (int i = 0; i < n2; i += Character.charCount(n)) {
                n = string.codePointAt(i);
                intConsumer.accept(n);
            }
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] encodeCharToBytes(@Nonnull char[] cArray, @Nonnull Charset charset) {
        return StringHelper.encodeCharToBytes(cArray, 0, cArray.length, charset);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static byte[] encodeCharToBytes(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Charset charset) {
        ValueEnforcer.isArrayOfsLen(cArray, n, n2);
        CharsetEncoder charsetEncoder = charset.newEncoder();
        int n3 = (int)((double)n2 * (double)charsetEncoder.maxBytesPerChar());
        byte[] byArray = new byte[n3];
        if (n2 == 0) {
            return byArray;
        }
        charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).reset();
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        try {
            CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
            if (!coderResult.isUnderflow()) {
                coderResult.throwException();
            }
            if (!(coderResult = charsetEncoder.flush(byteBuffer)).isUnderflow()) {
                coderResult.throwException();
            }
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IllegalStateException(characterCodingException);
        }
        int n4 = byteBuffer.position();
        if (n4 == byArray.length) {
            return byArray;
        }
        return Arrays.copyOf(byArray, n4);
    }

    @Nonnull
    public static char[] decodeBytesToChars(@Nonnull byte[] byArray, @Nonnull Charset charset) {
        return StringHelper.decodeBytesToChars(byArray, 0, byArray.length, charset);
    }

    @Nonnull
    public static char[] decodeBytesToChars(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Charset charset) {
        CharsetDecoder charsetDecoder = charset.newDecoder();
        int n3 = (int)((double)n2 * (double)charsetDecoder.maxCharsPerByte());
        char[] cArray = new char[n3];
        if (n2 == 0) {
            return cArray;
        }
        charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).reset();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        try {
            CoderResult coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true);
            if (!coderResult.isUnderflow()) {
                coderResult.throwException();
            }
            if (!(coderResult = charsetDecoder.flush(charBuffer)).isUnderflow()) {
                coderResult.throwException();
            }
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IllegalStateException(characterCodingException);
        }
        int n4 = charBuffer.position();
        if (n4 == cArray.length) {
            return cArray;
        }
        return Arrays.copyOf(cArray, n4);
    }

    public static class ImploderBuilderMap
    implements IBuilder<String> {
        private ICommonsMap<String, String> m_aSource;
        private String m_sSeparatorOuter;
        private String m_sSeparatorInner;
        private Predicate<String> m_aFilterKey;
        private Predicate<String> m_aFilterValue;

        @Nullable
        private static String _valueOf(@Nullable Object object) {
            return object == null ? null : object.toString();
        }

        @Nonnull
        public ImploderBuilderMap source(@Nullable Map<?, ?> map) {
            return this.source(map, ImploderBuilderMap::_valueOf, ImploderBuilderMap::_valueOf);
        }

        @Nonnull
        public <K, V> ImploderBuilderMap source(@Nullable Map<K, V> map, @Nonnull Function<? super K, String> function, @Nonnull Function<? super V, String> function2) {
            ValueEnforcer.notNull(function, "KeyMapper");
            ValueEnforcer.notNull(function2, "ValueMapper");
            this.m_aSource = map == null ? null : new CommonsLinkedHashMap<String, String>(map, function, function2);
            return this;
        }

        @Nonnull
        public ImploderBuilderMap separatorOuter(char c) {
            return this.separatorOuter(Character.toString(c));
        }

        @Nonnull
        public ImploderBuilderMap separatorOuter(@Nullable String string) {
            this.m_sSeparatorOuter = string;
            return this;
        }

        @Nonnull
        public ImploderBuilderMap separatorInner(char c) {
            return this.separatorInner(Character.toString(c));
        }

        @Nonnull
        public ImploderBuilderMap separatorInner(@Nullable String string) {
            this.m_sSeparatorInner = string;
            return this;
        }

        @Nonnull
        public ImploderBuilderMap filterKeyNonEmpty() {
            return this.filterKey(StringHelper::hasText);
        }

        @Nonnull
        public ImploderBuilderMap filterKey(@Nullable Predicate<String> predicate) {
            this.m_aFilterKey = predicate;
            return this;
        }

        @Nonnull
        public ImploderBuilderMap filterValueNonEmpty() {
            return this.filterValue(StringHelper::hasText);
        }

        @Nonnull
        public ImploderBuilderMap filterValue(@Nullable Predicate<String> predicate) {
            this.m_aFilterValue = predicate;
            return this;
        }

        @Override
        @Nonnull
        public String build() {
            ICommonsMap<String, String> iCommonsMap = this.m_aSource;
            if (iCommonsMap == null || iCommonsMap.isEmpty()) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.m_sSeparatorOuter;
            String string2 = this.m_sSeparatorInner;
            Predicate<Object> predicate = this.m_aFilterKey == null ? Predicates.all() : this.m_aFilterKey;
            Predicate<Object> predicate2 = this.m_aFilterValue == null ? Predicates.all() : this.m_aFilterValue;
            int n = 0;
            for (Map.Entry entry : iCommonsMap.entrySet()) {
                String string3 = (String)entry.getKey();
                String string4 = (String)entry.getValue();
                if (!predicate.test(string3) || !predicate2.test(string4)) continue;
                if (n > 0 && string != null) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(string3);
                if (string2 != null) {
                    stringBuilder.append(string2);
                }
                stringBuilder.append(string4);
                ++n;
            }
            return stringBuilder.toString();
        }
    }

    public static class ImploderBuilder
    implements IBuilder<String> {
        private ICommonsList<String> m_aSource;
        private String m_sSeparator;
        private int m_nOffset = 0;
        private int m_nLength = -1;
        private Predicate<String> m_aFilter;

        @Nullable
        private static String _valueOf(@Nullable Object object) {
            return object == null ? null : object.toString();
        }

        @Nonnull
        public ImploderBuilder source(@Nullable Iterable<?> iterable) {
            return this.source(iterable, ImploderBuilder::_valueOf);
        }

        @Nonnull
        public <T> ImploderBuilder source(@Nullable Iterable<T> iterable, @Nonnull Function<? super T, String> function) {
            ValueEnforcer.notNull(function, "Mapper");
            this.m_aSource = iterable == null ? null : new CommonsArrayList<String>(iterable, function);
            return this;
        }

        @Nonnull
        public ImploderBuilder source(String ... stringArray) {
            this.m_aSource = stringArray == null ? null : new CommonsArrayList<String>(stringArray);
            return this;
        }

        @Nonnull
        @SafeVarargs
        public final <T> ImploderBuilder source(T ... TArray) {
            return this.source(TArray, ImploderBuilder::_valueOf);
        }

        @Nonnull
        public <T> ImploderBuilder source(@Nullable T[] TArray, @Nonnull Function<? super T, String> function) {
            ValueEnforcer.notNull(function, "Mapper");
            this.m_aSource = TArray == null ? null : new CommonsArrayList<String>(TArray, function);
            return this;
        }

        @Nonnull
        public ImploderBuilder separator(char c) {
            return this.separator(Character.toString(c));
        }

        @Nonnull
        public ImploderBuilder separator(@Nullable String string) {
            this.m_sSeparator = string;
            return this;
        }

        @Nonnull
        public ImploderBuilder offset(int n) {
            this.m_nOffset = n;
            return this;
        }

        @Nonnull
        public ImploderBuilder length(int n) {
            this.m_nLength = n;
            return this;
        }

        @Nonnull
        public ImploderBuilder filterNonEmpty() {
            return this.filter(StringHelper::hasText);
        }

        @Nonnull
        public ImploderBuilder filter(@Nullable Predicate<String> predicate) {
            this.m_aFilter = predicate;
            return this;
        }

        @Override
        @Nonnull
        public String build() {
            Predicate<Object> predicate;
            ICommonsList<String> iCommonsList = this.m_aSource;
            if (iCommonsList == null || iCommonsList.isEmpty() || this.m_nLength == 0) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.m_sSeparator;
            Predicate<Object> predicate2 = predicate = this.m_aFilter == null ? Predicates.all() : this.m_aFilter;
            if (this.m_nOffset <= 0 && this.m_nLength < 0) {
                int n = 0;
                for (String string2 : iCommonsList) {
                    if (!predicate.test(string2)) continue;
                    if (n > 0 && string != null) {
                        stringBuilder.append(string);
                    }
                    stringBuilder.append(string2);
                    ++n;
                }
            } else {
                int n = Math.max(0, this.m_nOffset);
                int n2 = iCommonsList.size();
                if (this.m_nLength > 0) {
                    n2 = Math.min(n2, n + this.m_nLength);
                }
                int n3 = 0;
                for (int i = n; i < n2; ++i) {
                    String string3 = (String)iCommonsList.get(i);
                    if (!predicate.test(string3)) continue;
                    if (n3 > 0 && string != null) {
                        stringBuilder.append(string);
                    }
                    stringBuilder.append(string3);
                    ++n3;
                }
            }
            return stringBuilder.toString();
        }
    }
}

