/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diver.api.version;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementComparable;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.diver.api.version.EVESPseudoVersion;
import com.helger.diver.api.version.VESVersion;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementComparable
@MustImplementEqualsAndHashcode
public final class VESID
implements Comparable<VESID> {
    @RegEx
    public static final String REGEX_PART = "[a-zA-Z0-9_\\-\\.]+";
    public static final char ID_SEPARATOR = ':';
    private final String m_sGroupID;
    private final String m_sArtifactID;
    private final VESVersion m_aVersion;
    private final String m_sClassifier;
    private int m_nHashCode = 0;

    public static boolean isValidPart(@Nullable String string) {
        return StringHelper.hasText((String)string) && RegExHelper.stringMatchesPattern((String)REGEX_PART, (String)string);
    }

    public VESID(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3) {
        this(string, string2, string3, (String)null);
    }

    public VESID(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nullable String string4) {
        this(string, string2, VESVersion.parseOrThrow(string3), string4);
    }

    protected VESID(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull VESVersion vESVersion, @Nullable String string3) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"GroupID");
        ValueEnforcer.isTrue((boolean)VESID.isValidPart(string), () -> "GroupID '" + string + "' is invalid");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"ArtifactID");
        ValueEnforcer.isTrue((boolean)VESID.isValidPart(string2), () -> "ArtifactID '" + string2 + "' is invalid");
        ValueEnforcer.notNull((Object)vESVersion, (String)"Version");
        ValueEnforcer.isTrue((boolean)VESID.isValidPart(vESVersion.getAsString()), () -> "Version '" + vESVersion + "' is invalid");
        if (StringHelper.hasText((String)string3)) {
            ValueEnforcer.isTrue((boolean)VESID.isValidPart(string3), () -> "Classifier '" + string3 + "' is invalid");
        }
        this.m_sGroupID = string;
        this.m_sArtifactID = string2;
        this.m_aVersion = vESVersion;
        this.m_sClassifier = StringHelper.hasText((String)string3) ? string3 : null;
    }

    @Nonnull
    @Nonempty
    public String getGroupID() {
        return this.m_sGroupID;
    }

    @Nonnull
    @Nonempty
    public String getArtifactID() {
        return this.m_sArtifactID;
    }

    @Nonnull
    @Nonempty
    public String getVersionString() {
        return this.m_aVersion.getAsString();
    }

    @Deprecated(forRemoval=true, since="9.0.0")
    public String getVersion() {
        return this.getVersionString();
    }

    @Nonnull
    public VESVersion getVersionObj() {
        return this.m_aVersion;
    }

    public boolean hasClassifier() {
        return StringHelper.hasText((String)this.m_sClassifier);
    }

    @Nullable
    public String getClassifier() {
        return this.m_sClassifier;
    }

    @Nonnull
    public VESID getWithVersion(@Nonnull VESVersion vESVersion) {
        if (EqualsHelper.equals((Object)this.m_aVersion, (Object)vESVersion)) {
            return this;
        }
        return new VESID(this.m_sGroupID, this.m_sArtifactID, vESVersion, this.m_sClassifier);
    }

    @Nonnull
    public VESID getWithVersionLatest() {
        return this.getWithVersion(VESVersion.of(EVESPseudoVersion.LATEST));
    }

    @Nonnull
    public VESID getWithClassifier(@Nullable String string) {
        if (EqualsHelper.equals((Object)this.m_sClassifier, (Object)string)) {
            return this;
        }
        return new VESID(this.m_sGroupID, this.m_sArtifactID, this.m_aVersion, string);
    }

    @Nonnull
    @Nonempty
    public String getAsSingleID() {
        String string = this.m_sGroupID + ":" + this.m_sArtifactID + ":" + this.getVersionString();
        if (this.hasClassifier()) {
            string = string + ":" + this.m_sClassifier;
        }
        return string;
    }

    @Override
    public int compareTo(VESID vESID) {
        int n = this.m_sGroupID.compareTo(vESID.m_sGroupID);
        if (n == 0 && (n = this.m_sArtifactID.compareTo(vESID.m_sArtifactID)) == 0 && (n = this.m_aVersion.compareTo(vESID.m_aVersion)) == 0) {
            n = CompareHelper.compare((Comparable)((Object)this.m_sClassifier), (Comparable)((Object)vESID.m_sClassifier));
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        VESID vESID = (VESID)object;
        return this.m_sGroupID.equals(vESID.m_sGroupID) && this.m_sArtifactID.equals(vESID.m_sArtifactID) && this.m_aVersion.equals(vESID.m_aVersion) && EqualsHelper.equals((Object)this.m_sClassifier, (Object)vESID.m_sClassifier);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator((Object)this).append((Object)this.m_sGroupID).append((Object)this.m_sArtifactID).append((Object)this.m_aVersion).append((Object)this.m_sClassifier).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator(null).append("GroupID", (Object)this.m_sGroupID).append("ArtifactID", (Object)this.m_sArtifactID).append("Version", (Object)this.m_aVersion).appendIf("Classifier", (Object)this.m_sClassifier, StringHelper::hasText).getToString();
    }

    @Nonnull
    public static VESID parseID(@Nullable String string) {
        ICommonsList iCommonsList = StringHelper.getExploded((char)':', (String)string);
        int n = iCommonsList.size();
        if (n >= 3 && n <= 4) {
            return new VESID((String)iCommonsList.get(0), (String)iCommonsList.get(1), (String)iCommonsList.get(2), n >= 4 ? (String)iCommonsList.get(3) : null);
        }
        throw new IllegalArgumentException("Invalid VESID '" + string + "' provided!");
    }

    @Nullable
    public static VESID parseIDOrNull(@Nullable String string) {
        try {
            return VESID.parseID(string);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }
}

