/*
 * Decompiled with CFR 0.152.
 */
package com.helger.diver.api.version;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementComparable;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.version.Version;
import com.helger.diver.api.version.EVESPseudoVersion;
import com.helger.diver.api.version.VESID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@MustImplementComparable
@MustImplementEqualsAndHashcode
public final class VESVersion
implements Comparable<VESVersion> {
    public static final String QUALIFIER_SNAPSHOT = "SNAPSHOT";
    private static final Logger LOGGER = LoggerFactory.getLogger(VESVersion.class);
    private final Version m_aStaticVersion;
    private final EVESPseudoVersion m_ePseudoVersion;

    private VESVersion(@Nullable Version version, @Nullable EVESPseudoVersion eVESPseudoVersion) {
        ValueEnforcer.isTrue((version != null || eVESPseudoVersion != null ? 1 : 0) != 0, (String)"Either Static Version or Pseudo Version must be provided");
        ValueEnforcer.isFalse((version != null && eVESPseudoVersion != null ? 1 : 0) != 0, (String)"Only one of Static Version or Pseudo Version must be provided");
        this.m_aStaticVersion = version;
        this.m_ePseudoVersion = eVESPseudoVersion;
    }

    public boolean isStaticVersion() {
        return this.m_aStaticVersion != null;
    }

    public boolean isStaticSnapshotVersion() {
        return this.m_aStaticVersion != null && QUALIFIER_SNAPSHOT.equals(this.m_aStaticVersion.getQualifier());
    }

    @Nullable
    public Version getStaticVersion() {
        return this.m_aStaticVersion;
    }

    public boolean isPseudoVersion() {
        return this.m_ePseudoVersion != null;
    }

    @Nullable
    public EVESPseudoVersion getPseudoVersion() {
        return this.m_ePseudoVersion;
    }

    @Nonnull
    private static String _getAsString(@Nonnull Version version, char c, boolean bl, boolean bl2) {
        Object object = "";
        char c2 = c;
        boolean bl3 = bl;
        if (version.hasQualifier()) {
            object = version.getQualifier();
        }
        if (version.getMicro() > 0 || bl3) {
            if (!((String)object).isEmpty()) {
                object = c2 + (String)object;
            }
            object = version.getMicro() + (String)object;
            c2 = '.';
            bl3 = true;
        }
        if (bl2) {
            bl3 = true;
        }
        if (version.getMinor() > 0 || bl3) {
            if (!((String)object).isEmpty()) {
                object = c2 + (String)object;
            }
            object = version.getMinor() + (String)object;
            c2 = '.';
            bl3 = true;
        }
        if (version.getMajor() > 0 || bl3 || ((String)object).isEmpty()) {
            if (!((String)object).isEmpty()) {
                object = c2 + (String)object;
            }
            object = version.getMajor() + (String)object;
        }
        return object;
    }

    @Nonnull
    public static String getAsString(@Nonnull Version version) {
        return VESVersion._getAsString(version, '-', false, false);
    }

    @Nonnull
    public static String getAsString(@Nonnull EVESPseudoVersion eVESPseudoVersion) {
        return eVESPseudoVersion.getID();
    }

    @Nonnull
    public String getAsString() {
        if (this.m_aStaticVersion != null) {
            return VESVersion.getAsString(this.m_aStaticVersion);
        }
        return VESVersion.getAsString(this.m_ePseudoVersion);
    }

    @Nonnull
    private static Version _getWithoutQualifier(@Nonnull Version version) {
        return new Version(version.getMajor(), version.getMinor(), version.getMicro(), null);
    }

    private static int _compareSemantically(@Nonnull Version version, @Nonnull Version version2) {
        if (QUALIFIER_SNAPSHOT.equals(version.getQualifier())) {
            if (QUALIFIER_SNAPSHOT.equals(version2.getQualifier())) {
                return version.compareTo(version2);
            }
            Version version3 = VESVersion._getWithoutQualifier(version);
            int n = version3.compareTo(version2);
            if (n == 0) {
                return -1;
            }
            return n;
        }
        if (QUALIFIER_SNAPSHOT.equals(version2.getQualifier())) {
            Version version4 = VESVersion._getWithoutQualifier(version2);
            int n = version.compareTo(version4);
            if (n == 0) {
                return 1;
            }
            return n;
        }
        return version.compareTo(version2);
    }

    private static int _compare(@Nonnull Version version, @Nonnull EVESPseudoVersion eVESPseudoVersion) {
        if (eVESPseudoVersion == EVESPseudoVersion.LATEST) {
            return -1;
        }
        return 1;
    }

    @Override
    public int compareTo(@Nonnull VESVersion vESVersion) {
        if (this.isStaticVersion()) {
            if (vESVersion.isStaticVersion()) {
                return VESVersion._compareSemantically(this.m_aStaticVersion, vESVersion.m_aStaticVersion);
            }
            return VESVersion._compare(this.m_aStaticVersion, vESVersion.m_ePseudoVersion);
        }
        if (vESVersion.isStaticVersion()) {
            return -VESVersion._compare(vESVersion.m_aStaticVersion, this.m_ePseudoVersion);
        }
        return this.m_ePseudoVersion.compareToSemantically(vESVersion.m_ePseudoVersion);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        VESVersion vESVersion = (VESVersion)object;
        return EqualsHelper.equals((Object)this.m_aStaticVersion, (Object)vESVersion.m_aStaticVersion) && EqualsHelper.equals((Object)((Object)this.m_ePseudoVersion), (Object)((Object)vESVersion.m_ePseudoVersion));
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aStaticVersion).append((Enum)this.m_ePseudoVersion).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).appendIfNotNull("StaticVersion", (Object)this.m_aStaticVersion).appendIfNotNull("PseudoVersion", (Object)this.m_ePseudoVersion).getToString();
    }

    @Nonnull
    public static VESVersion of(@Nonnull Version version) {
        ValueEnforcer.notNull((Object)version, (String)"Version");
        return new VESVersion(version, null);
    }

    @Nonnull
    public static VESVersion of(@Nonnull EVESPseudoVersion eVESPseudoVersion) {
        ValueEnforcer.notNull((Object)((Object)eVESPseudoVersion), (String)"PseudoVersion");
        return new VESVersion(null, eVESPseudoVersion);
    }

    public static boolean isValidStaticVersion(@Nullable String string2) {
        if (StringHelper.hasNoText((String)string2)) {
            return false;
        }
        if (!VESID.isValidPart(string2)) {
            return false;
        }
        Version version = Version.parse((String)string2);
        if (version == null) {
            return false;
        }
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        for (char c : "-.".toCharArray()) {
            for (boolean bl : new boolean[]{true, false}) {
                for (boolean bl2 : new boolean[]{true, false}) {
                    String string3 = VESVersion._getAsString(version, c, bl, bl2);
                    if (string2.equals(string3)) {
                        return true;
                    }
                    commonsLinkedHashSet.add((Object)string3);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("'" + string2 + "' is none of " + StringHelper.imploder().source((Iterable)commonsLinkedHashSet, string -> "'" + string + "'").separator(" or ").build());
        }
        return false;
    }

    @Nonnull
    public static VESVersion parseOrThrow(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalArgumentException("Version string must not be empty");
        }
        EVESPseudoVersion eVESPseudoVersion = EVESPseudoVersion.getFromIDOrNull(string);
        if (eVESPseudoVersion != null) {
            return VESVersion.of(eVESPseudoVersion);
        }
        if (VESVersion.isValidStaticVersion(string)) {
            return VESVersion.of(Version.parse((String)string));
        }
        throw new IllegalArgumentException("Failed to parse '" + string + "' to a VES Version");
    }

    @Nullable
    public static VESVersion parseOrNull(@Nullable String string) {
        try {
            return VESVersion.parseOrThrow(string);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.warn(runtimeException.getMessage());
            return null;
        }
    }
}

