/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.traits;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.datetime.PDTFromString;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.typeconvert.TypeConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface IGetterByIndexTrait {
    @Nullable
    public Object getValue(@Nonnegative int var1);

    @Nullable
    default public Class<?> getValueClass(@Nonnegative int n) {
        Object object = this.getValue(n);
        return object == null ? null : object.getClass();
    }

    default public boolean hasValue(@Nonnegative int n) {
        return this.getValue(n) != null;
    }

    default public boolean hasNoValue(@Nonnegative int n) {
        return this.getValue(n) == null;
    }

    @Nullable
    default public <T> T getCastedValue(@Nonnegative int n) {
        return (T)GenericReflection.uncheckedCast(this.getValue(n));
    }

    @Nullable
    default public <T> T getCastedValue(@Nonnegative int n, @Nullable T t) {
        Object object = this.getValue(n);
        return (T)(object == null ? t : GenericReflection.uncheckedCast(object));
    }

    @Nullable
    default public <T> T getCastedValue(@Nonnegative int n, @Nonnull Class<T> clazz) {
        return clazz.cast(this.getValue(n));
    }

    @Nullable
    default public <T> T getCastedValue(@Nonnegative int n, @Nullable T t, @Nonnull Class<T> clazz) {
        Object object = this.getValue(n);
        return object == null ? t : clazz.cast(object);
    }

    @Nullable
    default public <T> T getSafeCastedValue(@Nonnegative int n, @Nonnull Class<T> clazz) {
        return this.getSafeCastedValue(n, null, clazz);
    }

    default public void onSafeCastError(@Nonnegative int n, @Nonnull Class<?> clazz, @Nonnull Object object) {
    }

    @Nullable
    default public <T> T getSafeCastedValue(@Nonnegative int n, @Nullable T t, @Nonnull Class<T> clazz) {
        T t2;
        Object object = this.getValue(n);
        T t3 = t2 = object != null && clazz.isAssignableFrom(object.getClass()) ? clazz.cast(object) : t;
        if (t2 == null && object != null) {
            this.onSafeCastError(n, clazz, object);
        }
        return t2;
    }

    @Nullable
    default public <T> T getConvertedValue(@Nonnegative int n, @Nonnull Class<T> clazz) {
        return TypeConverter.convert(this.getValue(n), clazz);
    }

    @Nullable
    default public <T> T getConvertedValue(@Nonnegative int n, @Nullable T t, @Nonnull Class<T> clazz) {
        Object object = this.getValue(n);
        return object == null ? t : TypeConverter.convert(object, clazz);
    }

    default public boolean getAsBoolean(@Nonnegative int n) {
        return TypeConverter.convertToBoolean(this.getValue(n));
    }

    default public boolean getAsBoolean(@Nonnegative int n, boolean bl) {
        return TypeConverter.convertToBoolean(this.getValue(n), bl);
    }

    default public byte getAsByte(@Nonnegative int n) {
        return TypeConverter.convertToByte(this.getValue(n));
    }

    default public byte getAsByte(@Nonnegative int n, byte by) {
        return TypeConverter.convertToByte(this.getValue(n), by);
    }

    default public char getAsChar(@Nonnegative int n) {
        return TypeConverter.convertToChar(this.getValue(n));
    }

    default public char getAsChar(@Nonnegative int n, char c) {
        return TypeConverter.convertToChar(this.getValue(n), c);
    }

    default public double getAsDouble(@Nonnegative int n) {
        return TypeConverter.convertToDouble(this.getValue(n));
    }

    default public double getAsDouble(@Nonnegative int n, double d) {
        return TypeConverter.convertToDouble(this.getValue(n), d);
    }

    default public float getAsFloat(@Nonnegative int n) {
        return TypeConverter.convertToFloat(this.getValue(n));
    }

    default public float getAsFloat(@Nonnegative int n, float f) {
        return TypeConverter.convertToFloat(this.getValue(n), f);
    }

    default public int getAsInt(@Nonnegative int n) {
        return TypeConverter.convertToInt(this.getValue(n));
    }

    default public int getAsInt(@Nonnegative int n, int n2) {
        return TypeConverter.convertToInt(this.getValue(n), n2);
    }

    default public long getAsLong(@Nonnegative int n) {
        return TypeConverter.convertToLong(this.getValue(n));
    }

    default public long getAsLong(@Nonnegative int n, long l) {
        return TypeConverter.convertToLong(this.getValue(n), l);
    }

    default public short getAsShort(@Nonnegative int n) {
        return TypeConverter.convertToShort(this.getValue(n));
    }

    default public short getAsShort(@Nonnegative int n, short s) {
        return TypeConverter.convertToShort(this.getValue(n), s);
    }

    @Nullable
    default public String getAsString(@Nonnegative int n) {
        return this.getConvertedValue(n, String.class);
    }

    @Nullable
    default public String getAsString(@Nonnegative int n, @Nullable String string) {
        return this.getConvertedValue(n, string, String.class);
    }

    @Nullable
    default public char[] getAsCharArray(@Nonnegative int n) {
        return this.getConvertedValue(n, char[].class);
    }

    @Nullable
    default public char[] getAsCharArray(@Nonnegative int n, @Nullable char[] cArray) {
        return this.getConvertedValue(n, cArray, char[].class);
    }

    @Nullable
    default public BigDecimal getAsBigDecimal(@Nonnegative int n) {
        return this.getConvertedValue(n, BigDecimal.class);
    }

    @Nullable
    default public BigDecimal getAsBigDecimal(@Nonnegative int n, @Nullable BigDecimal bigDecimal) {
        return this.getConvertedValue(n, bigDecimal, BigDecimal.class);
    }

    @Nullable
    default public BigInteger getAsBigInteger(@Nonnegative int n) {
        return this.getConvertedValue(n, BigInteger.class);
    }

    @Nullable
    default public BigInteger getAsBigInteger(@Nonnegative int n, @Nullable BigInteger bigInteger) {
        return this.getConvertedValue(n, bigInteger, BigInteger.class);
    }

    @Nullable
    default public LocalDate getAsLocalDate(@Nonnegative int n) {
        return this.getConvertedValue(n, LocalDate.class);
    }

    @Nullable
    default public LocalDate getAsLocalDate(@Nonnegative int n, @Nullable LocalDate localDate) {
        return this.getConvertedValue(n, localDate, LocalDate.class);
    }

    @Nullable
    default public LocalTime getAsLocalTime(@Nonnegative int n) {
        return this.getConvertedValue(n, LocalTime.class);
    }

    @Nullable
    default public LocalTime getAsLocalTime(@Nonnegative int n, @Nullable LocalTime localTime) {
        return this.getConvertedValue(n, localTime, LocalTime.class);
    }

    @Nullable
    default public LocalDateTime getAsLocalDateTime(@Nonnegative int n) {
        return this.getConvertedValue(n, LocalDateTime.class);
    }

    @Nullable
    default public LocalDateTime getAsLocalDateTime(@Nonnegative int n, @Nullable LocalDateTime localDateTime) {
        return this.getConvertedValue(n, localDateTime, LocalDateTime.class);
    }

    @Nullable
    default public byte[] getAsByteArray(@Nonnegative int n) {
        return this.getConvertedValue(n, byte[].class);
    }

    @Nullable
    default public Boolean getAsBooleanObj(@Nonnegative int n) {
        return this.getConvertedValue(n, Boolean.class);
    }

    @Nullable
    default public Byte getAsByteObj(@Nonnegative int n) {
        return this.getConvertedValue(n, Byte.class);
    }

    @Nullable
    default public Character getAsCharObj(@Nonnegative int n) {
        return this.getConvertedValue(n, Character.class);
    }

    @Nullable
    default public Double getAsDoubleObj(@Nonnegative int n) {
        return this.getConvertedValue(n, Double.class);
    }

    @Nullable
    default public Float getAsFloatObj(@Nonnegative int n) {
        return this.getConvertedValue(n, Float.class);
    }

    @Nullable
    default public Integer getAsIntObj(@Nonnegative int n) {
        return this.getConvertedValue(n, Integer.class);
    }

    @Nullable
    default public Long getAsLongObj(@Nonnegative int n) {
        return this.getConvertedValue(n, Long.class);
    }

    @Nullable
    default public Short getAsShortObj(@Nonnegative int n) {
        return this.getConvertedValue(n, Short.class);
    }

    @Nullable
    default public Blob getAsSqlBlob(@Nonnegative int n) {
        return this.getConvertedValue(n, Blob.class);
    }

    @Nullable
    default public Clob getAsSqlClob(@Nonnegative int n) {
        return this.getConvertedValue(n, Clob.class);
    }

    @Nullable
    default public Date getAsSqlDate(@Nonnegative int n) {
        return this.getConvertedValue(n, Date.class);
    }

    @Nullable
    default public NClob getAsSqlNClob(@Nonnegative int n) {
        return this.getConvertedValue(n, NClob.class);
    }

    @Nullable
    default public RowId getAsSqlRowId(@Nonnegative int n) {
        return this.getConvertedValue(n, RowId.class);
    }

    @Nullable
    default public Time getAsSqlTime(@Nonnegative int n) {
        return this.getConvertedValue(n, Time.class);
    }

    @Nullable
    default public Timestamp getAsSqlTimestamp(@Nonnegative int n) {
        return this.getConvertedValue(n, Timestamp.class);
    }

    @Nullable
    default public LocalDate getAsLocalDate(@Nonnegative int n, @Nonnull Locale locale) {
        String string = this.getAsString(n);
        return PDTFromString.getLocalDateFromString(string, locale);
    }

    @Nullable
    default public LocalTime getAsLocalTime(@Nonnegative int n, @Nonnull Locale locale) {
        String string = this.getAsString(n);
        return PDTFromString.getLocalTimeFromString(string, locale);
    }

    @Nullable
    default public LocalDateTime getAsLocalDateTime(@Nonnegative int n, @Nonnull Locale locale) {
        String string = this.getAsString(n);
        return PDTFromString.getLocalDateTimeFromString(string, locale);
    }

    @Nullable
    default public ICommonsList<String> getAsStringList(@Nonnegative int n) {
        return this.getAsStringList(n, null);
    }

    @Nullable
    default public ICommonsList<String> getAsStringList(@Nonnegative int n, @Nullable ICommonsList<String> iCommonsList) {
        Object object = this.getValue(n);
        if (object != null) {
            if (object instanceof String[]) {
                return new CommonsArrayList<String>((String[])object);
            }
            if (object instanceof String) {
                return new CommonsArrayList<String>((String)object);
            }
        }
        return iCommonsList;
    }

    @Nullable
    default public ICommonsOrderedSet<String> getAsStringSet(@Nonnegative int n) {
        return this.getAsStringSet(n, null);
    }

    @Nullable
    default public ICommonsOrderedSet<String> getAsStringSet(@Nonnegative int n, @Nullable ICommonsOrderedSet<String> iCommonsOrderedSet) {
        Object object = this.getValue(n);
        if (object != null) {
            if (object instanceof String[]) {
                return new CommonsLinkedHashSet<String>((String[])object);
            }
            if (object instanceof String) {
                return new CommonsLinkedHashSet<String>((String)object);
            }
        }
        return iCommonsOrderedSet;
    }

    default public boolean hasStringValue(@Nonnegative int n, @Nullable String string) {
        return this.hasStringValue(n, string, false);
    }

    default public boolean hasStringValue(@Nonnegative int n, @Nullable String string, boolean bl) {
        String string2 = this.getAsString(n);
        return string2 == null ? bl : string2.equals(string);
    }
}

