/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday.mgr;

import com.helger.holiday.EHolidayType;
import com.helger.holiday.IHolidayType;
import com.helger.holiday.jaxb.Fixed;
import com.helger.holiday.jaxb.HolidayType;
import com.helger.holiday.jaxb.Weekday;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class XMLHolidayHelper {
    private XMLHolidayHelper() {
    }

    @Nonnegative
    public static DayOfWeek getWeekday(@Nonnull Weekday weekday) {
        switch (weekday) {
            case MONDAY: {
                return DayOfWeek.MONDAY;
            }
            case TUESDAY: {
                return DayOfWeek.TUESDAY;
            }
            case WEDNESDAY: {
                return DayOfWeek.WEDNESDAY;
            }
            case THURSDAY: {
                return DayOfWeek.THURSDAY;
            }
            case FRIDAY: {
                return DayOfWeek.FRIDAY;
            }
            case SATURDAY: {
                return DayOfWeek.SATURDAY;
            }
            case SUNDAY: {
                return DayOfWeek.SUNDAY;
            }
        }
        throw new IllegalArgumentException("Unknown weekday " + (Object)((Object)weekday));
    }

    @Nonnegative
    public static Month getMonth(@Nonnull com.helger.holiday.jaxb.Month month) {
        switch (month) {
            case JANUARY: {
                return Month.JANUARY;
            }
            case FEBRUARY: {
                return Month.FEBRUARY;
            }
            case MARCH: {
                return Month.MARCH;
            }
            case APRIL: {
                return Month.APRIL;
            }
            case MAY: {
                return Month.MAY;
            }
            case JUNE: {
                return Month.JUNE;
            }
            case JULY: {
                return Month.JULY;
            }
            case AUGUST: {
                return Month.AUGUST;
            }
            case SEPTEMBER: {
                return Month.SEPTEMBER;
            }
            case OCTOBER: {
                return Month.OCTOBER;
            }
            case NOVEMBER: {
                return Month.NOVEMBER;
            }
            case DECEMBER: {
                return Month.DECEMBER;
            }
        }
        throw new IllegalArgumentException("Unknown month " + (Object)((Object)month));
    }

    @Nonnull
    public static IHolidayType getType(@Nonnull HolidayType holidayType) {
        switch (holidayType) {
            case OFFICIAL_HOLIDAY: {
                return EHolidayType.OFFICIAL_HOLIDAY;
            }
            case UNOFFICIAL_HOLIDAY: {
                return EHolidayType.UNOFFICIAL_HOLIDAY;
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)holidayType));
    }

    @Nonnull
    public static LocalDate create(@Nonnegative int n, @Nonnull Fixed fixed) {
        return LocalDate.of(n, XMLHolidayHelper.getMonth(fixed.getMonth()), (int)fixed.getDay());
    }
}

