/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.holiday.EHolidayType;
import com.helger.holiday.IHolidayType;
import com.helger.holiday.ISingleHoliday;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FixedNameHoliday
implements ISingleHoliday {
    private final boolean m_bIsOfficial;
    private final String m_sHolidayName;

    public FixedNameHoliday(@Nonnull String string) {
        this(EHolidayType.OFFICIAL_HOLIDAY, string);
    }

    public FixedNameHoliday(@Nonnull IHolidayType iHolidayType, @Nonnull String string) {
        ValueEnforcer.notNull((Object)iHolidayType, (String)"Type");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"HolidayName");
        this.m_bIsOfficial = iHolidayType.isOfficialHoliday();
        this.m_sHolidayName = string;
    }

    @Override
    public boolean isOfficialHoliday() {
        return this.m_bIsOfficial;
    }

    @Override
    public String getHolidayName(Locale locale) {
        return this.m_sHolidayName;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FixedNameHoliday fixedNameHoliday = (FixedNameHoliday)object;
        return this.m_bIsOfficial == fixedNameHoliday.m_bIsOfficial && this.m_sHolidayName.equals(fixedNameHoliday.m_sHolidayName);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_bIsOfficial).append((Object)this.m_sHolidayName).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("official", this.m_bIsOfficial).append("holidayName", (Object)this.m_sHolidayName).getToString();
    }
}

