/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday.parser;

import com.helger.holiday.jaxb.Holiday;
import com.helger.holiday.jaxb.MoveableHoliday;
import com.helger.holiday.jaxb.MovingCondition;
import com.helger.holiday.jaxb.With;
import com.helger.holiday.mgr.XMLHolidayHelper;
import com.helger.holiday.parser.IHolidayParser;
import java.time.DayOfWeek;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class AbstractHolidayParser
implements IHolidayParser {
    protected AbstractHolidayParser() {
    }

    protected static final boolean isValid(Holiday holiday, int n) {
        return AbstractHolidayParser._isValidInYear(holiday, n) && AbstractHolidayParser._isValidForCycle(holiday, n);
    }

    private static boolean _isValidForCycle(@Nonnull Holiday holiday, int n) {
        String string = holiday.getEvery();
        if (string != null && !"EVERY_YEAR".equals(string)) {
            if ("ODD_YEARS".equals(string)) {
                return n % 2 != 0;
            }
            if ("EVEN_YEARS".equals(string)) {
                return n % 2 == 0;
            }
            if (holiday.getValidFrom() != null) {
                int n2 = 0;
                if ("2_YEARS".equalsIgnoreCase(string)) {
                    n2 = 2;
                } else if ("3_YEARS".equalsIgnoreCase(string)) {
                    n2 = 3;
                } else if ("4_YEARS".equalsIgnoreCase(string)) {
                    n2 = 4;
                } else if ("5_YEARS".equalsIgnoreCase(string)) {
                    n2 = 5;
                } else if ("6_YEARS".equalsIgnoreCase(string)) {
                    n2 = 6;
                } else {
                    throw new IllegalArgumentException("Cannot handle unknown cycle type '" + string + "'.");
                }
                return (n - holiday.getValidFrom()) % n2 == 0;
            }
        }
        return true;
    }

    private static boolean _isValidInYear(@Nonnull Holiday holiday, int n) {
        return !(holiday.getValidFrom() != null && holiday.getValidFrom() > n || holiday.getValidTo() != null && holiday.getValidTo() < n);
    }

    protected static final boolean shallBeMoved(@Nonnull LocalDate localDate, @Nonnull MovingCondition movingCondition) {
        return localDate.getDayOfWeek() == XMLHolidayHelper.getWeekday(movingCondition.getSubstitute());
    }

    private static LocalDate _moveDate(MovingCondition movingCondition, LocalDate localDate) {
        DayOfWeek dayOfWeek = XMLHolidayHelper.getWeekday(movingCondition.getWeekday());
        int n = movingCondition.getWith() == With.NEXT ? 1 : -1;
        LocalDate localDate2 = localDate;
        while (localDate2.getDayOfWeek() != dayOfWeek) {
            localDate2 = localDate2.plusDays(n);
        }
        return localDate2;
    }

    protected static final LocalDate moveDate(MoveableHoliday moveableHoliday, LocalDate localDate) {
        for (MovingCondition movingCondition : moveableHoliday.getMovingCondition()) {
            if (!AbstractHolidayParser.shallBeMoved(localDate, movingCondition)) continue;
            return AbstractHolidayParser._moveDate(movingCondition, localDate);
        }
        return localDate;
    }
}

