/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday.parser;

import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.holiday.CalendarHelper;
import com.helger.holiday.HolidayMap;
import com.helger.holiday.IHolidayType;
import com.helger.holiday.ResourceBundleHoliday;
import com.helger.holiday.jaxb.Holidays;
import com.helger.holiday.jaxb.IslamicHoliday;
import com.helger.holiday.mgr.XMLHolidayHelper;
import com.helger.holiday.parser.AbstractHolidayParser;
import java.time.LocalDate;

public final class IslamicHolidayParser
extends AbstractHolidayParser {
    private static final IslamicHolidayParser s_aInstance = new IslamicHolidayParser();

    private IslamicHolidayParser() {
    }

    public static IslamicHolidayParser getInstance() {
        return s_aInstance;
    }

    @Override
    public void parse(int n, HolidayMap holidayMap, Holidays holidays) {
        for (IslamicHoliday islamicHoliday : holidays.getIslamicHoliday()) {
            ICommonsSet<LocalDate> iCommonsSet;
            if (!IslamicHolidayParser.isValid(islamicHoliday, n)) continue;
            switch (islamicHoliday.getType()) {
                case NEWYEAR: {
                    iCommonsSet = CalendarHelper.getIslamicHolidaysInGregorianYear(n, 1, 1);
                    break;
                }
                case ASCHURA: {
                    iCommonsSet = CalendarHelper.getIslamicHolidaysInGregorianYear(n, 1, 10);
                    break;
                }
                case ID_AL_FITR: {
                    iCommonsSet = CalendarHelper.getIslamicHolidaysInGregorianYear(n, 10, 1);
                    break;
                }
                case ID_UL_ADHA: {
                    iCommonsSet = CalendarHelper.getIslamicHolidaysInGregorianYear(n, 12, 10);
                    break;
                }
                case LAILAT_AL_BARAT: {
                    iCommonsSet = CalendarHelper.getIslamicHolidaysInGregorianYear(n, 8, 15);
                    break;
                }
                case LAILAT_AL_MIRAJ: {
                    iCommonsSet = CalendarHelper.getIslamicHolidaysInGregorianYear(n, 7, 27);
                    break;
                }
                case LAILAT_AL_QADR: {
                    iCommonsSet = CalendarHelper.getIslamicHolidaysInGregorianYear(n, 9, 27);
                    break;
                }
                case MAWLID_AN_NABI: {
                    iCommonsSet = CalendarHelper.getIslamicHolidaysInGregorianYear(n, 3, 12);
                    break;
                }
                case RAMADAN: {
                    iCommonsSet = CalendarHelper.getIslamicHolidaysInGregorianYear(n, 9, 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown islamic holiday " + (Object)((Object)islamicHoliday.getType()));
                }
            }
            IHolidayType iHolidayType = XMLHolidayHelper.getType(islamicHoliday.getLocalizedType());
            String string = "islamic." + islamicHoliday.getType().name();
            for (LocalDate localDate : iCommonsSet) {
                holidayMap.add(localDate, new ResourceBundleHoliday(iHolidayType, string));
            }
        }
    }
}

