/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday.parser;

import com.helger.holiday.HolidayMap;
import com.helger.holiday.IHolidayType;
import com.helger.holiday.ResourceBundleHoliday;
import com.helger.holiday.jaxb.ChronologyType;
import com.helger.holiday.jaxb.Holidays;
import com.helger.holiday.jaxb.RelativeToEasterSunday;
import com.helger.holiday.mgr.XMLHolidayHelper;
import com.helger.holiday.parser.AbstractHolidayParser;
import java.time.LocalDate;
import java.time.Month;
import java.time.chrono.ChronoLocalDate;
import java.time.temporal.ChronoUnit;
import org.threeten.extra.chrono.JulianDate;

public class RelativeToEasterSundayParser
extends AbstractHolidayParser {
    @Override
    public void parse(int n, HolidayMap holidayMap, Holidays holidays) {
        for (RelativeToEasterSunday relativeToEasterSunday : holidays.getRelativeToEasterSunday()) {
            if (!RelativeToEasterSundayParser.isValid(relativeToEasterSunday, n)) continue;
            ChronoLocalDate chronoLocalDate = RelativeToEasterSundayParser.getEasterSunday(n, relativeToEasterSunday.getChronology());
            chronoLocalDate.plus(relativeToEasterSunday.getDays(), ChronoUnit.DAYS);
            String string = "christian." + relativeToEasterSunday.getDescriptionPropertiesKey();
            this.addChrstianHoliday(chronoLocalDate, string, XMLHolidayHelper.getType(relativeToEasterSunday.getLocalizedType()), holidayMap);
        }
    }

    protected final void addChrstianHoliday(ChronoLocalDate chronoLocalDate, String string, IHolidayType iHolidayType, HolidayMap holidayMap) {
        LocalDate localDate = LocalDate.from(chronoLocalDate);
        holidayMap.add(localDate, new ResourceBundleHoliday(iHolidayType, string));
    }

    public static ChronoLocalDate getEasterSunday(int n) {
        return n <= 1583 ? RelativeToEasterSundayParser.getJulianEasterSunday(n) : RelativeToEasterSundayParser.getGregorianEasterSunday(n);
    }

    public static ChronoLocalDate getEasterSunday(int n, ChronologyType chronologyType) {
        return chronologyType == ChronologyType.JULIAN ? RelativeToEasterSundayParser.getJulianEasterSunday(n) : RelativeToEasterSundayParser.getGregorianEasterSunday(n);
    }

    public static JulianDate getJulianEasterSunday(int n) {
        int n2 = n % 4;
        int n3 = n % 7;
        int n4 = n % 19;
        int n5 = (19 * n4 + 15) % 30;
        int n6 = (2 * n2 + 4 * n3 - n5 + 34) % 7;
        int n7 = n5 + n6 + 114;
        int n8 = n7 / 31;
        int n9 = n7 % 31 + 1;
        return JulianDate.of((int)n, (int)(n8 == 3 ? Month.MARCH : Month.APRIL).getValue(), (int)n9);
    }

    public static LocalDate getGregorianEasterSunday(int n) {
        int n2 = n % 19;
        int n3 = n / 100;
        int n4 = n % 100;
        int n5 = n3 / 4;
        int n6 = n3 % 4;
        int n7 = (n3 + 8) / 25;
        int n8 = (n3 - n7 + 1) / 3;
        int n9 = (19 * n2 + n3 - n5 - n8 + 15) % 30;
        int n10 = n4 / 4;
        int n11 = n4 % 4;
        int n12 = (32 + 2 * n6 + 2 * n10 - n9 - n11) % 7;
        int n13 = (n2 + 11 * n9 + 22 * n12) / 451;
        int n14 = n9 + n12 - 7 * n13 + 114;
        int n15 = n14 / 31;
        int n16 = n14 % 31 + 1;
        return LocalDate.of(n, n15 == 3 ? Month.MARCH : Month.APRIL, n16);
    }
}

