/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.resourcebundle.ResourceBundleKey;
import com.helger.holiday.IHolidayType;
import com.helger.holiday.ISingleHoliday;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ResourceBundleHoliday
implements ISingleHoliday {
    private final boolean m_bIsOfficial;
    private final ResourceBundleKey m_aRBKey;
    private transient int m_nHashCode = 0;

    public ResourceBundleHoliday(@Nonnull IHolidayType iHolidayType, @Nullable String string) {
        ValueEnforcer.notNull((Object)iHolidayType, (String)"Type");
        this.m_bIsOfficial = iHolidayType.isOfficialHoliday();
        this.m_aRBKey = StringHelper.hasNoText((String)string) ? null : new ResourceBundleKey("descriptions.holiday_descriptions", "holiday.description." + string);
    }

    @Override
    public boolean isOfficialHoliday() {
        return this.m_bIsOfficial;
    }

    @Override
    public String getHolidayName(Locale locale) {
        String string = null;
        if (this.m_aRBKey != null) {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(this.m_aRBKey.getBundleName(), locale, ClassLoaderHelper.getDefaultClassLoader());
                string = resourceBundle.getString(this.m_aRBKey.getKey());
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string == null ? "undefined" : string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ResourceBundleHoliday resourceBundleHoliday = (ResourceBundleHoliday)object;
        return this.m_bIsOfficial == resourceBundleHoliday.m_bIsOfficial && EqualsHelper.equals((Object)this.m_aRBKey, (Object)resourceBundleHoliday.m_aRBKey);
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator((Object)this).append(this.m_bIsOfficial).append((Object)this.m_aRBKey).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("official", this.m_bIsOfficial).append("propsKey", (Object)this.m_aRBKey).getToString();
    }
}

