/*
 * Decompiled with CFR 0.152.
 */
package com.helger.holiday.mgr;

import com.helger.commons.locale.country.ECountry;
import com.helger.holiday.EHolidayType;
import com.helger.holiday.HolidayMap;
import com.helger.holiday.ResourceBundleHoliday;
import com.helger.holiday.mgr.XMLHolidayManager;
import java.time.LocalDate;
import java.util.Map;

public final class XMLHolidayManagerJapan
extends XMLHolidayManager {
    public static final String COUNTRY_ID = ECountry.JP.getID();
    private static final String BRIDGING_HOLIDAY_PROPERTIES_KEY = "BRIDGING_HOLIDAY";

    public XMLHolidayManagerJapan() {
        super(COUNTRY_ID);
    }

    @Override
    public HolidayMap getHolidays(int n, String ... stringArray) {
        HolidayMap holidayMap = super.getHolidays(n, stringArray);
        HolidayMap holidayMap2 = new HolidayMap();
        for (Map.Entry entry : holidayMap.getMap().entrySet()) {
            LocalDate localDate = ((LocalDate)entry.getKey()).plusDays(2L);
            if (!holidayMap.containsHolidayForDate(localDate)) continue;
            LocalDate localDate2 = localDate.minusDays(1L);
            holidayMap2.add(localDate2, new ResourceBundleHoliday(EHolidayType.OFFICIAL_HOLIDAY, BRIDGING_HOLIDAY_PROPERTIES_KEY));
        }
        holidayMap.addAll(holidayMap2);
        return holidayMap;
    }
}

