/*
 * Decompiled with CFR 0.152.
 */
package com.helger.jaxb;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.cache.Cache;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.functional.IFunction;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.state.EChange;
import com.helger.jaxb.JAXBContextCacheKey;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class JAXBContextCache
extends Cache<JAXBContextCacheKey, JAXBContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JAXBContextCache.class);
    private static boolean s_bDefaultInstantiated = false;

    private JAXBContextCache() {
        super((IFunction & Serializable)jAXBContextCacheKey -> {
            ValueEnforcer.notNull((Object)jAXBContextCacheKey, (String)"CacheKey");
            Package package_ = jAXBContextCacheKey.getPackage();
            ClassLoader classLoader = jAXBContextCacheKey.getClassLoader();
            if (GlobalDebug.isDebugMode()) {
                LOGGER.info("Creating JAXB context for package " + package_.getName() + " using ClassLoader " + classLoader.toString());
            }
            try {
                if (package_.getAnnotation(XmlSchema.class) == null && GenericReflection.getClassFromNameSafe((String)(package_.getName() + ".ObjectFactory")) == null) {
                    LOGGER.warn("The package " + package_.getName() + " does not seem to be JAXB generated! Trying to create a JAXBContext anyway.");
                }
                return JAXBContext.newInstance((String)package_.getName(), (ClassLoader)classLoader);
            }
            catch (JAXBException jAXBException) {
                String string = "Failed to create JAXB context for package '" + package_.getName() + "' using ClassLoader " + classLoader;
                LOGGER.error(string + ": " + jAXBException.getMessage());
                throw new IllegalArgumentException(string, jAXBException);
            }
        }, 500, JAXBContextCache.class.getName());
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static JAXBContextCache getInstance() {
        JAXBContextCache jAXBContextCache = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return jAXBContextCache;
    }

    @Nullable
    public JAXBContext getFromCache(@Nonnull Package package_) {
        return this.getFromCache(package_, (ClassLoader)null);
    }

    @Nullable
    public JAXBContext getFromCache(@Nonnull Package package_, @Nullable ClassLoader classLoader) {
        return (JAXBContext)this.getFromCache(new JAXBContextCacheKey(package_, classLoader));
    }

    @Nullable
    public JAXBContext getFromCache(@Nonnull Class<?> clazz) {
        return this.getFromCache(clazz, (ClassLoader)null);
    }

    @Nullable
    public JAXBContext getFromCache(@Nonnull Class<?> clazz, @Nullable ClassLoader classLoader) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        Package package_ = clazz.getPackage();
        if (package_.getAnnotation(XmlSchema.class) != null) {
            return this.getFromCache(package_, classLoader);
        }
        if (GlobalDebug.isDebugMode()) {
            LOGGER.info("Creating JAXB context for class " + clazz.getName());
        }
        if (classLoader != null) {
            LOGGER.warn("Package " + package_.getName() + " does not seem to be JAXB generated. Therefore a new JAXBContext is created and the provided ClassLoader is ignored!");
        }
        try {
            return JAXBContext.newInstance((Class[])new Class[]{clazz});
        }
        catch (JAXBException jAXBException) {
            String string = "Failed to create JAXB context for class '" + clazz.getName() + "'";
            LOGGER.error(string + ": " + jAXBException.getMessage());
            throw new IllegalArgumentException(string, jAXBException);
        }
    }

    @Nonnull
    public EChange removeFromCache(@Nonnull Package package_) {
        return this.removeFromCache(new JAXBContextCacheKey(package_, null));
    }

    private static final class SingletonHolder {
        static final JAXBContextCache s_aInstance = new JAXBContextCache();

        private SingletonHolder() {
        }
    }
}

