/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.ajax;

import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.callback.ICallback;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.photon.ajax.callback.IAjaxAfterExecutionCallback;
import com.helger.photon.ajax.callback.IAjaxBeforeExecutionCallback;
import com.helger.photon.ajax.callback.IAjaxExceptionCallback;
import com.helger.photon.ajax.callback.IAjaxLongRunningExecutionCallback;
import com.helger.photon.ajax.callback.LoggingAjaxExceptionCallback;
import com.helger.photon.ajax.callback.LoggingAjaxLongRunningExecutionCallback;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class AjaxSettings {
    public static final long DEFAULT_LONG_RUNNING_EXECUTION_LIMIT_MS = 1000L;
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    private static final CallbackList<IAjaxExceptionCallback> s_aExceptionCallbacks = new CallbackList();
    private static final CallbackList<IAjaxBeforeExecutionCallback> s_aBeforeExecutionCallbacks = new CallbackList();
    private static final CallbackList<IAjaxAfterExecutionCallback> s_aAfterExecutionCallbacks = new CallbackList();
    @GuardedBy(value="RW_LOCK")
    private static long s_nLongRunningExecutionLimitTime = 1000L;
    private static final CallbackList<IAjaxLongRunningExecutionCallback> s_aLongRunningExecutionCallbacks = new CallbackList();

    private AjaxSettings() {
    }

    @Nonnull
    @ReturnsMutableObject(value="design")
    public static CallbackList<IAjaxExceptionCallback> exceptionCallbacks() {
        return s_aExceptionCallbacks;
    }

    @Nonnull
    @ReturnsMutableObject
    public static CallbackList<IAjaxBeforeExecutionCallback> beforeExecutionCallbacks() {
        return s_aBeforeExecutionCallbacks;
    }

    @Nonnull
    @ReturnsMutableObject
    public static CallbackList<IAjaxAfterExecutionCallback> afterExecutionCallbacks() {
        return s_aAfterExecutionCallbacks;
    }

    @CheckForSigned
    public static long getLongRunningExecutionLimitTime() {
        return RW_LOCK.readLockedLong(() -> s_nLongRunningExecutionLimitTime);
    }

    public static void setLongRunningExecutionLimitTime(long l) {
        RW_LOCK.writeLocked(() -> {
            s_nLongRunningExecutionLimitTime = l;
        });
    }

    @Nonnull
    @ReturnsMutableObject
    public static CallbackList<IAjaxLongRunningExecutionCallback> longRunningExecutionCallbacks() {
        return s_aLongRunningExecutionCallbacks;
    }

    static {
        AjaxSettings.exceptionCallbacks().add((ICallback)new LoggingAjaxExceptionCallback());
        AjaxSettings.longRunningExecutionCallbacks().add((ICallback)new LoggingAjaxLongRunningExecutionCallback());
    }
}

