/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.ajax;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.ajax.AjaxInvoker;
import com.helger.photon.ajax.AjaxRegistry;
import com.helger.photon.ajax.IAjaxInvoker;
import com.helger.photon.ajax.IAjaxRegistry;
import com.helger.web.scope.singleton.AbstractGlobalWebSingleton;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class GlobalAjaxInvoker
extends AbstractGlobalWebSingleton {
    @GuardedBy(value="m_aRWLock")
    private IAjaxRegistry m_aRegistry = new AjaxRegistry();
    @GuardedBy(value="m_aRWLock")
    private IAjaxInvoker m_aInvoker = new AjaxInvoker();

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public GlobalAjaxInvoker() {
    }

    @Nonnull
    public static GlobalAjaxInvoker getInstance() {
        return (GlobalAjaxInvoker)GlobalAjaxInvoker.getGlobalSingleton(GlobalAjaxInvoker.class);
    }

    public void resetToDefault() {
        this.m_aRegistry = new AjaxRegistry();
        this.m_aInvoker = new AjaxInvoker();
    }

    @Nonnull
    public IAjaxRegistry getRegistry() {
        return (IAjaxRegistry)this.m_aRWLock.readLockedGet(() -> this.m_aRegistry);
    }

    @Nonnull
    public void setRegistry(@Nonnull IAjaxRegistry iAjaxRegistry) {
        ValueEnforcer.notNull((Object)iAjaxRegistry, (String)"Registry");
        if (this.m_aRWLock.readLockedBoolean(() -> this.m_aRegistry.getAllRegisteredFunctions().isNotEmpty())) {
            throw new IllegalStateException("Cannot change the registry after a function was already registered!");
        }
        this.m_aRWLock.writeLocked(() -> {
            this.m_aRegistry = iAjaxRegistry;
        });
    }

    @Nonnull
    public IAjaxInvoker getInvoker() {
        return (IAjaxInvoker)this.m_aRWLock.readLockedGet(() -> this.m_aInvoker);
    }

    @Nonnull
    public void setInvoker(@Nonnull IAjaxInvoker iAjaxInvoker) {
        ValueEnforcer.notNull((Object)iAjaxInvoker, (String)"Invoker");
        this.m_aRWLock.writeLocked(() -> {
            this.m_aInvoker = iAjaxInvoker;
        });
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("Registry", (Object)this.m_aRegistry).append("Invoker", (Object)this.m_aInvoker).getToString();
    }
}

