/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.ajax.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.builder.IBuilder;
import com.helger.commons.factory.FactoryNewInstance;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.ajax.AjaxRegistry;
import com.helger.photon.ajax.decl.IAjaxFunctionDeclaration;
import com.helger.photon.ajax.executor.IAjaxExecutor;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AjaxFunctionDeclaration
implements IAjaxFunctionDeclaration {
    private final String m_sFunctionName;
    private final Supplier<? extends IAjaxExecutor> m_aExecutorFactory;
    private final Predicate<? super IRequestWebScopeWithoutResponse> m_aExecutionFilter;
    private final String m_sServletPath;
    private static final AtomicInteger FUN_COUNTER = new AtomicInteger(0);

    public AjaxFunctionDeclaration(@Nonnull @Nonempty String string, @Nonnull Supplier<? extends IAjaxExecutor> supplier, @Nullable Predicate<? super IRequestWebScopeWithoutResponse> predicate, @Nonnull @Nonempty String string2) {
        ValueEnforcer.isTrue((boolean)AjaxRegistry.isValidFunctionName(string), (String)"Invalid Ajax functionName provided");
        ValueEnforcer.notNull(supplier, (String)"ExecutorFactory");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"ServletPath");
        ValueEnforcer.isTrue((boolean)string2.startsWith("/"), (String)"Servlet path must start with /");
        ValueEnforcer.isTrue((boolean)string2.endsWith("/"), (String)"Servlet path must end with /");
        this.m_sFunctionName = string;
        this.m_aExecutorFactory = supplier;
        this.m_aExecutionFilter = predicate;
        this.m_sServletPath = string2;
    }

    @Nonnull
    @Nonempty
    public final String getName() {
        return this.m_sFunctionName;
    }

    @Override
    @Nonnull
    public final Supplier<? extends IAjaxExecutor> getExecutorFactory() {
        return this.m_aExecutorFactory;
    }

    @Override
    @Nullable
    public final Predicate<? super IRequestWebScopeWithoutResponse> getExecutionFilter() {
        return this.m_aExecutionFilter;
    }

    @Override
    public boolean canExecute(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse) {
        if (this.m_aExecutionFilter == null) {
            return true;
        }
        return this.m_aExecutionFilter.test((IRequestWebScopeWithoutResponse)iRequestWebScopeWithoutResponse);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAjaxServletPath() {
        return this.m_sServletPath;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("FunctionName", (Object)this.m_sFunctionName).append("ExecutorFactory", this.m_aExecutorFactory).appendIfNotNull("ExecutorFilter", this.m_aExecutionFilter).appendIfNotNull("ServletPath", (Object)this.m_sServletPath).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return AjaxFunctionDeclaration.builder(null);
    }

    public static int getUniqueFunctionID() {
        return FUN_COUNTER.incrementAndGet();
    }

    @Nonnull
    public static Builder builder(@Nullable String string) {
        Object object = StringHelper.hasText((String)string) ? string : "fun" + AjaxFunctionDeclaration.getUniqueFunctionID();
        return new Builder((String)object);
    }

    public static class Builder
    implements IBuilder<AjaxFunctionDeclaration> {
        private final String m_sFunctionName;
        private Supplier<? extends IAjaxExecutor> m_aExecutorFactory;
        private Predicate<? super IRequestWebScopeWithoutResponse> m_aExecutionFilter;
        private String m_sServletPath = "/ajax/";

        public Builder(@Nonnull @Nonempty String string) {
            ValueEnforcer.notEmpty((CharSequence)string, (String)"FunctionName");
            this.m_sFunctionName = string;
        }

        @Nonnull
        public final Builder executor(@Nonnull IAjaxExecutor iAjaxExecutor) {
            ValueEnforcer.notNull((Object)iAjaxExecutor, (String)"AjaxExecutor");
            return this.executor(() -> iAjaxExecutor);
        }

        @Nonnull
        public final Builder executor(@Nonnull Class<? extends IAjaxExecutor> clazz) {
            return this.executor((Supplier<? extends IAjaxExecutor>)FactoryNewInstance.create(clazz));
        }

        @Nonnull
        public final Builder executor(@Nonnull Supplier<? extends IAjaxExecutor> supplier) {
            ValueEnforcer.notNull(supplier, (String)"Supplier");
            this.m_aExecutorFactory = supplier;
            return this;
        }

        @Nonnull
        public final Builder filter(@Nonnull Predicate<? super IRequestWebScopeWithoutResponse> predicate) {
            ValueEnforcer.notNull(predicate, (String)"Filter");
            this.m_aExecutionFilter = predicate;
            return this;
        }

        @Nonnull
        public final Builder servletPath(@Nonnull @Nonempty String string) {
            ValueEnforcer.notEmpty((CharSequence)string, (String)"ServletPath");
            ValueEnforcer.isTrue((boolean)string.startsWith("/"), (String)"Servlet path must start with /");
            ValueEnforcer.isTrue((boolean)string.endsWith("/"), (String)"Servlet path must end with /");
            this.m_sServletPath = string;
            return this;
        }

        @Nonnull
        public AjaxFunctionDeclaration build() {
            return new AjaxFunctionDeclaration(this.m_sFunctionName, this.m_aExecutorFactory, this.m_aExecutionFilter, this.m_sServletPath);
        }
    }
}

