/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz;

import com.helger.commons.ValueEnforcer;
import com.helger.quartz.EIntervalUnit;
import com.helger.quartz.IScheduleBuilder;
import com.helger.quartz.ITrigger;
import com.helger.quartz.impl.triggers.CalendarIntervalTrigger;
import java.util.TimeZone;
import javax.annotation.Nonnull;

public class CalendarIntervalScheduleBuilder
implements IScheduleBuilder<CalendarIntervalTrigger> {
    private int m_nInterval = 1;
    private EIntervalUnit m_eIntervalUnit = EIntervalUnit.DAY;
    private ITrigger.EMisfireInstruction m_eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_SMART_POLICY;
    private TimeZone m_aTimeZone;
    private boolean m_bPreserveHourOfDayAcrossDaylightSavings;
    private boolean m_bSkipDayIfHourDoesNotExist;

    protected CalendarIntervalScheduleBuilder() {
    }

    @Nonnull
    public static CalendarIntervalScheduleBuilder calendarIntervalSchedule() {
        return new CalendarIntervalScheduleBuilder();
    }

    @Override
    @Nonnull
    public CalendarIntervalTrigger build() {
        CalendarIntervalTrigger calendarIntervalTrigger = new CalendarIntervalTrigger();
        calendarIntervalTrigger.setRepeatInterval(this.m_nInterval);
        calendarIntervalTrigger.setRepeatIntervalUnit(this.m_eIntervalUnit);
        calendarIntervalTrigger.setMisfireInstruction(this.m_eMisfireInstruction);
        calendarIntervalTrigger.setTimeZone(this.m_aTimeZone);
        calendarIntervalTrigger.setPreserveHourOfDayAcrossDaylightSavings(this.m_bPreserveHourOfDayAcrossDaylightSavings);
        calendarIntervalTrigger.setSkipDayIfHourDoesNotExist(this.m_bSkipDayIfHourDoesNotExist);
        return calendarIntervalTrigger;
    }

    @Nonnull
    public CalendarIntervalScheduleBuilder withInterval(int n, @Nonnull EIntervalUnit eIntervalUnit) {
        ValueEnforcer.notNull((Object)((Object)eIntervalUnit), (String)"Unit");
        CalendarIntervalScheduleBuilder._validateInterval(n);
        this.m_nInterval = n;
        this.m_eIntervalUnit = eIntervalUnit;
        return this;
    }

    @Nonnull
    public CalendarIntervalScheduleBuilder withIntervalInSeconds(int n) {
        CalendarIntervalScheduleBuilder._validateInterval(n);
        this.m_nInterval = n;
        this.m_eIntervalUnit = EIntervalUnit.SECOND;
        return this;
    }

    @Nonnull
    public CalendarIntervalScheduleBuilder withIntervalInMinutes(int n) {
        CalendarIntervalScheduleBuilder._validateInterval(n);
        this.m_nInterval = n;
        this.m_eIntervalUnit = EIntervalUnit.MINUTE;
        return this;
    }

    @Nonnull
    public CalendarIntervalScheduleBuilder withIntervalInHours(int n) {
        CalendarIntervalScheduleBuilder._validateInterval(n);
        this.m_nInterval = n;
        this.m_eIntervalUnit = EIntervalUnit.HOUR;
        return this;
    }

    @Nonnull
    public CalendarIntervalScheduleBuilder withIntervalInDays(int n) {
        CalendarIntervalScheduleBuilder._validateInterval(n);
        this.m_nInterval = n;
        this.m_eIntervalUnit = EIntervalUnit.DAY;
        return this;
    }

    @Nonnull
    public CalendarIntervalScheduleBuilder withIntervalInWeeks(int n) {
        CalendarIntervalScheduleBuilder._validateInterval(n);
        this.m_nInterval = n;
        this.m_eIntervalUnit = EIntervalUnit.WEEK;
        return this;
    }

    @Nonnull
    public CalendarIntervalScheduleBuilder withIntervalInMonths(int n) {
        CalendarIntervalScheduleBuilder._validateInterval(n);
        this.m_nInterval = n;
        this.m_eIntervalUnit = EIntervalUnit.MONTH;
        return this;
    }

    @Nonnull
    public CalendarIntervalScheduleBuilder withIntervalInYears(int n) {
        CalendarIntervalScheduleBuilder._validateInterval(n);
        this.m_nInterval = n;
        this.m_eIntervalUnit = EIntervalUnit.YEAR;
        return this;
    }

    @Nonnull
    public CalendarIntervalScheduleBuilder withMisfireHandlingInstructionIgnoreMisfires() {
        this.m_eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_IGNORE_MISFIRE_POLICY;
        return this;
    }

    @Nonnull
    public CalendarIntervalScheduleBuilder withMisfireHandlingInstructionDoNothing() {
        this.m_eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_DO_NOTHING;
        return this;
    }

    @Nonnull
    public CalendarIntervalScheduleBuilder withMisfireHandlingInstructionFireAndProceed() {
        this.m_eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_FIRE_ONCE_NOW;
        return this;
    }

    @Nonnull
    public CalendarIntervalScheduleBuilder inTimeZone(TimeZone timeZone) {
        this.m_aTimeZone = timeZone;
        return this;
    }

    @Nonnull
    public CalendarIntervalScheduleBuilder preserveHourOfDayAcrossDaylightSavings(boolean bl) {
        this.m_bPreserveHourOfDayAcrossDaylightSavings = bl;
        return this;
    }

    @Nonnull
    public CalendarIntervalScheduleBuilder skipDayIfHourDoesNotExist(boolean bl) {
        this.m_bSkipDayIfHourDoesNotExist = bl;
        return this;
    }

    private static void _validateInterval(int n) {
        ValueEnforcer.isGT0((int)n, (String)"TimeInterval");
    }
}

