/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.core;

import com.helger.quartz.IJob;
import com.helger.quartz.IJobDetail;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IScheduler;
import com.helger.quartz.ISchedulerListener;
import com.helger.quartz.ITrigger;
import com.helger.quartz.JobExecutionException;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.core.QuartzScheduler;
import com.helger.quartz.impl.JobExecutionContext;
import com.helger.quartz.spi.IOperableTrigger;
import com.helger.quartz.spi.TriggerFiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobRunShell
implements Runnable,
ISchedulerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobRunShell.class);
    protected JobExecutionContext m_aJEC;
    protected QuartzScheduler m_aQS;
    protected TriggerFiredBundle m_aFiredTriggerBundle;
    protected IScheduler m_aScheduler;
    protected volatile boolean m_bShutdownRequested = false;

    public JobRunShell(IScheduler iScheduler, TriggerFiredBundle triggerFiredBundle) {
        this.m_aScheduler = iScheduler;
        this.m_aFiredTriggerBundle = triggerFiredBundle;
    }

    @Override
    public void schedulerShuttingdown() {
        this.requestShutdown();
    }

    public void initialize(QuartzScheduler quartzScheduler) throws SchedulerException {
        this.m_aQS = quartzScheduler;
        IJob iJob = null;
        IJobDetail iJobDetail = this.m_aFiredTriggerBundle.getJobDetail();
        try {
            iJob = quartzScheduler.getJobFactory().newJob(this.m_aFiredTriggerBundle, this.m_aScheduler);
        }
        catch (SchedulerException schedulerException) {
            quartzScheduler.notifySchedulerListenersError("An error occured instantiating job to be executed. job= '" + iJobDetail.getKey() + "'", schedulerException);
            throw schedulerException;
        }
        catch (Exception exception) {
            SchedulerException schedulerException = new SchedulerException("Problem instantiating class '" + iJobDetail.getJobClass().getName() + "' - ", exception);
            quartzScheduler.notifySchedulerListenersError("An error occured instantiating job to be executed. job= '" + iJobDetail.getKey() + "'", schedulerException);
            throw schedulerException;
        }
        this.m_aJEC = new JobExecutionContext(this.m_aScheduler, this.m_aFiredTriggerBundle, iJob);
    }

    public void requestShutdown() {
        this.m_bShutdownRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block25: {
            this.m_aQS.addInternalSchedulerListener(this);
            try {
                ITrigger.ECompletedExecutionInstruction eCompletedExecutionInstruction;
                IOperableTrigger iOperableTrigger = (IOperableTrigger)this.m_aJEC.getTrigger();
                IJobDetail iJobDetail = this.m_aJEC.getJobDetail();
                while (true) {
                    long l;
                    IJob iJob;
                    JobExecutionException jobExecutionException;
                    block26: {
                        jobExecutionException = null;
                        iJob = this.m_aJEC.getJobInstance();
                        try {
                            this.begin();
                        }
                        catch (SchedulerException schedulerException) {
                            this.m_aQS.notifySchedulerListenersError("Error executing Job (" + this.m_aJEC.getJobDetail().getKey() + ": couldn't begin execution.", schedulerException);
                            break block25;
                        }
                        try {
                            if (!this._notifyListenersBeginning(this.m_aJEC)) {
                            }
                            break block26;
                        }
                        catch (VetoedException vetoedException) {
                            try {
                                ITrigger.ECompletedExecutionInstruction eCompletedExecutionInstruction2 = iOperableTrigger.executionComplete(this.m_aJEC, null);
                                this.m_aQS.notifyJobStoreJobVetoed(iOperableTrigger, iJobDetail, eCompletedExecutionInstruction2);
                                if (this.m_aJEC.getTrigger().getNextFireTime() == null) {
                                    this.m_aQS.notifySchedulerListenersFinalized(this.m_aJEC.getTrigger());
                                }
                                this.complete(true);
                                break block25;
                            }
                            catch (SchedulerException schedulerException) {
                                this.m_aQS.notifySchedulerListenersError("Error during veto of Job (" + this.m_aJEC.getJobDetail().getKey() + ": couldn't finalize execution.", schedulerException);
                            }
                        }
                        break block25;
                    }
                    long l2 = l = System.currentTimeMillis();
                    try {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Calling execute on job " + iJobDetail.getKey());
                        }
                        iJob.execute(this.m_aJEC);
                        l2 = System.currentTimeMillis();
                    }
                    catch (JobExecutionException jobExecutionException2) {
                        l2 = System.currentTimeMillis();
                        jobExecutionException = jobExecutionException2;
                        LOGGER.info("Job " + iJobDetail.getKey() + " threw a JobExecutionException: ", (Throwable)jobExecutionException);
                    }
                    catch (Exception exception) {
                        l2 = System.currentTimeMillis();
                        LOGGER.error("Job " + iJobDetail.getKey() + " threw an unhandled Exception: ", (Throwable)exception);
                        SchedulerException schedulerException = new SchedulerException("Job threw an unhandled exception.", exception);
                        this.m_aQS.notifySchedulerListenersError("Job (" + this.m_aJEC.getJobDetail().getKey() + " threw an exception.", schedulerException);
                        jobExecutionException = new JobExecutionException(schedulerException, false);
                    }
                    this.m_aJEC.setJobRunTime(l2 - l);
                    if (!this._notifyJobListenersComplete(this.m_aJEC, jobExecutionException)) {
                        break block25;
                    }
                    eCompletedExecutionInstruction = ITrigger.ECompletedExecutionInstruction.NOOP;
                    try {
                        eCompletedExecutionInstruction = iOperableTrigger.executionComplete(this.m_aJEC, jobExecutionException);
                    }
                    catch (Exception exception) {
                        SchedulerException schedulerException = new SchedulerException("Trigger threw an unhandled exception.", exception);
                        this.m_aQS.notifySchedulerListenersError("Please report this error to the Quartz developers.", schedulerException);
                    }
                    if (!this._notifyTriggerListenersComplete(this.m_aJEC, eCompletedExecutionInstruction)) {
                        break block25;
                    }
                    if (eCompletedExecutionInstruction == ITrigger.ECompletedExecutionInstruction.RE_EXECUTE_JOB) {
                        this.m_aJEC.incrementRefireCount();
                        try {
                            this.complete(false);
                        }
                        catch (SchedulerException schedulerException) {
                            this.m_aQS.notifySchedulerListenersError("Error executing Job (" + this.m_aJEC.getJobDetail().getKey() + ": couldn't finalize execution.", schedulerException);
                        }
                        continue;
                    }
                    try {
                        this.complete(true);
                    }
                    catch (SchedulerException schedulerException) {
                        this.m_aQS.notifySchedulerListenersError("Error executing Job (" + this.m_aJEC.getJobDetail().getKey() + ": couldn't finalize execution.", schedulerException);
                        continue;
                    }
                    break;
                }
                this.m_aQS.notifyJobStoreJobComplete(iOperableTrigger, iJobDetail, eCompletedExecutionInstruction);
            }
            finally {
                this.m_aQS.removeInternalSchedulerListener(this);
            }
        }
    }

    protected void begin() throws SchedulerException {
    }

    protected void complete(boolean bl) throws SchedulerException {
    }

    public void passivate() {
        this.m_aJEC = null;
        this.m_aQS = null;
    }

    private boolean _notifyListenersBeginning(IJobExecutionContext iJobExecutionContext) throws VetoedException {
        boolean bl = false;
        try {
            bl = this.m_aQS.notifyTriggerListenersFired(iJobExecutionContext);
        }
        catch (SchedulerException schedulerException) {
            this.m_aQS.notifySchedulerListenersError("Unable to notify TriggerListener(s) while firing trigger (Trigger and Job will NOT be fired!). trigger= " + iJobExecutionContext.getTrigger().getKey() + " job= " + iJobExecutionContext.getJobDetail().getKey(), schedulerException);
            return false;
        }
        if (bl) {
            try {
                this.m_aQS.notifyJobListenersWasVetoed(iJobExecutionContext);
            }
            catch (SchedulerException schedulerException) {
                this.m_aQS.notifySchedulerListenersError("Unable to notify JobListener(s) of vetoed execution while firing trigger (Trigger and Job will NOT be fired!). trigger= " + iJobExecutionContext.getTrigger().getKey() + " job= " + iJobExecutionContext.getJobDetail().getKey(), schedulerException);
            }
            throw new VetoedException();
        }
        try {
            this.m_aQS.notifyJobListenersToBeExecuted(iJobExecutionContext);
        }
        catch (SchedulerException schedulerException) {
            this.m_aQS.notifySchedulerListenersError("Unable to notify JobListener(s) of Job to be executed: (Job will NOT be executed!). trigger= " + iJobExecutionContext.getTrigger().getKey() + " job= " + iJobExecutionContext.getJobDetail().getKey(), schedulerException);
            return false;
        }
        return true;
    }

    private boolean _notifyJobListenersComplete(IJobExecutionContext iJobExecutionContext, JobExecutionException jobExecutionException) {
        try {
            this.m_aQS.notifyJobListenersWasExecuted(iJobExecutionContext, jobExecutionException);
        }
        catch (SchedulerException schedulerException) {
            this.m_aQS.notifySchedulerListenersError("Unable to notify JobListener(s) of Job that was executed: (error will be ignored). trigger= " + iJobExecutionContext.getTrigger().getKey() + " job= " + iJobExecutionContext.getJobDetail().getKey(), schedulerException);
            return false;
        }
        return true;
    }

    private boolean _notifyTriggerListenersComplete(IJobExecutionContext iJobExecutionContext, ITrigger.ECompletedExecutionInstruction eCompletedExecutionInstruction) {
        try {
            this.m_aQS.notifyTriggerListenersComplete(iJobExecutionContext, eCompletedExecutionInstruction);
        }
        catch (SchedulerException schedulerException) {
            this.m_aQS.notifySchedulerListenersError("Unable to notify TriggerListener(s) of Job that was executed: (error will be ignored). trigger= " + iJobExecutionContext.getTrigger().getKey() + " job= " + iJobExecutionContext.getJobDetail().getKey(), schedulerException);
            return false;
        }
        if (iJobExecutionContext.getTrigger().getNextFireTime() == null) {
            this.m_aQS.notifySchedulerListenersFinalized(iJobExecutionContext.getTrigger());
        }
        return true;
    }

    static class VetoedException
    extends Exception {
    }
}

