/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl;

import com.helger.quartz.ICalendar;
import com.helger.quartz.IJob;
import com.helger.quartz.IJobDetail;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IScheduler;
import com.helger.quartz.ITrigger;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.TriggerKey;
import com.helger.quartz.spi.IOperableTrigger;
import com.helger.quartz.spi.TriggerFiredBundle;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class JobExecutionContext
implements IJobExecutionContext {
    private transient IScheduler m_aScheduler;
    private final ITrigger m_aTrigger;
    private final IJobDetail m_aJobDetail;
    private final JobDataMap m_aJobDataMap;
    private transient IJob m_aJob;
    private final ICalendar m_aCalendar;
    private boolean m_bRecovering = false;
    private int m_nNumRefires = 0;
    private final Date m_aFireTime;
    private final Date m_aScheduledFireTime;
    private final Date m_aPrevFireTime;
    private final Date m_aNextFireTime;
    private long m_nJobRunTime = -1L;
    private Object m_aResult;
    private final Map<Object, Object> m_aData = new HashMap<Object, Object>();

    public JobExecutionContext(IScheduler iScheduler, TriggerFiredBundle triggerFiredBundle, IJob iJob) {
        this.m_aScheduler = iScheduler;
        this.m_aTrigger = triggerFiredBundle.getTrigger();
        this.m_aCalendar = triggerFiredBundle.getCalendar();
        this.m_aJobDetail = triggerFiredBundle.getJobDetail();
        this.m_aJob = iJob;
        this.m_bRecovering = triggerFiredBundle.isRecovering();
        this.m_aFireTime = triggerFiredBundle.getFireTime();
        this.m_aScheduledFireTime = triggerFiredBundle.getScheduledFireTime();
        this.m_aPrevFireTime = triggerFiredBundle.getPrevFireTime();
        this.m_aNextFireTime = triggerFiredBundle.getNextFireTime();
        this.m_aJobDataMap = new JobDataMap();
        this.m_aJobDataMap.putAll((Map)((Object)this.m_aJobDetail.getJobDataMap()));
        this.m_aJobDataMap.putAll((Map)((Object)this.m_aTrigger.getJobDataMap()));
    }

    @Override
    public IScheduler getScheduler() {
        return this.m_aScheduler;
    }

    @Override
    public ITrigger getTrigger() {
        return this.m_aTrigger;
    }

    @Override
    public ICalendar getCalendar() {
        return this.m_aCalendar;
    }

    @Override
    public boolean isRecovering() {
        return this.m_bRecovering;
    }

    @Override
    public TriggerKey getRecoveringTriggerKey() {
        if (this.isRecovering()) {
            return new TriggerKey(this.m_aJobDataMap.getAsString("QRTZ_FAILED_JOB_ORIG_TRIGGER_GROUP"), this.m_aJobDataMap.getAsString("QRTZ_FAILED_JOB_ORIG_TRIGGER_NAME"));
        }
        throw new IllegalStateException("Not a recovering job");
    }

    public void incrementRefireCount() {
        ++this.m_nNumRefires;
    }

    @Override
    public int getRefireCount() {
        return this.m_nNumRefires;
    }

    @Override
    public JobDataMap getMergedJobDataMap() {
        return this.m_aJobDataMap;
    }

    @Override
    public IJobDetail getJobDetail() {
        return this.m_aJobDetail;
    }

    @Override
    public IJob getJobInstance() {
        return this.m_aJob;
    }

    @Override
    public Date getFireTime() {
        return this.m_aFireTime;
    }

    @Override
    public Date getScheduledFireTime() {
        return this.m_aScheduledFireTime;
    }

    @Override
    public Date getPreviousFireTime() {
        return this.m_aPrevFireTime;
    }

    @Override
    public Date getNextFireTime() {
        return this.m_aNextFireTime;
    }

    public String toString() {
        return "JobExecutionContext: trigger: '" + this.getTrigger().getKey() + " job: " + this.getJobDetail().getKey() + " fireTime: '" + this.getFireTime() + " scheduledFireTime: " + this.getScheduledFireTime() + " previousFireTime: '" + this.getPreviousFireTime() + " nextFireTime: " + this.getNextFireTime() + " isRecovering: " + this.isRecovering() + " refireCount: " + this.getRefireCount();
    }

    @Override
    public Object getResult() {
        return this.m_aResult;
    }

    @Override
    public void setResult(Object object) {
        this.m_aResult = object;
    }

    @Override
    public long getJobRunTime() {
        return this.m_nJobRunTime;
    }

    public void setJobRunTime(long l) {
        this.m_nJobRunTime = l;
    }

    @Override
    public void put(Object object, Object object2) {
        this.m_aData.put(object, object2);
    }

    @Override
    public Object get(Object object) {
        return this.m_aData.get(object);
    }

    @Override
    public String getFireInstanceId() {
        return ((IOperableTrigger)this.m_aTrigger).getFireInstanceId();
    }
}

