/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl;

import com.helger.commons.concurrent.ThreadHelper;
import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.quartz.IScheduler;
import com.helger.quartz.ISchedulerFactory;
import com.helger.quartz.ISchedulerListener;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.impl.StdSchedulerFactory;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzServer
implements ISchedulerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzServer.class);
    private IScheduler sched;

    QuartzServer() {
    }

    public void serve(ISchedulerFactory iSchedulerFactory, boolean bl) throws Exception {
        this.sched = iSchedulerFactory.getScheduler();
        this.sched.start();
        ThreadHelper.sleep((long)3000L);
        LOGGER.info("\n*** The scheduler successfully started.");
        if (bl) {
            LOGGER.info("\n");
            LOGGER.info("The scheduler will now run until you type \"exit\"");
            LOGGER.info("   If it was configured to export itself via RMI,");
            LOGGER.info("   then other process may now use it.");
            NonBlockingBufferedReader nonBlockingBufferedReader = new NonBlockingBufferedReader((Reader)new InputStreamReader(System.in, StandardCharsets.ISO_8859_1));
            do {
                LOGGER.info("Type 'exit' to shutdown the server: ");
            } while (!"exit".equals(nonBlockingBufferedReader.readLine()));
            LOGGER.info("\n...Shutting down server...");
            this.sched.shutdown(true);
        }
    }

    @Override
    public void schedulerError(String string, SchedulerException schedulerException) {
        LOGGER.error("*** " + string, (Throwable)schedulerException);
    }

    @Override
    public void schedulerShutdown() {
        LOGGER.info("\n*** The scheduler is now shutdown.");
        this.sched = null;
    }

    public static void main(String[] stringArray) throws Exception {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }
        try {
            QuartzServer quartzServer = new QuartzServer();
            if (stringArray.length == 0) {
                quartzServer.serve(new StdSchedulerFactory(), false);
            } else if (stringArray.length == 1 && stringArray[0].equalsIgnoreCase("console")) {
                quartzServer.serve(new StdSchedulerFactory(), true);
            } else {
                LOGGER.info("\nUsage: QuartzServer [console]");
            }
        }
        catch (Exception exception) {
            LOGGER.error("Internal error", (Throwable)exception);
        }
    }
}

