/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl.triggers;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IScheduleBuilder;
import com.helger.quartz.ITrigger;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobExecutionException;
import com.helger.quartz.JobKey;
import com.helger.quartz.QCloneUtils;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.TriggerBuilder;
import com.helger.quartz.TriggerKey;
import com.helger.quartz.spi.IOperableTrigger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractTrigger<IMPLTYPE extends AbstractTrigger<IMPLTYPE>>
implements IOperableTrigger,
ICloneable<IMPLTYPE> {
    private String m_sName;
    private String m_sGroup = "DEFAULT";
    private String m_sJobName;
    private String m_sJobGroup = "DEFAULT";
    private String m_sDescription;
    private JobDataMap m_aJobDataMap;
    private String m_sCalendarName;
    private String m_sFireInstanceId;
    private ITrigger.EMisfireInstruction m_eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_SMART_POLICY;
    private int m_nPriority = 5;
    private transient TriggerKey m_aKey;

    protected AbstractTrigger(@Nonnull AbstractTrigger<IMPLTYPE> abstractTrigger) {
        ValueEnforcer.notNull(abstractTrigger, (String)"Other");
        this.m_sName = abstractTrigger.m_sName;
        this.m_sGroup = abstractTrigger.m_sGroup;
        this.m_sJobName = abstractTrigger.m_sJobName;
        this.m_sJobGroup = abstractTrigger.m_sJobGroup;
        this.m_sDescription = abstractTrigger.m_sDescription;
        this.m_aJobDataMap = QCloneUtils.getClone(abstractTrigger.m_aJobDataMap);
        this.m_sCalendarName = abstractTrigger.m_sCalendarName;
        this.m_sFireInstanceId = abstractTrigger.m_sFireInstanceId;
        this.m_eMisfireInstruction = abstractTrigger.m_eMisfireInstruction;
        this.m_nPriority = abstractTrigger.m_nPriority;
        this.m_aKey = abstractTrigger.m_aKey;
    }

    public AbstractTrigger() {
    }

    public AbstractTrigger(String string) {
        this.setName(string);
        this.setGroup(null);
    }

    public AbstractTrigger(String string, String string2) {
        this.setName(string);
        this.setGroup(string2);
    }

    public AbstractTrigger(String string, String string2, String string3, String string4) {
        this.setName(string);
        this.setGroup(string2);
        this.setJobName(string3);
        this.setJobGroup(string4);
    }

    public final String getName() {
        return this.m_sName;
    }

    public final void setName(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        ValueEnforcer.isFalse((boolean)string.trim().isEmpty(), (String)"Trigger name cannot be null or empty.");
        this.m_sName = string;
        this.m_aKey = null;
    }

    public final String getGroup() {
        return this.m_sGroup;
    }

    public final void setGroup(@Nullable String string) {
        if (string != null) {
            ValueEnforcer.isFalse((boolean)string.trim().isEmpty(), (String)"Group name cannot be an empty string.");
        }
        this.m_sGroup = string == null ? "DEFAULT" : string;
        this.m_aKey = null;
    }

    @Override
    public final void setKey(@Nonnull TriggerKey triggerKey) {
        this.setName(triggerKey.getName());
        this.setGroup(triggerKey.getGroup());
        this.m_aKey = triggerKey;
    }

    public final String getJobName() {
        return this.m_sJobName;
    }

    public final void setJobName(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"JobName");
        ValueEnforcer.isFalse((boolean)string.trim().isEmpty(), (String)"Job name cannot be null or empty.");
        this.m_sJobName = string;
    }

    public final String getJobGroup() {
        return this.m_sJobGroup;
    }

    public final void setJobGroup(@Nullable String string) {
        if (string != null) {
            ValueEnforcer.isFalse((boolean)string.trim().isEmpty(), (String)"Group name cannot be null or empty.");
        }
        this.m_sJobGroup = string == null ? "DEFAULT" : string;
    }

    @Override
    public final void setJobKey(@Nonnull JobKey jobKey) {
        this.setJobName(jobKey.getName());
        this.setJobGroup(jobKey.getGroup());
    }

    @Nonnull
    public final String getFullName() {
        return this.m_sGroup + "." + this.m_sName;
    }

    @Override
    @Nullable
    public final TriggerKey getKey() {
        if (this.m_aKey == null) {
            if (this.m_sName == null) {
                return null;
            }
            this.m_aKey = new TriggerKey(this.m_sName, this.m_sGroup);
        }
        return this.m_aKey;
    }

    @Override
    @Nullable
    public final JobKey getJobKey() {
        if (this.getJobName() == null) {
            return null;
        }
        return new JobKey(this.getJobName(), this.getJobGroup());
    }

    @Nonnull
    public final String getFullJobName() {
        return this.m_sJobGroup + "." + this.m_sJobName;
    }

    @Override
    @Nullable
    public final String getDescription() {
        return this.m_sDescription;
    }

    @Override
    public final void setDescription(@Nullable String string) {
        this.m_sDescription = string;
    }

    @Override
    @Nullable
    public final String getCalendarName() {
        return this.m_sCalendarName;
    }

    @Override
    public final void setCalendarName(@Nullable String string) {
        this.m_sCalendarName = string;
    }

    @Override
    @Nonnull
    public final JobDataMap getJobDataMap() {
        if (this.m_aJobDataMap == null) {
            this.m_aJobDataMap = new JobDataMap();
        }
        return this.m_aJobDataMap;
    }

    @Override
    public final void setJobDataMap(@Nullable JobDataMap jobDataMap) {
        this.m_aJobDataMap = jobDataMap;
    }

    @Override
    public final int getPriority() {
        return this.m_nPriority;
    }

    @Override
    public final void setPriority(int n) {
        this.m_nPriority = n;
    }

    @Override
    @Nonnull
    public ITrigger.ECompletedExecutionInstruction executionComplete(IJobExecutionContext iJobExecutionContext, @Nullable JobExecutionException jobExecutionException) {
        if (jobExecutionException != null) {
            if (jobExecutionException.refireImmediately()) {
                return ITrigger.ECompletedExecutionInstruction.RE_EXECUTE_JOB;
            }
            if (jobExecutionException.unscheduleFiringTrigger()) {
                return ITrigger.ECompletedExecutionInstruction.SET_TRIGGER_COMPLETE;
            }
            if (jobExecutionException.unscheduleAllTriggers()) {
                return ITrigger.ECompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_COMPLETE;
            }
        }
        if (!this.mayFireAgain()) {
            return ITrigger.ECompletedExecutionInstruction.DELETE_TRIGGER;
        }
        return ITrigger.ECompletedExecutionInstruction.NOOP;
    }

    @Override
    public final ITrigger.EMisfireInstruction getMisfireInstruction() {
        return this.m_eMisfireInstruction;
    }

    @Override
    public final void setMisfireInstruction(ITrigger.EMisfireInstruction eMisfireInstruction) {
        if (!this.validateMisfireInstruction(eMisfireInstruction)) {
            throw new IllegalArgumentException("The misfire instruction code is invalid for this type of trigger.");
        }
        this.m_eMisfireInstruction = eMisfireInstruction;
    }

    protected abstract boolean validateMisfireInstruction(ITrigger.EMisfireInstruction var1);

    @Override
    public void validate() throws SchedulerException {
        if (this.m_sName == null) {
            throw new SchedulerException("Trigger's name cannot be null");
        }
        if (this.m_sGroup == null) {
            throw new SchedulerException("Trigger's group cannot be null");
        }
        if (this.m_sJobName == null) {
            throw new SchedulerException("Trigger's related Job's name cannot be null");
        }
        if (this.m_sJobGroup == null) {
            throw new SchedulerException("Trigger's related Job's group cannot be null");
        }
    }

    @Override
    @Nullable
    public final String getFireInstanceId() {
        return this.m_sFireInstanceId;
    }

    @Override
    public final void setFireInstanceId(@Nullable String string) {
        this.m_sFireInstanceId = string;
    }

    public String toString() {
        return "Trigger '" + this.getFullName() + "':  triggerClass: '" + this.getClass().getName() + " calendar: '" + this.getCalendarName() + "' misfireInstruction: " + this.getMisfireInstruction() + " nextFireTime: " + this.getNextFireTime();
    }

    @Override
    public int compareTo(@Nonnull ITrigger iTrigger) {
        return CompareHelper.compare((Comparable)((Object)this.getKey()), (Comparable)((Object)iTrigger.getKey()), (boolean)false);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractTrigger abstractTrigger = (AbstractTrigger)object;
        return EqualsHelper.equals((Object)this.getKey(), (Object)abstractTrigger.getKey());
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.getKey()).getHashCode();
    }

    @Nonnull
    public TriggerBuilder<IMPLTYPE> getTriggerBuilder() {
        return TriggerBuilder.newTrigger().forJob(this.getJobKey()).modifiedByCalendar(this.getCalendarName()).usingJobData(this.getJobDataMap()).withDescription(this.getDescription()).endAt(this.getEndTime()).withIdentity(this.getKey()).withPriority(this.getPriority()).startAt(this.getStartTime()).withSchedule(this.getScheduleBuilder());
    }

    @Nonnull
    public abstract IScheduleBuilder<IMPLTYPE> getScheduleBuilder();
}

