/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.simpl;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.quartz.simpl.InitThreadContextClassLoadHelper;
import com.helger.quartz.simpl.LoadingLoaderClassLoadHelper;
import com.helger.quartz.simpl.SimpleClassLoadHelper;
import com.helger.quartz.simpl.ThreadContextClassLoadHelper;
import com.helger.quartz.spi.IClassLoadHelper;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CascadingClassLoadHelper
implements IClassLoadHelper {
    private ICommonsList<IClassLoadHelper> m_aLoadHelpers;
    private IClassLoadHelper m_aBestCandidate;

    @Override
    public void initialize() {
        this.m_aLoadHelpers = new CommonsArrayList();
        this.m_aLoadHelpers.add((Object)new LoadingLoaderClassLoadHelper());
        this.m_aLoadHelpers.add((Object)new SimpleClassLoadHelper());
        this.m_aLoadHelpers.add((Object)new ThreadContextClassLoadHelper());
        this.m_aLoadHelpers.add((Object)new InitThreadContextClassLoadHelper());
        for (IClassLoadHelper iClassLoadHelper : this.m_aLoadHelpers) {
            iClassLoadHelper.initialize();
        }
    }

    @Override
    @Nonnull
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        if (this.m_aBestCandidate != null) {
            try {
                return this.m_aBestCandidate.loadClass(string);
            }
            catch (Exception exception) {
                this.m_aBestCandidate = null;
            }
        }
        Exception exception = null;
        Class<?> clazz = null;
        IClassLoadHelper iClassLoadHelper2 = null;
        for (IClassLoadHelper iClassLoadHelper2 : this.m_aLoadHelpers) {
            try {
                clazz = iClassLoadHelper2.loadClass(string);
                break;
            }
            catch (Exception exception2) {
                exception = exception2;
            }
        }
        if (clazz == null) {
            if (exception instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)exception;
            }
            throw new ClassNotFoundException("Unable to load class " + string + " by any known loaders.", exception);
        }
        this.m_aBestCandidate = iClassLoadHelper2;
        return clazz;
    }

    @Override
    @Nonnull
    public <T> Class<? extends T> loadClass(String string, Class<T> clazz) throws ClassNotFoundException {
        return this.loadClass(string);
    }

    @Override
    @Nullable
    public URL getResource(String string) {
        URL uRL = null;
        if (this.m_aBestCandidate != null) {
            uRL = this.m_aBestCandidate.getResource(string);
            if (uRL != null) {
                return uRL;
            }
            this.m_aBestCandidate = null;
        }
        IClassLoadHelper iClassLoadHelper = null;
        Iterator iterator = this.m_aLoadHelpers.iterator();
        while (iterator.hasNext() && (uRL = (iClassLoadHelper = (IClassLoadHelper)iterator.next()).getResource(string)) == null) {
        }
        this.m_aBestCandidate = iClassLoadHelper;
        return uRL;
    }

    @Override
    @Nullable
    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        if (this.m_aBestCandidate != null) {
            inputStream = this.m_aBestCandidate.getResourceAsStream(string);
            if (inputStream != null) {
                return inputStream;
            }
            this.m_aBestCandidate = null;
        }
        IClassLoadHelper iClassLoadHelper = null;
        Iterator iterator = this.m_aLoadHelpers.iterator();
        while (iterator.hasNext() && (inputStream = (iClassLoadHelper = (IClassLoadHelper)iterator.next()).getResourceAsStream(string)) == null) {
        }
        this.m_aBestCandidate = iClassLoadHelper;
        return inputStream;
    }

    @Override
    @Nonnull
    public ClassLoader getClassLoader() {
        return this.m_aBestCandidate == null ? Thread.currentThread().getContextClassLoader() : this.m_aBestCandidate.getClassLoader();
    }
}

