/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.utils.counter.sampled;

import com.helger.quartz.utils.counter.sampled.ISampledRateCounter;
import com.helger.quartz.utils.counter.sampled.SampledCounter;
import com.helger.quartz.utils.counter.sampled.SampledRateCounterConfig;
import javax.annotation.Nonnull;

public class SampledRateCounter
extends SampledCounter
implements ISampledRateCounter {
    private static final String OPERATION_NOT_SUPPORTED_MSG = "This operation is not supported. Use SampledCounter Or Counter instead";
    private long m_nNumeratorValue;
    private long m_nDenominatorValue;

    public SampledRateCounter(@Nonnull SampledRateCounterConfig sampledRateCounterConfig) {
        super(sampledRateCounterConfig);
    }

    @Override
    public synchronized void setValue(long l, long l2) {
        this.m_nNumeratorValue = l;
        this.m_nDenominatorValue = l2;
    }

    @Override
    public synchronized void increment(long l, long l2) {
        this.m_nNumeratorValue += l;
        this.m_nDenominatorValue += l2;
    }

    @Override
    public synchronized void decrement(long l, long l2) {
        this.m_nNumeratorValue -= l;
        this.m_nDenominatorValue -= l2;
    }

    @Override
    public synchronized void setDenominatorValue(long l) {
        this.m_nDenominatorValue = l;
    }

    @Override
    public synchronized void setNumeratorValue(long l) {
        this.m_nNumeratorValue = l;
    }

    @Override
    public synchronized long getValue() {
        return this.m_nDenominatorValue == 0L ? 0L : this.m_nNumeratorValue / this.m_nDenominatorValue;
    }

    @Override
    public synchronized long getAndReset() {
        long l = this.getValue();
        this.setValue(0L, 0L);
        return l;
    }

    @Override
    public long getAndSet(long l) {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MSG);
    }

    @Override
    public synchronized void setValue(long l) {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MSG);
    }

    @Override
    public long decrement() {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MSG);
    }

    @Override
    public long decrement(long l) {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MSG);
    }

    public long getMaxValue() {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MSG);
    }

    public long getMinValue() {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MSG);
    }

    @Override
    public long increment() {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MSG);
    }

    @Override
    public long increment(long l) {
        throw new UnsupportedOperationException(OPERATION_NOT_SUPPORTED_MSG);
    }
}

